/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.SecurityCallback;
import org.icepdf.core.application.ProductInfo;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.io.ConservativeSizingByteArrayOutputStream;
import org.icepdf.core.io.RandomAccessFileInputStream;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.PDimension;
import org.icepdf.core.pobjects.PInfo;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.security.SecurityManager;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.LazyObjectLoader;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document {
    private static final Logger logger = Logger.getLogger(Document.class.toString());
    private Catalog catalog;
    private PTrailer pTrailer;
    private String origin;
    private String cachedFilePath;
    private SecurityCallback securityCallback;
    private static boolean isCachingEnabled = Defs.sysPropertyBoolean("org.icepdf.core.streamcache.enabled", true);
    private Library library = null;
    private SeekableInput documentSeekableInput;

    public static String getLibraryVersion() {
        return new StringBuffer().append(ProductInfo.PRIMARY).append(".").append(ProductInfo.SECONDARY).append(".").append(ProductInfo.TERTIARY).append(" ").append(ProductInfo.RELEASE_TYPE).toString();
    }

    private void setDocumentOrigin(String string) {
        this.origin = string;
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("MEMFREE: " + Runtime.getRuntime().freeMemory() + " of " + Runtime.getRuntime().totalMemory());
            logger.config("LOADING: " + string);
        }
    }

    private void setDocumentCachedFilePath(String string) {
        this.cachedFilePath = string;
    }

    private String getDocumentCachedFilePath() {
        return this.cachedFilePath;
    }

    public void setFile(String string) throws PDFException, PDFSecurityException, IOException {
        this.setDocumentOrigin(string);
        RandomAccessFileInputStream randomAccessFileInputStream = RandomAccessFileInputStream.build(new File(string));
        this.setInputStream(randomAccessFileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUrl(URL uRL) throws PDFException, PDFSecurityException, IOException {
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            String string = uRL.toString();
            this.setInputStream(inputStream, string);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public void setInputStream(InputStream inputStream, String string) throws PDFException, PDFSecurityException, IOException {
        this.setDocumentOrigin(string);
        if (!isCachingEnabled) {
            int n;
            ConservativeSizingByteArrayOutputStream conservativeSizingByteArrayOutputStream = new ConservativeSizingByteArrayOutputStream(102400, null);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                conservativeSizingByteArrayOutputStream.write(byArray, 0, n);
            }
            conservativeSizingByteArrayOutputStream.flush();
            conservativeSizingByteArrayOutputStream.close();
            int n2 = conservativeSizingByteArrayOutputStream.size();
            conservativeSizingByteArrayOutputStream.trim();
            byte[] byArray2 = conservativeSizingByteArrayOutputStream.relinquishByteArray();
            SeekableByteArrayInputStream seekableByteArrayInputStream = new SeekableByteArrayInputStream(byArray2, 0, n2);
            this.setInputStream(seekableByteArrayInputStream);
        } else {
            int n;
            File file = File.createTempFile("ICEpdfTempFile" + this.getClass().hashCode(), ".tmp");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath(), true);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            this.setDocumentCachedFilePath(file.getAbsolutePath());
            RandomAccessFileInputStream randomAccessFileInputStream = RandomAccessFileInputStream.build(file);
            this.setInputStream(randomAccessFileInputStream);
        }
    }

    public void setByteArray(byte[] byArray, int n, int n2, String string) throws PDFException, PDFSecurityException, IOException {
        this.setDocumentOrigin(string);
        if (!isCachingEnabled) {
            SeekableByteArrayInputStream seekableByteArrayInputStream = new SeekableByteArrayInputStream(byArray, n, n2);
            this.setInputStream(seekableByteArrayInputStream);
        } else {
            File file = File.createTempFile("ICEpdfTempFile" + this.getClass().hashCode(), ".tmp");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath(), true);
            fileOutputStream.write(byArray, n, n2);
            fileOutputStream.flush();
            fileOutputStream.close();
            this.setDocumentCachedFilePath(file.getAbsolutePath());
            RandomAccessFileInputStream randomAccessFileInputStream = RandomAccessFileInputStream.build(file);
            this.setInputStream(randomAccessFileInputStream);
        }
    }

    public void setInputStream(SeekableInput seekableInput, String string) throws PDFException, PDFSecurityException, IOException {
        this.setDocumentOrigin(string);
        this.setInputStream(seekableInput);
    }

    private void setInputStream(SeekableInput seekableInput) throws PDFException, PDFSecurityException, IOException {
        try {
            boolean bl;
            block12: {
                this.documentSeekableInput = seekableInput;
                this.library = new Library();
                bl = false;
                try {
                    this.loadDocumentViaXRefs(seekableInput);
                    bl = true;
                }
                catch (PDFException pDFException) {
                    throw pDFException;
                }
                catch (PDFSecurityException pDFSecurityException) {
                    throw pDFSecurityException;
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(Level.WARNING)) break block12;
                    logger.warning("Cross reference deferred loading failed, will fall back to linear reading.");
                }
            }
            if (!bl) {
                if (this.catalog != null) {
                    this.catalog.dispose(false);
                    this.catalog = null;
                }
                if (this.library != null) {
                    this.library.dispose();
                    this.library = null;
                }
                this.library = new Library();
                this.pTrailer = null;
                seekableInput.seekAbsolute(0L);
                this.loadDocumentViaLinearTraversal(seekableInput.getInputStream());
            }
            this.catalog.init();
        }
        catch (PDFException pDFException) {
            logger.log(Level.FINE, "Error loading PDF file during linear parse.", pDFException);
            this.dispose();
            throw pDFException;
        }
        catch (PDFSecurityException pDFSecurityException) {
            this.dispose();
            throw pDFSecurityException;
        }
        catch (IOException iOException) {
            this.dispose();
            throw iOException;
        }
        catch (Exception exception) {
            this.dispose();
            throw new IOException(exception.getMessage());
        }
    }

    private void loadDocumentViaXRefs(SeekableInput seekableInput) throws PDFException, PDFSecurityException, IOException {
        Object object;
        long l = this.getInitialCrossReferencePosition(seekableInput);
        PTrailer pTrailer = null;
        if (l > 0L) {
            PTrailer pTrailer2;
            seekableInput.seekAbsolute(l);
            object = new Parser(seekableInput);
            Object object2 = ((Parser)object).getObject(this.library);
            if (object2 instanceof PObject) {
                object2 = ((PObject)object2).getObject();
            }
            if ((pTrailer2 = (PTrailer)object2) == null) {
                throw new RuntimeException("Could not find trailer");
            }
            if (pTrailer2.getPrimaryCrossReference() == null) {
                throw new RuntimeException("Could not find cross reference");
            }
            if (pTrailer == null) {
                pTrailer = pTrailer2;
            } else {
                pTrailer.addPreviousTrailer(pTrailer2);
            }
        }
        if (pTrailer == null) {
            throw new RuntimeException("Could not find document trailer");
        }
        object = new LazyObjectLoader(this.library, seekableInput, pTrailer.getPrimaryCrossReference());
        this.library.setLazyObjectLoader((LazyObjectLoader)object);
        this.pTrailer = pTrailer;
        this.catalog = pTrailer.getRootCatalog();
        this.library.setCatalog(this.catalog);
        if (this.catalog == null) {
            throw new NullPointerException("Loading via xref failed to find catalog");
        }
        boolean bl = this.makeSecurityManager(pTrailer);
        if (bl) {
            this.attemptAuthorizeSecurityManager();
        }
    }

    private long getInitialCrossReferencePosition(SeekableInput seekableInput) throws IOException {
        seekableInput.seekEnd();
        long l = seekableInput.getAbsolutePosition();
        long l2 = -1L;
        String string = "startxref";
        int n = string.length() - 1;
        for (long i = l - 1L; i >= 0L && l - i < 2048L; --i) {
            seekableInput.seekAbsolute(i);
            int n2 = seekableInput.read();
            if (n2 < 0) {
                throw new EOFException("Could not find startxref at end of file");
            }
            if (n2 == string.charAt(n)) {
                if (n == 0) {
                    l2 = i + (long)string.length();
                    break;
                }
                --n;
                continue;
            }
            n = string.length() - 1;
        }
        if (l2 < 0L) {
            throw new EOFException("Could not find startxref near end of file");
        }
        seekableInput.seekAbsolute(l2);
        Parser parser = new Parser(seekableInput);
        Number number = (Number)parser.getToken();
        if (number == null) {
            throw new RuntimeException("Could not find ending cross reference position");
        }
        return number.longValue();
    }

    private void loadDocumentViaLinearTraversal(InputStream inputStream) throws PDFException, PDFSecurityException {
        boolean bl;
        Object object;
        Object object2;
        this.skipPastAnyPrefixJunk(inputStream);
        this.library.setLinearTraversal();
        Parser parser = new Parser(inputStream);
        Object object3 = null;
        while ((object2 = parser.getObject(this.library)) != null) {
            Object object4;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(object2.getClass().getName() + " " + object2);
            }
            if (object2 instanceof PObject && (object4 = ((PObject)(object = (PObject)object2)).getObject()) != null) {
                object2 = object4;
            }
            if (object2 instanceof Catalog) {
                this.catalog = (Catalog)object2;
            }
            if (!(object2 instanceof PTrailer)) continue;
            if (object3 == null) {
                object3 = (PTrailer)object2;
                continue;
            }
            object = (PTrailer)object2;
            ((PTrailer)object3).addNextTrailer((PTrailer)object);
            object3 = object;
        }
        if (object3 != null) {
            object = new LazyObjectLoader(this.library, null, ((PTrailer)object3).getPrimaryCrossReference());
            this.library.setLazyObjectLoader((LazyObjectLoader)object);
        }
        this.pTrailer = object3;
        this.library.setCatalog(this.catalog);
        if (object3 != null && (bl = this.makeSecurityManager((PTrailer)object3))) {
            this.attemptAuthorizeSecurityManager();
        }
    }

    private void skipPastAnyPrefixJunk(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            return;
        }
        try {
            int n = 0;
            boolean bl = false;
            inputStream.mark(2048);
            for (int i = 0; i < 2048; ++i) {
                int n2 = inputStream.read();
                if (n2 < 0) {
                    inputStream.reset();
                    return;
                }
                if (bl) {
                    if (!Parser.isWhitespace((char)n2)) continue;
                    return;
                }
                if (n2 == "%PDF-1.".charAt(n)) {
                    if (++n != "%PDF-1.".length()) continue;
                    bl = true;
                    continue;
                }
                n = 0;
            }
            inputStream.reset();
        }
        catch (IOException iOException) {
            try {
                inputStream.reset();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
    }

    private boolean makeSecurityManager(PTrailer pTrailer) throws PDFSecurityException {
        boolean bl = false;
        Hashtable hashtable = pTrailer.getEncrypt();
        Vector vector = pTrailer.getID();
        if (hashtable != null && vector != null) {
            this.library.securityManager = new SecurityManager(this.library, hashtable, vector);
            bl = true;
        }
        return bl;
    }

    private void attemptAuthorizeSecurityManager() throws PDFSecurityException {
        block5: {
            if (!this.library.securityManager.isAuthorized("")) {
                int n = 1;
                do {
                    String string;
                    if (this.securityCallback != null) {
                        string = this.securityCallback.requestPassword(this);
                        if (string == null) {
                            throw new PDFSecurityException("Encryption error");
                        }
                    } else {
                        throw new PDFSecurityException("Encryption error");
                    }
                    if (this.library.securityManager.isAuthorized(string)) break block5;
                } while (++n <= 3);
                throw new PDFSecurityException("Encryption error");
            }
        }
        this.library.setEncrypted(true);
    }

    public PDimension getPageDimension(int n, float f) {
        Page page = this.catalog.getPageTree().getPage(n, this);
        PDimension pDimension = page.getSize(f);
        this.catalog.getPageTree().releasePage(page, (Object)this);
        return pDimension;
    }

    public PDimension getPageDimension(int n, float f, float f2) {
        Page page = this.catalog.getPageTree().getPage(n, this);
        if (page != null) {
            PDimension pDimension = page.getSize(f, f2);
            this.catalog.getPageTree().releasePage(page, (Object)this);
            return pDimension;
        }
        return new PDimension(0, 0);
    }

    public String getDocumentOrigin() {
        return this.origin;
    }

    public String getDocumentLocation() {
        if (this.cachedFilePath != null) {
            return this.cachedFilePath;
        }
        return this.origin;
    }

    public int getNumberOfPages() {
        try {
            return this.catalog.getPageTree().getNumberOfPages();
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error getting number of pages.", exception);
            return 0;
        }
    }

    public void paintPage(int n, Graphics graphics, int n2, int n3, float f, float f2) {
        Page page = this.catalog.getPageTree().getPage(n, this);
        PDimension pDimension = page.getSize(f, f2);
        int n4 = (int)pDimension.getWidth();
        int n5 = (int)pDimension.getHeight();
        Graphics graphics2 = graphics.create(0, 0, n4, n5);
        page.paint(graphics2, n2, n3, f, f2);
        graphics2.dispose();
        this.catalog.getPageTree().releasePage(page, (Object)this);
    }

    public void dispose() {
        File file;
        boolean bl;
        String string;
        if (this.catalog != null) {
            this.catalog.dispose(false);
            this.catalog = null;
        }
        if (this.library != null) {
            this.library.dispose();
            this.library = null;
        }
        this.pTrailer = null;
        if (this.documentSeekableInput != null) {
            try {
                this.documentSeekableInput.close();
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "Error closing document input stream.", iOException);
            }
            this.documentSeekableInput = null;
        }
        if ((string = this.getDocumentCachedFilePath()) != null && !(bl = (file = new File(string)).delete()) && logger.isLoggable(Level.WARNING)) {
            logger.warning("Error deleting URL cached to file " + string);
        }
    }

    public void writeToOutputStream(OutputStream outputStream) throws IOException {
        long l = this.documentSeekableInput.getLength();
        SeekableInputConstrainedWrapper seekableInputConstrainedWrapper = new SeekableInputConstrainedWrapper(this.documentSeekableInput, 0L, l, false);
        try {
            int n;
            seekableInputConstrainedWrapper.prepareForCurrentUse();
            byte[] byArray = new byte[4096];
            while ((n = seekableInputConstrainedWrapper.read(byArray, 0, byArray.length)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "Error writting PDF output stream.", throwable);
            throw new IOException(throwable.getMessage());
        }
        finally {
            try {
                seekableInputConstrainedWrapper.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Image getPageImage(int n, int n2, int n3, float f, float f2) {
        Page page = this.catalog.getPageTree().getPage(n, this);
        PDimension pDimension = page.getSize(n3, f, f2);
        int n4 = (int)pDimension.getWidth();
        int n5 = (int)pDimension.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        page.paint(graphics2D, n2, n3, f, f2);
        graphics2D.dispose();
        this.catalog.getPageTree().releasePage(page, (Object)this);
        return bufferedImage;
    }

    public Vector<StringBuffer> getPageText(int n) {
        PageTree pageTree = this.catalog.getPageTree();
        if (n >= 0 && n < pageTree.getNumberOfPages()) {
            Page page = pageTree.getPage(n, this);
            Vector<StringBuffer> vector = page.getText();
            this.catalog.getPageTree().releasePage(page, (Object)this);
            return vector;
        }
        return new Vector<StringBuffer>();
    }

    public SecurityManager getSecurityManager() {
        return this.library.securityManager;
    }

    public void setSecurityCallback(SecurityCallback securityCallback) {
        this.securityCallback = securityCallback;
    }

    public PInfo getInfo() {
        if (this.pTrailer == null) {
            return null;
        }
        return this.pTrailer.getInfo();
    }

    public Vector getPageImages(int n) {
        Page page = this.catalog.getPageTree().getPage(n, this);
        Vector vector = page.getImages();
        this.catalog.getPageTree().releasePage(page, (Object)this);
        return vector;
    }

    public PageTree getPageTree() {
        return this.catalog.getPageTree();
    }

    public Catalog getCatalog() {
        return this.catalog;
    }
}

