/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableContent {
    private String content;
    private HttpResponse contentSource;
    private Document document;
    private final GadgetHtmlParser contentParser;
    private final Map<String, Object> pipelinedData;
    private static final String MUTABLE_CONTENT_LISTENER = "MutableContentListener";

    public static void notifyEdit(Document doc) {
        MutableContent mc = (MutableContent)doc.getUserData(MUTABLE_CONTENT_LISTENER);
        if (mc != null) {
            mc.documentChanged();
        }
    }

    public MutableContent(GadgetHtmlParser contentParser, String content) {
        this.contentParser = contentParser;
        this.content = content;
        this.pipelinedData = Maps.newHashMap();
    }

    public MutableContent(GadgetHtmlParser contentParser, HttpResponse contentSource) {
        this.contentParser = contentParser;
        this.contentSource = contentSource;
        this.pipelinedData = Maps.newHashMap();
    }

    public String getContent() {
        if (this.content == null) {
            if (this.contentSource != null) {
                this.content = this.contentSource.getResponseAsString();
                this.contentSource = null;
            } else if (this.document != null) {
                this.content = HtmlSerialization.serialize(this.document);
            }
        }
        return this.content;
    }

    public void setContent(String newContent) {
        if (this.content == null || !this.content.equals(newContent)) {
            this.content = newContent;
            this.document = null;
            this.contentSource = null;
        }
    }

    public void documentChanged() {
        if (this.document != null) {
            this.content = null;
            this.contentSource = null;
        }
    }

    public Document getDocument() {
        if (this.document != null) {
            return this.document;
        }
        try {
            this.document = this.contentParser.parseDom(this.getContent());
            this.document.setUserData(MUTABLE_CONTENT_LISTENER, this, null);
        }
        catch (GadgetException e) {
            return null;
        }
        return this.document;
    }

    public boolean hasDocument() {
        return this.document != null;
    }

    public void addPipelinedData(String key, Object value) {
        this.pipelinedData.put(key, value);
    }

    public Map<String, Object> getPipelinedData() {
        return this.pipelinedData;
    }
}

