/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.Outlines;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.util.Library;

public class Catalog
extends Dictionary {
    private static final Logger logger = Logger.getLogger(Catalog.class.toString());
    private PageTree pageTree;
    private Outlines outlines;
    private NameTree nameTree;
    private Dictionary dests;
    private boolean outlinesInited = false;
    private boolean namesTreeInited = false;
    private boolean destsInited = false;

    public Catalog(Library library, Hashtable hashtable) {
        super(library, hashtable);
    }

    public void init() {
        Object object = this.library.getObject(this.entries, "Pages");
        this.pageTree = null;
        if (object instanceof PageTree) {
            this.pageTree = (PageTree)object;
        } else if (object instanceof Hashtable) {
            this.pageTree = new PageTree(this.library, (Hashtable)object);
        }
        try {
            this.pageTree.init();
            this.pageTree.initRootPageTree();
        }
        catch (NullPointerException nullPointerException) {
            logger.log(Level.FINE, "Error parsing page tree.", nullPointerException);
        }
    }

    public void dispose(boolean bl) {
        if (this.nameTree != null) {
            this.nameTree.dispose();
            this.namesTreeInited = false;
            if (!bl) {
                this.nameTree = null;
            }
        }
        if (this.pageTree != null) {
            this.pageTree.dispose(bl);
            if (!bl) {
                this.pageTree = null;
            }
        }
        if (this.outlines != null && !bl) {
            this.outlines.dispose();
            this.outlines = null;
        }
    }

    public PageTree getPageTree() {
        return this.pageTree;
    }

    public Outlines getOutlines() {
        if (!this.outlinesInited) {
            this.outlinesInited = true;
            Object object = this.library.getObject(this.entries, "Outlines");
            if (object != null) {
                this.outlines = new Outlines(this.library, (Hashtable)object);
            }
        }
        return this.outlines;
    }

    public NameTree getNameTree() {
        if (!this.namesTreeInited) {
            Hashtable hashtable;
            Object object;
            this.namesTreeInited = true;
            Object object2 = this.library.getObject(this.entries, "Names");
            if (object2 != null && object2 instanceof Hashtable && (object = this.library.getObject(hashtable = (Hashtable)object2, "Dests")) != null && object instanceof Hashtable) {
                this.nameTree = new NameTree(this.library, (Hashtable)object);
                this.nameTree.init();
            }
        }
        return this.nameTree;
    }

    public Dictionary getDestinations() {
        if (!this.destsInited) {
            this.destsInited = true;
            Object object = this.library.getObject(this.entries, "Dests");
            if (object != null) {
                this.dests = new Dictionary(this.library, (Hashtable)object);
                this.dests.init();
            }
        }
        return this.dests;
    }

    public String toString() {
        return "CATALOG= " + this.entries.toString();
    }

    static {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("ICEsoft ICEpdf Core " + Document.getLibraryVersion());
        }
    }
}

