/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.events.PaintPageEvent;
import org.icepdf.core.events.PaintPageListener;
import org.icepdf.core.io.SequenceInputStream;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.PDimension;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.util.ContentParser;
import org.icepdf.core.util.GraphicsRenderingHints;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.MemoryManageable;
import org.icepdf.core.views.swing.PageViewComponentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page
extends Dictionary
implements MemoryManageable {
    private static final Logger logger = Logger.getLogger(Page.class.toString());
    public static final int BOUNDARY_MEDIABOX = 1;
    public static final int BOUNDARY_CROPBOX = 2;
    public static final int BOUNDARY_BLEEDBOX = 3;
    public static final int BOUNDARY_TRIMBOX = 4;
    public static final int BOUNDARY_ARTBOX = 5;
    private boolean isInited = false;
    private final Object isInitedLock = new Object();
    private Resources resources;
    private Vector<Annotation> annotation;
    private Vector<Stream> contents;
    private Shapes shapes = null;
    private Vector<StringBuffer> extractedText;
    private Vector<PaintPageListener> paintPageListeners = new Vector();
    private PRectangle mediaBox;
    private PRectangle cropBox;
    private PRectangle bleedBox;
    private PRectangle trimBox;
    private PRectangle artBox;
    private float pageRotation = 0.0f;

    public Page(Library library, Hashtable hashtable) {
        super(library, hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose(boolean bl) {
        Object object = this.isInitedLock;
        synchronized (object) {
            if (this.isInited) {
                this.isInited = false;
                if (this.annotation != null) {
                    this.annotation.clear();
                }
                if (this.contents != null) {
                    Enumeration<Stream> enumeration = this.contents.elements();
                    while (enumeration.hasMoreElements()) {
                        Stream stream = enumeration.nextElement();
                        if (!(stream instanceof Stream)) continue;
                        Stream stream2 = stream;
                        stream2.dispose(bl);
                    }
                    this.contents.clear();
                }
                if (this.shapes != null) {
                    this.shapes.dispose();
                    this.shapes = null;
                }
                if (this.extractedText != null) {
                    this.extractedText.clear();
                    this.extractedText = null;
                }
                if (this.resources != null) {
                    this.resources.dispose(bl);
                    this.resources = null;
                }
            }
            if (this.paintPageListeners != null) {
                this.paintPageListeners.clear();
            }
        }
    }

    public boolean isInitiated() {
        return this.isInited;
    }

    private void initPageContents() {
        Object object = this.library.getObject(this.entries, "Contents");
        if (object instanceof Stream) {
            this.contents = new Vector();
            Stream stream = (Stream)object;
            stream.setPObjectReference(this.library.getObjectReference(this.entries, "Contents"));
            this.contents.addElement(stream);
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            this.contents = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                Stream stream = (Stream)this.library.getObject((Reference)vector.elementAt(i));
                stream.setPObjectReference((Reference)vector.elementAt(i));
                this.contents.addElement(stream);
            }
        }
    }

    private void initPageResources() {
        Resources resources = this.library.getResources(this.entries, "Resources");
        if (resources == null) {
            for (PageTree pageTree = this.getParent(); pageTree != null; pageTree = pageTree.getParent()) {
                Resources resources2 = pageTree.getResources();
                if (resources2 == null) continue;
                resources = resources2;
                break;
            }
        }
        this.resources = resources;
    }

    private void initPageAnnotations() {
        Object object = this.library.getObject(this.entries, "Annots");
        if (object != null && object instanceof Vector) {
            Vector vector = (Vector)object;
            this.annotation = new Vector(vector.size() + 1);
            Annotation annotation = null;
            for (int i = 0; i < vector.size(); ++i) {
                Object object2 = vector.elementAt(i);
                if (object2 instanceof Reference) {
                    Reference reference = (Reference)vector.elementAt(i);
                    object2 = this.library.getObject(reference);
                }
                if (object2 instanceof Annotation) {
                    annotation = (Annotation)object2;
                } else if (object2 instanceof Hashtable) {
                    annotation = Annotation.buildAnnotation(this.library, (Hashtable)object2);
                }
                this.annotation.addElement(annotation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        if (this.isInited) {
            return;
        }
        Object object = this.isInitedLock;
        synchronized (object) {
            this.initPageResources();
            this.initPageAnnotations();
            this.initPageContents();
            if (this.contents != null) {
                Vector<InputStream> vector = new Vector<InputStream>(this.contents.size());
                int n = this.contents.size();
                for (int i = 0; i < n; ++i) {
                    Stream stream = this.contents.elementAt(i);
                    InputStream inputStream = stream.getInputStreamForDecodedStreamBytes();
                    vector.add(inputStream);
                }
                SequenceInputStream sequenceInputStream = new SequenceInputStream(vector.iterator());
                try {
                    ContentParser contentParser = new ContentParser(this.library, this.resources);
                    this.shapes = contentParser.parse(sequenceInputStream);
                }
                catch (Exception exception) {
                    this.shapes = new Shapes();
                    logger.log(Level.FINE, "Error initializing Page.", exception);
                }
                finally {
                    try {
                        sequenceInputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.log(Level.FINE, "Error closing page stream.", iOException);
                    }
                }
            } else {
                this.shapes = new Shapes();
            }
            this.isInited = true;
        }
    }

    public void paint(Graphics graphics, int n, int n2, float f, float f2) {
        this.paint(graphics, n, n2, f, f2, null);
    }

    public void paint(Graphics graphics, int n, int n2, float f, float f2, PageViewComponentImpl.PagePainter pagePainter) {
        this.paint(graphics, n, n2, f, f2, pagePainter, true);
    }

    public void paint(Graphics graphics, int n, int n2, float f, float f2, PageViewComponentImpl.PagePainter pagePainter, boolean bl) {
        Cloneable cloneable;
        if (!this.isInited) {
            this.init();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        GraphicsRenderingHints graphicsRenderingHints = GraphicsRenderingHints.getDefault();
        graphics2D.setRenderingHints(graphicsRenderingHints.getRenderingHints(n));
        AffineTransform affineTransform = this.getPageTransform(n2, f, f2);
        graphics2D.transform(affineTransform);
        PRectangle pRectangle = this.getPageBoundary(n2);
        float f3 = 0.0f - pRectangle.x;
        float f4 = 0.0f - (pRectangle.y - pRectangle.height);
        Color color = graphicsRenderingHints.getPageBackgroundColor(n);
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect((int)(0.0f - f3), (int)(0.0f - f4), (int)pRectangle.width, (int)pRectangle.height);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(-f3, -f4, pRectangle.width, pRectangle.height);
        Shape shape = graphics2D.getClip();
        if (shape == null) {
            graphics2D.setClip(double_);
        } else {
            cloneable = new Area(shape);
            cloneable.intersect(new Area(double_));
            graphics2D.setClip((Shape)((Object)cloneable));
        }
        if (this.shapes != null) {
            cloneable = graphics2D.getTransform();
            Shape shape2 = graphics2D.getClip();
            this.shapes.setPageParent(this);
            this.shapes.paint(graphics2D, pagePainter);
            this.shapes.setPageParent(null);
            graphics2D.setTransform((AffineTransform)cloneable);
            graphics2D.setClip(shape2);
        }
        if (this.annotation != null && bl) {
            float f5 = this.getTotalRotation(f);
            int n3 = this.annotation.size();
            for (int i = 0; i < n3; ++i) {
                Annotation annotation = this.annotation.get(i);
                annotation.render(graphics2D, n, f5, f2, false);
            }
        }
        this.notifyPaintPageListeners();
    }

    public AffineTransform getPageTransform(int n, float f, float f2) {
        AffineTransform affineTransform = new AffineTransform();
        Rectangle2D.Double double_ = this.getBoundingBox(n, f, f2);
        affineTransform.translate(0.0, double_.getHeight());
        affineTransform.scale(1.0, -1.0);
        affineTransform.scale(f2, f2);
        float f3 = this.getTotalRotation(f);
        PRectangle pRectangle = this.getPageBoundary(n);
        if (f3 != 0.0f) {
            double d;
            if (f3 == 90.0f) {
                affineTransform.translate(pRectangle.height, 0.0);
            } else if (f3 == 180.0f) {
                affineTransform.translate(pRectangle.width, pRectangle.height);
            } else if (f3 == 270.0f) {
                affineTransform.translate(0.0, pRectangle.width);
            } else if (f3 > 0.0f && f3 < 90.0f) {
                d = (double)pRectangle.height * Math.cos(Math.toRadians(90.0f - f3));
                affineTransform.translate(d, 0.0);
            } else if (f3 > 90.0f && f3 < 180.0f) {
                d = Math.toRadians(180.0f - f3);
                double d2 = Math.cos(d);
                double d3 = Math.sin(d);
                double d4 = (double)pRectangle.height * d3 + (double)pRectangle.width * d2;
                double d5 = (double)pRectangle.height * d2;
                affineTransform.translate(d4, d5);
            } else if (f3 > 180.0f && f3 < 270.0f) {
                d = Math.toRadians(f3 - 180.0f);
                double d6 = Math.cos(d);
                double d7 = Math.sin(d);
                double d8 = (double)pRectangle.width * d6;
                double d9 = (double)pRectangle.width * d7 + (double)pRectangle.height * d6;
                affineTransform.translate(d8, d9);
            } else if (f3 > 270.0f && f3 < 360.0f) {
                d = (double)pRectangle.width * Math.cos(Math.toRadians(f3 - 270.0f));
                affineTransform.translate(0.0, d);
            }
        }
        affineTransform.rotate((double)f3 * Math.PI / 180.0);
        float f4 = 0.0f - pRectangle.x;
        float f5 = 0.0f - (pRectangle.y - pRectangle.height);
        affineTransform.translate(f4, f5);
        return affineTransform;
    }

    public Shape getPageShape(int n, float f, float f2) {
        AffineTransform affineTransform = this.getPageTransform(n, f, f2);
        PRectangle pRectangle = this.getPageBoundary(n);
        float f3 = 0.0f - pRectangle.x;
        float f4 = 0.0f - (pRectangle.y - pRectangle.height);
        Rectangle2D.Double double_ = new Rectangle2D.Double(-f3, -f4, pRectangle.width, pRectangle.height);
        GeneralPath generalPath = new GeneralPath(double_);
        return generalPath.createTransformedShape(affineTransform);
    }

    protected Reference getParentReference() {
        return (Reference)this.entries.get("Parent");
    }

    public PageTree getParent() {
        return (PageTree)this.library.getObject(this.entries, "Parent");
    }

    public PDimension getSize(float f) {
        return this.getSize(2, f, 1.0f);
    }

    public PDimension getSize(float f, float f2) {
        return this.getSize(2, f, f2);
    }

    public PDimension getSize(int n, float f, float f2) {
        float f3 = this.getTotalRotation(f);
        PRectangle pRectangle = this.getPageBoundary(n);
        float f4 = pRectangle.width * f2;
        float f5 = pRectangle.height * f2;
        if (f3 != 0.0f && f3 != 180.0f) {
            if (f3 == 90.0f || f3 == 270.0f) {
                float f6 = f4;
                f4 = f5;
                f5 = f6;
            } else {
                AffineTransform affineTransform = new AffineTransform();
                double d = Math.toRadians(f3);
                affineTransform.rotate(d);
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                Point2D.Double double_2 = new Point2D.Double();
                Point2D.Double double_3 = new Point2D.Double();
                double_2.setLocation(0.0, f5);
                affineTransform.transform(double_2, double_3);
                double_.add(double_3);
                double_2.setLocation(f4, f5);
                affineTransform.transform(double_2, double_3);
                double_.add(double_3);
                double_2.setLocation(0.0, 0.0);
                affineTransform.transform(double_2, double_3);
                double_.add(double_3);
                double_2.setLocation(f4, 0.0);
                affineTransform.transform(double_2, double_3);
                double_.add(double_3);
                f4 = (float)double_.getWidth();
                f5 = (float)double_.getHeight();
            }
        }
        return new PDimension(f4, f5);
    }

    public Rectangle2D.Double getBoundingBox(float f) {
        return this.getBoundingBox(2, f, 1.0f);
    }

    public Rectangle2D.Double getBoundingBox(float f, float f2) {
        return this.getBoundingBox(2, f, f2);
    }

    public Rectangle2D.Double getBoundingBox(int n, float f, float f2) {
        float f3 = this.getTotalRotation(f);
        PRectangle pRectangle = this.getPageBoundary(n);
        float f4 = pRectangle.width * f2;
        float f5 = pRectangle.height * f2;
        AffineTransform affineTransform = new AffineTransform();
        double d = Math.toRadians(f3);
        affineTransform.rotate(d);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        double_2.setLocation(0.0, f5);
        affineTransform.transform(double_2, double_3);
        double_.add(double_3);
        double_2.setLocation(f4, f5);
        affineTransform.transform(double_2, double_3);
        double_.add(double_3);
        double_2.setLocation(0.0, 0.0);
        affineTransform.transform(double_2, double_3);
        double_.add(double_3);
        double_2.setLocation(f4, 0.0);
        affineTransform.transform(double_2, double_3);
        double_.add(double_3);
        return double_;
    }

    public PRectangle getPageBoundary(int n) {
        PRectangle pRectangle = null;
        if (n == 1) {
            pRectangle = (PRectangle)this.getMediaBox();
        } else if (n == 2) {
            pRectangle = (PRectangle)this.getCropBox();
        } else if (n == 3) {
            if (this.bleedBox != null) {
                pRectangle = (PRectangle)this.getBleedBox();
            }
        } else if (n == 4) {
            if (this.trimBox != null) {
                pRectangle = (PRectangle)this.getTrimBox();
            }
        } else if (n == 5) {
            if (this.artBox != null) {
                pRectangle = (PRectangle)this.getArtBox();
            }
        } else {
            pRectangle = this.cropBox;
        }
        if (pRectangle == null) {
            pRectangle = (PRectangle)this.getCropBox();
        }
        return pRectangle;
    }

    @Override
    public String toString() {
        return "PAGE= " + this.entries.toString();
    }

    public float getTotalRotation(float f) {
        float f2 = this.getPageRotation() + f;
        if ((f2 %= 360.0f) < 0.0f) {
            f2 += 360.0f;
        }
        if (f2 >= -0.001f && f2 <= 0.001f) {
            return 0.0f;
        }
        if (f2 >= 89.99f && f2 <= 90.001f) {
            return 90.0f;
        }
        if (f2 >= 179.99f && f2 <= 180.001f) {
            return 180.0f;
        }
        if (f2 >= 269.99f && f2 <= 270.001f) {
            return 270.0f;
        }
        return f2;
    }

    private float getPageRotation() {
        Object object = this.library.getObject(this.entries, "Rotate");
        if (object != null) {
            this.pageRotation = ((Number)object).floatValue();
        } else {
            for (PageTree pageTree = this.getParent(); pageTree != null; pageTree = pageTree.getParent()) {
                if (!pageTree.isRotationFactor) continue;
                this.pageRotation = pageTree.rotationFactor;
                break;
            }
        }
        this.pageRotation = 360.0f - this.pageRotation;
        this.pageRotation %= 360.0f;
        return this.pageRotation;
    }

    public Vector getAnnotations() {
        if (!this.isInited) {
            this.init();
        }
        return this.annotation;
    }

    public Rectangle2D.Float getMediaBox() {
        Vector vector = (Vector)this.library.getObject(this.entries, "MediaBox");
        if (vector != null) {
            this.mediaBox = new PRectangle(vector);
        }
        if (this.mediaBox == null) {
            for (PageTree pageTree = this.getParent(); pageTree != null && this.mediaBox == null; pageTree = pageTree.getParent()) {
                this.mediaBox = pageTree.getMediaBox();
            }
        }
        return this.mediaBox;
    }

    public Rectangle2D.Float getCropBox() {
        Object object;
        Vector vector = (Vector)this.library.getObject(this.entries, "CropBox");
        if (vector != null) {
            this.cropBox = new PRectangle(vector);
        }
        if (this.cropBox == null) {
            for (object = this.getParent(); object != null && this.cropBox == null && ((PageTree)object).getCropBox() != null; object = ((PageTree)object).getParent()) {
                this.cropBox = ((PageTree)object).getCropBox();
            }
        }
        object = (PRectangle)this.getMediaBox();
        if (this.cropBox == null && object != null) {
            this.cropBox = (PRectangle)((RectangularShape)object).clone();
        } else if (object != null) {
            this.cropBox = ((PRectangle)object).createCartesianIntersection(this.cropBox);
        }
        return this.cropBox;
    }

    public Rectangle2D.Float getArtBox() {
        Vector vector = (Vector)this.library.getObject(this.entries, "ArtBox");
        if (vector != null) {
            this.artBox = new PRectangle(vector);
        }
        if (this.artBox == null) {
            this.artBox = (PRectangle)this.getCropBox();
        }
        return this.artBox;
    }

    public Rectangle2D.Float getBleedBox() {
        Vector vector = (Vector)this.library.getObject(this.entries, "BleedBox");
        if (vector != null) {
            this.bleedBox = new PRectangle(vector);
        }
        if (this.bleedBox == null) {
            this.bleedBox = (PRectangle)this.getCropBox();
        }
        return this.bleedBox;
    }

    public Rectangle2D.Float getTrimBox() {
        Vector vector = (Vector)this.library.getObject(this.entries, "TrimBox");
        if (vector != null) {
            this.trimBox = new PRectangle(vector);
        }
        if (this.trimBox == null) {
            this.trimBox = (PRectangle)this.getCropBox();
        }
        return this.trimBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<StringBuffer> getText() {
        if (this.extractedText != null) {
            return this.extractedText;
        }
        if (this.contents == null) {
            this.initPageContents();
        }
        if (this.resources == null) {
            this.initPageResources();
        }
        if (this.contents != null) {
            Vector<InputStream> vector = new Vector<InputStream>(this.contents.size());
            int n = this.contents.size();
            for (int i = 0; i < n; ++i) {
                Stream stream = this.contents.elementAt(i);
                InputStream inputStream = stream.getInputStreamForDecodedStreamBytes();
                vector.add(inputStream);
            }
            SequenceInputStream sequenceInputStream = new SequenceInputStream(vector.iterator());
            try {
                ContentParser contentParser = new ContentParser(this.library, this.resources);
                this.extractedText = contentParser.parseTextBlocks(sequenceInputStream);
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Error getting page text.", exception);
            }
            finally {
                try {
                    sequenceInputStream.close();
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, "Error closing page stream.", iOException);
                }
            }
        }
        return this.extractedText;
    }

    public Vector getImages() {
        if (!this.isInited) {
            this.init();
        }
        return this.shapes.getImages();
    }

    public Resources getResources() {
        return this.resources;
    }

    @Override
    public void reduceMemory() {
        this.dispose(true);
    }

    public synchronized void addPaintPageListener(PaintPageListener paintPageListener) {
        if (!this.paintPageListeners.contains(paintPageListener)) {
            this.paintPageListeners.addElement(paintPageListener);
        }
    }

    public synchronized void removePaintPageListener(PaintPageListener paintPageListener) {
        if (this.paintPageListeners.contains(paintPageListener)) {
            this.paintPageListeners.removeElement(paintPageListener);
        }
    }

    public void notifyPaintPageListeners() {
        PaintPageEvent paintPageEvent = new PaintPageEvent(this);
        for (int i = this.paintPageListeners.size() - 1; i >= 0; --i) {
            PaintPageListener paintPageListener = this.paintPageListeners.elementAt(i);
            paintPageListener.paintPage(paintPageEvent);
        }
    }
}

