/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.taxonomy.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.impl.ActionConfig;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyAlreadyExistsException;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyConfig;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxonomyPlugin
extends BaseComponentPlugin {
    private String workspace = null;
    private String path = "";
    private String treeName = "";
    private List<TaxonomyConfig.Permission> permissions = new ArrayList<TaxonomyConfig.Permission>(4);
    private boolean autoCreateInNewRepository_ = true;
    private RepositoryService repositoryService_;
    private TaxonomyService taxonomyService_;
    private String baseTaxonomiesStorage_;
    private ActionServiceContainer actionServiceContainer_;
    private InitParams params_;
    static final String MIX_AFFECTED_NODETYPE = "mix:affectedNodeTypes".intern();
    static final String AFFECTED_NODETYPE = "exo:affectedNodeTypeNames".intern();
    static final String ALL_DOCUMENT_TYPES = "ALL_DOCUMENT_TYPES".intern();
    private DMSConfiguration dmsConfiguration_;
    private static final Log LOG = ExoLogger.getLogger(TaxonomyPlugin.class);

    public TaxonomyPlugin(InitParams params, RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, TaxonomyService taxonomyService, ActionServiceContainer actionServiceContainer, DMSConfiguration dmsConfiguration) throws Exception {
        this.repositoryService_ = repositoryService;
        this.baseTaxonomiesStorage_ = nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
        this.taxonomyService_ = taxonomyService;
        this.actionServiceContainer_ = actionServiceContainer;
        this.params_ = params;
        ValueParam autoCreated = this.params_.getValueParam("autoCreateInNewRepository");
        ValueParam workspaceParam = this.params_.getValueParam("workspace");
        ValueParam pathParam = this.params_.getValueParam("path");
        ValueParam nameParam = this.params_.getValueParam("treeName");
        if (autoCreated != null) {
            this.autoCreateInNewRepository_ = Boolean.parseBoolean(autoCreated.getValue());
        }
        if (workspaceParam != null) {
            this.workspace = workspaceParam.getValue();
        }
        this.path = pathParam == null ? this.baseTaxonomiesStorage_ : pathParam.getValue();
        if (nameParam != null) {
            this.treeName = nameParam.getValue();
        }
        this.dmsConfiguration_ = dmsConfiguration;
    }

    public void init(String repository) throws Exception {
        if (!this.autoCreateInNewRepository_) {
            return;
        }
        this.importPredefineTaxonomies(repository);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<TaxonomyConfig.Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<TaxonomyConfig.Permission> permissions) {
        this.permissions = permissions;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    private void importPredefineTaxonomies(String repository) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig(repository);
        if (this.workspace == null) {
            this.setWorkspace(dmsRepoConfig.getSystemWorkspace());
        } else if (!manageableRepository.isWorkspaceInitialized(this.workspace)) {
            this.setWorkspace(dmsRepoConfig.getSystemWorkspace());
        }
        Session session = manageableRepository.getSystemSession(this.getWorkspace());
        Node taxonomyStorageNode = (Node)session.getItem(this.path);
        if (taxonomyStorageNode.hasProperty("exo:isImportedChildren")) {
            session.logout();
            return;
        }
        taxonomyStorageNode.setProperty("exo:isImportedChildren", true);
        Iterator it = this.params_.getObjectParamIterator();
        Node taxonomyStorageNodeSystem = Utils.makePath(taxonomyStorageNode, this.treeName, "exo:taxonomy", null);
        session.save();
        while (it.hasNext()) {
            Object config;
            ObjectParameter objectParam = (ObjectParameter)it.next();
            if (objectParam.getName().equals("permission.configuration")) {
                config = (TaxonomyConfig)objectParam.getObject();
                for (TaxonomyConfig.Taxonomy taxonomy : ((TaxonomyConfig)config).getTaxonomies()) {
                    Map mapPermissions = this.getPermissions(taxonomy.getPermissions());
                    if (mapPermissions != null) {
                        ((ExtendedNode)taxonomyStorageNodeSystem).setPermissions(mapPermissions);
                    }
                    if (!taxonomyStorageNodeSystem.canAddMixin("mix:referenceable")) continue;
                    taxonomyStorageNodeSystem.addMixin("mix:referenceable");
                }
                continue;
            }
            if (objectParam.getName().equals("taxonomy.configuration")) {
                config = (TaxonomyConfig)objectParam.getObject();
                for (TaxonomyConfig.Taxonomy taxonomy : ((TaxonomyConfig)config).getTaxonomies()) {
                    Node taxonomyNode = Utils.makePath(taxonomyStorageNodeSystem, taxonomy.getPath(), "exo:taxonomy", this.getPermissions(taxonomy.getPermissions()));
                    String systemUser = SystemIdentity.SYSTEM;
                    if (!this.containsUser(taxonomy.getPermissions(), systemUser)) {
                        if (taxonomyNode.canAddMixin("exo:privilegeable")) {
                            taxonomyNode.addMixin("exo:privilegeable");
                        }
                        ((ExtendedNode)taxonomyNode).setPermission(systemUser, PermissionType.ALL);
                    }
                    if (taxonomyNode.canAddMixin("mix:referenceable")) {
                        taxonomyNode.addMixin("mix:referenceable");
                    }
                    taxonomyNode.getSession().save();
                }
                continue;
            }
            if (!objectParam.getName().equals("predefined.actions")) continue;
            config = (ActionConfig)objectParam.getObject();
            List actions = ((ActionConfig)config).getActions();
            for (ActionConfig.TaxonomyAction action : actions) {
                this.addAction(action, taxonomyStorageNodeSystem, repository);
            }
        }
        taxonomyStorageNode.save();
        try {
            this.taxonomyService_.addTaxonomyTree(taxonomyStorageNodeSystem);
        }
        catch (TaxonomyAlreadyExistsException e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        session.save();
        session.logout();
    }

    private boolean containsUser(List<TaxonomyConfig.Permission> permissions, String userName) {
        if (userName == null) {
            return false;
        }
        for (TaxonomyConfig.Permission permission : permissions) {
            if (!userName.equals(permission.getIdentity())) continue;
            return true;
        }
        return false;
    }

    private void addAction(ActionConfig.TaxonomyAction action, Node srcNode, String repository) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageRepo = repositoryService.getRepository(repository);
        TemplateService templateService = (TemplateService)container.getComponentInstanceOfType(TemplateService.class);
        HashMap<String, JcrInputProperty> sortedInputs = new HashMap<String, JcrInputProperty>();
        JcrInputProperty jcrInputName = new JcrInputProperty();
        jcrInputName.setJcrPath("/node/exo:name");
        jcrInputName.setValue(action.getName());
        sortedInputs.put("/node/exo:name", jcrInputName);
        JcrInputProperty jcrInputDes = new JcrInputProperty();
        jcrInputDes.setJcrPath("/node/exo:description");
        jcrInputDes.setValue(action.getDescription());
        sortedInputs.put("/node/exo:description", jcrInputDes);
        JcrInputProperty jcrInputLife = new JcrInputProperty();
        jcrInputLife.setJcrPath("/node/exo:lifecyclePhase");
        jcrInputLife.setValue(action.getLifecyclePhase().toArray(new String[0]));
        sortedInputs.put("/node/exo:lifecyclePhase", jcrInputLife);
        JcrInputProperty jcrInputHomePath = new JcrInputProperty();
        jcrInputHomePath.setJcrPath("/node/exo:storeHomePath");
        jcrInputHomePath.setValue(action.getHomePath());
        sortedInputs.put("/node/exo:storeHomePath", jcrInputHomePath);
        JcrInputProperty jcrInputTargetWspace = new JcrInputProperty();
        jcrInputTargetWspace.setJcrPath("/node/exo:targetWorkspace");
        jcrInputTargetWspace.setValue(action.getTargetWspace());
        sortedInputs.put("/node/exo:targetWorkspace", jcrInputTargetWspace);
        JcrInputProperty jcrInputTargetPath = new JcrInputProperty();
        jcrInputTargetPath.setJcrPath("/node/exo:targetPath");
        jcrInputTargetPath.setValue(action.getTargetPath());
        sortedInputs.put("/node/exo:targetPath", jcrInputTargetPath);
        JcrInputProperty rootProp = (JcrInputProperty)sortedInputs.get("/node");
        if (rootProp == null) {
            rootProp = new JcrInputProperty();
            rootProp.setJcrPath("/node");
            rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
            sortedInputs.put("/node", rootProp);
        } else {
            rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
        }
        this.actionServiceContainer_.addAction(srcNode, repository, action.getType(), sortedInputs);
        Node actionNode = this.actionServiceContainer_.getAction(srcNode, action.getName());
        if (action.getRoles() != null) {
            String[] roles = StringUtils.split((String)action.getRoles(), (String)";");
            actionNode.setProperty("exo:roles", roles);
        }
        for (ActionConfig.Mixin mixin : action.getMixins()) {
            actionNode.addMixin(mixin.getName());
            Map<String, String> props = mixin.getParsedProperties();
            Set<String> keys = props.keySet();
            NodeType nodeType = manageRepo.getNodeTypeManager().getNodeType(mixin.getName());
            block1: for (String key : keys) {
                for (PropertyDefinition pro : nodeType.getPropertyDefinitions()) {
                    if (!pro.getName().equals(key)) continue;
                    if (pro.isMultiple()) {
                        String value = props.get(key);
                        if (value == null) continue block1;
                        actionNode.setProperty(key, value.split(","));
                        continue block1;
                    }
                    actionNode.setProperty(key, props.get(key));
                    continue block1;
                }
            }
        }
        actionNode.getSession().save();
    }

    public Map getPermissions(List<TaxonomyConfig.Permission> listPermissions) {
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        for (TaxonomyConfig.Permission permission : listPermissions) {
            StringBuilder strPer = new StringBuilder();
            if ("true".equals(permission.getRead())) {
                strPer.append("read");
            }
            if ("true".equals(permission.getAddNode())) {
                strPer.append(",").append("add_node");
            }
            if ("true".equals(permission.getSetProperty())) {
                strPer.append(",").append("set_property");
            }
            if ("true".equals(permission.getRemove())) {
                strPer.append(",").append("remove");
            }
            permissionsMap.put(permission.getIdentity(), strPer.toString().split(","));
        }
        return permissionsMap;
    }

    public void init() throws Exception {
        if (this.autoCreateInNewRepository_) {
            for (RepositoryEntry repositoryEntry : this.repositoryService_.getConfig().getRepositoryConfigurations()) {
                this.importPredefineTaxonomies(repositoryEntry.getName());
            }
            return;
        }
        ValueParam param = this.params_.getValueParam("repository");
        String repository = null;
        repository = param == null ? this.repositoryService_.getDefaultRepository().getConfiguration().getName() : param.getValue();
        this.importPredefineTaxonomies(repository);
    }
}

