/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.connector.BaseConnector;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/rss/")
public class RssConnector
extends BaseConnector
implements ResourceContainer {
    private static String WORKSPACE = "workspace".intern();
    private static String REPOSITORY = "repository".intern();
    private static String RSS_VERSION = "rss_2.0".intern();
    private static String FEED_TITLE = "exo:feedTitle".intern();
    private static String DESCRIPTION = "exo:description".intern();
    private static String TITLE = "exo:title";
    private static String LINK = "exo:link".intern();
    private static String QUERY_PATH = "exo:queryPath".intern();
    private static String SUMMARY = "exo:summary";
    private RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
    private WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)WCMCoreUtils.getService(WCMConfigurationService.class);
    private String categoryPath;
    private static Log log = ExoLogger.getLogger(RssConnector.class);

    @GET
    @Path(value="/generate/")
    public Response generate(@QueryParam(value="repository") String repositoryName, @QueryParam(value="workspace") String workspaceName, @QueryParam(value="server") String server, @QueryParam(value="siteName") String siteName, @QueryParam(value="categoryPath") String categoryPath, @QueryParam(value="recursive") String recursive, @QueryParam(value="desc") String desc) throws Exception {
        this.categoryPath = categoryPath;
        String currentCat = categoryPath;
        if (currentCat.lastIndexOf("/") != -1) {
            currentCat = currentCat.substring(currentCat.lastIndexOf("/") + 1);
        }
        HashMap<String, String> contextRss = new HashMap<String, String>();
        contextRss.put(REPOSITORY, repositoryName);
        contextRss.put(WORKSPACE, workspaceName);
        contextRss.put("actionName", "actionName");
        contextRss.put(RSS_VERSION, "rss_2.0");
        contextRss.put(FEED_TITLE, currentCat);
        if (desc == null) {
            desc = "Powered by eXo WCM 2.0";
        }
        contextRss.put(DESCRIPTION, desc);
        String query = "select * from exo:taxonomyLink where jcr:path like '%/" + siteName + "/categories/" + categoryPath + "/%'";
        if (recursive == null || "false".equals(recursive)) {
            query = query + " and not jcr:path like '%/" + siteName + "/categories/" + categoryPath + "/%/%'";
        }
        query = query + " order by exo:dateCreated DESC";
        contextRss.put(QUERY_PATH, query);
        contextRss.put(LINK, server + "/" + PortalContainer.getCurrentPortalContainerName() + "/public/" + siteName);
        String feedXML = this.generateRSS(contextRss);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(feedXML.getBytes()));
        Response response = Response.ok((Object)new DOMSource(document), (String)"text/xml").build();
        return response;
    }

    private String generateRSS(Map<String, String> context) {
        String actionName = context.get("actionName");
        String workspace = context.get(WORKSPACE);
        String rssVersion = context.get(RSS_VERSION);
        String feedTitle = context.get(FEED_TITLE);
        String feedDescription = context.get(DESCRIPTION);
        String queryPath = context.get(QUERY_PATH);
        String feedLink = context.get(LINK);
        String repository = context.get(REPOSITORY);
        if (feedTitle == null || feedTitle.length() == 0) {
            feedTitle = actionName;
        }
        try {
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            Session session = sessionProvider.getSession(workspace, this.repositoryService.getRepository(repository));
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryPath, "sql");
            QueryResult queryResult = query.execute();
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(rssVersion);
            feed.setTitle(feedTitle.replaceAll("&nbsp;", " "));
            feed.setLink(feedLink);
            feed.setDescription(feedDescription.replaceAll("&nbsp;", " "));
            feed.setEncoding("UTF-8");
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node symlink = iter.nextNode();
                Node realnode = session.getNodeByUUID(symlink.getProperty("exo:uuid").getString());
                String url = this.getEntryUrl(feedLink, symlink.getName());
                SyndEntryImpl entry = new SyndEntryImpl();
                if (realnode.hasProperty(TITLE)) {
                    entry.setTitle(realnode.getProperty(TITLE).getString());
                } else {
                    entry.setTitle("");
                }
                entry.setLink(url);
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                if (realnode.hasProperty(SUMMARY)) {
                    description.setValue(realnode.getProperty(SUMMARY).getString().replaceAll("&nbsp;", " "));
                } else {
                    description.setValue("");
                }
                entry.setDescription((SyndContent)description);
                entries.add(entry);
                entry.getEnclosures();
            }
            feed.setEntries(entries);
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString((SyndFeed)feed);
            feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
            return feedXML;
        }
        catch (Exception e) {
            log.error((Object)"Error when perform generateRSS: ", e.fillInStackTrace());
            return null;
        }
    }

    private String getEntryUrl(String host, String nodeName) {
        String pcvPageUri = this.wcmConfigurationService.getRuntimeContextParam("parameterizedPageURI");
        return host + pcvPageUri + "/" + this.categoryPath + "/" + nodeName;
    }

    @Override
    protected String getContentStorageType() throws Exception {
        return null;
    }

    @Override
    protected Node getRootContentStorage(Node node) throws Exception {
        return null;
    }
}

