/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.filter;

import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.webui.ext.filter.UIExtensionAbstractFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsNotLockedFilter
extends UIExtensionAbstractFilter {
    private boolean checkGroup = false;

    public IsNotLockedFilter() {
        this(null);
    }

    public IsNotLockedFilter(String messageKey) {
        super(messageKey, UIExtensionFilterType.MANDATORY);
    }

    public IsNotLockedFilter(boolean checkGroup) {
        this(null);
        this.checkGroup = checkGroup;
    }

    public boolean accept(Map<String, Object> context) throws Exception {
        String lockToken;
        if (context == null) {
            return true;
        }
        Node currentNode = (Node)context.get(Node.class.getName());
        if (!currentNode.isLocked()) {
            return true;
        }
        String string = lockToken = this.checkGroup ? LockUtil.getLockToken((Node)currentNode) : LockUtil.getLockTokenOfUser((Node)currentNode);
        if (lockToken != null) {
            currentNode.getSession().addLockToken(LockUtil.getLockToken((Node)currentNode));
            return true;
        }
        return false;
    }

    public void onDeny(Map<String, Object> context) throws Exception {
        if (context == null) {
            return;
        }
        Node currentNode = (Node)context.get(Node.class.getName());
        Object[] arg = new Object[]{currentNode.getPath()};
        this.createUIPopupMessages(context, "UIPopupMenu.msg.node-locked", arg);
    }
}

