/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.core.NodeIdentifier;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.search.PaginatedQueryResult;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.selector.content.UIContentSelector;
import org.exoplatform.wcm.webui.viewer.UIContentViewer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(events={@EventConfig(listeners={SelectActionListener.class}), @EventConfig(listeners={ViewActionListener.class})})
public class UIContentSearchResult
extends UIGrid {
    public static final String TITLE = "title".intern();
    public static final String NODE_EXPECT = "excerpt".intern();
    public static final String SCORE = "score".intern();
    public static final String CREATE_DATE = "CreateDate".intern();
    public static final String PUBLICATION_STATE = "publicationstate".intern();
    public static final String NODE_PATH = "path".intern();
    public String[] Actions = new String[]{"Select", "View"};
    public String[] BEAN_FIELDS = new String[]{TITLE, SCORE, PUBLICATION_STATE};

    public UIContentSearchResult() throws Exception {
        this.configure(NODE_PATH, this.BEAN_FIELDS, this.Actions);
        this.getUIPageIterator().setId("UIWCMSearchResultPaginator");
    }

    public DateFormat getDateFormat() {
        Locale locale = new Locale(Util.getUIPortal().getLocale());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, locale);
        return dateFormat;
    }

    public void updateGrid(PaginatedQueryResult paginatedResult) throws Exception {
        this.getUIPageIterator().setPageList((PageList)paginatedResult);
    }

    public String getTitleNode(Node node) throws Exception {
        return node.hasProperty("exo:title") ? node.getProperty("exo:title").getValue().getString() : node.getName();
    }

    public Date getCreateDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar cal = node.getProperty("exo:dateCreated").getValue().getDate();
            return cal.getTime();
        }
        return null;
    }

    public String getExpect(String expect) {
        expect = expect.replaceAll("<[^>]*/?>", "");
        return expect;
    }

    public String getCurrentState(Node node) throws Exception {
        PublicationService pubService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        return pubService.getCurrentState(node);
    }

    public Session getSession() throws Exception {
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository maRepository = repoService.getCurrentRepository();
        String repository = maRepository.getConfiguration().getName();
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences prefs = pContext.getRequest().getPreferences();
        String workspace = prefs.getValue("workspace", null);
        if (workspace == null) {
            WCMConfigurationService wcmConfService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
            NodeLocation nodeLocation = wcmConfService.getLivePortalsLocation(repository);
            workspace = nodeLocation.getWorkspace();
        }
        Session session = Utils.getSessionProvider().getSession(workspace, maRepository);
        return session;
    }

    public String getWorkspaceName(Node node) throws Exception {
        return node.getSession().getWorkspace().getName();
    }

    public String getRepository() throws Exception {
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository maRepository = repoService.getCurrentRepository();
        return maRepository.getConfiguration().getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewActionListener
    extends EventListener<UIContentSearchResult> {
        public void execute(Event<UIContentSearchResult> event) throws Exception {
            UIContentSearchResult contentSearchResult = (UIContentSearchResult)((Object)event.getSource());
            String expression = event.getRequestContext().getRequestParameter("objectId");
            NodeLocation nodeLocation = NodeLocation.getNodeLocationByExpression((String)expression);
            String repository = nodeLocation.getRepository();
            String workspace = nodeLocation.getWorkspace();
            String webcontentPath = nodeLocation.getPath();
            Node originalNode = Utils.getViewableNodeByComposer(repository, workspace, webcontentPath, "base");
            Node viewNode = Utils.getViewableNodeByComposer(repository, workspace, webcontentPath);
            UIContentSelector contentSelector = (UIContentSelector)contentSearchResult.getAncestorOfType(UIContentSelector.class);
            UIContentViewer contentResultViewer = (UIContentViewer)contentSelector.getChild(UIContentViewer.class);
            if (contentResultViewer == null) {
                contentResultViewer = (UIContentViewer)contentSelector.addChild(UIContentViewer.class, null, null);
            }
            contentResultViewer.setNode(viewNode);
            contentResultViewer.setOriginalNode(originalNode);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentSelector);
            contentSelector.setSelectedTab(contentResultViewer.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UIContentSearchResult> {
        public void execute(Event<UIContentSearchResult> event) throws Exception {
            UIContentSearchResult contentSearchResult = (UIContentSearchResult)((Object)event.getSource());
            String expression = event.getRequestContext().getRequestParameter("objectId");
            Node webContent = NodeLocation.getNodeByExpression((String)expression);
            NodeIdentifier nodeIdentifier = NodeIdentifier.make((Node)webContent);
            PortletRequestContext pContext = (PortletRequestContext)event.getRequestContext();
            PortletPreferences prefs = pContext.getRequest().getPreferences();
            prefs.setValue("repository", nodeIdentifier.getRepository());
            prefs.setValue("workspace", nodeIdentifier.getWorkspace());
            prefs.setValue("nodeIdentifier", nodeIdentifier.getUUID());
            prefs.store();
            UIPortal uiPortal = Util.getUIPortal();
            UIPageBody uiPageBody = (UIPageBody)uiPortal.findFirstComponentOfType(UIPageBody.class);
            uiPageBody.setUIComponent(null);
            uiPageBody.setMaximizedUIComponent(null);
            Utils.updatePortal((PortletRequestContext)event.getRequestContext());
            Utils.closePopupWindow((UIContainer)contentSearchResult.getAncestorOfType(UIContentSelector.class), "UIContentDialogFormPopupWindow");
        }
    }
}

