/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability.internal.utils;

import com.arjuna.orbportability.common.opPropertyManager;
import com.arjuna.orbportability.logging.opLogger;
import com.arjuna.orbportability.utils.InitClassInterface;
import java.util.Enumeration;
import java.util.Properties;

abstract class InitLoader {
    private String initName;
    private String propertyName;
    private Object initObj;

    protected InitLoader(String name, String attrName, Object obj) {
        this.initName = name;
        this.propertyName = attrName;
        this.initObj = obj;
    }

    protected void initialise() {
        Properties properties = opPropertyManager.propertyManager.getProperties();
        if (properties != null) {
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String attrName = (String)names.nextElement();
                if (attrName.indexOf(this.propertyName) == -1) continue;
                this.createInstance(attrName, properties.getProperty(attrName));
            }
        }
    }

    private void createInstance(String attrName, String className) {
        block11: {
            if (className == null) {
                if (opLogger.loggerI18N.isWarnEnabled()) {
                    opLogger.loggerI18N.warn("com.arjuna.orbportability.internal.utils.InitLoader.initfailed", new Object[]{this.initName, attrName});
                }
                return;
            }
            try {
                Class<?> c;
                block10: {
                    if (opLogger.loggerI18N.isInfoEnabled()) {
                        opLogger.loggerI18N.info("com.arjuna.orbportability.internal.utils.InitLoader.loading", new Object[]{this.initName, className});
                    }
                    c = Thread.currentThread().getContextClassLoader().loadClass(className);
                    try {
                        Object o = c.newInstance();
                        if (o instanceof InitClassInterface) {
                            ((InitClassInterface)o).invoke(this.initObj);
                        }
                        o = null;
                    }
                    catch (IllegalAccessException e1) {
                        if (opLogger.loggerI18N.isWarnEnabled()) {
                            opLogger.logger.warn(this.initName + " " + e1);
                        }
                    }
                    catch (InstantiationException e2) {
                        if (!opLogger.loggerI18N.isWarnEnabled()) break block10;
                        opLogger.logger.warn(this.initName + " " + e2);
                    }
                }
                c = null;
            }
            catch (ClassNotFoundException e) {
                if (!opLogger.loggerI18N.isWarnEnabled()) break block11;
                opLogger.loggerI18N.warn("com.arjuna.orbportability.internal.utils.InitLoader.couldnotfindclass", new Object[]{this.initName, className});
            }
        }
    }
}

