/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.policy.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.util.DOMPolicyReader;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.ws.policy.util.PolicyRegistry;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.extensions.policy.PolicyScopeLevel;
import org.jboss.ws.extensions.policy.annotation.Policy;
import org.jboss.ws.extensions.policy.annotation.PolicyAttachment;
import org.jboss.ws.extensions.policy.deployer.PolicyDeployer;
import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedPolicy;
import org.jboss.ws.extensions.policy.metadata.PolicyMetaExtension;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ExtensibleMetaData;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyMetaDataBuilder {
    private static final Logger log = Logger.getLogger(PolicyMetaDataBuilder.class);
    private boolean serverSide = true;
    private boolean toolMode = false;
    private PolicyDeployer customDeployer;

    public PolicyMetaDataBuilder() {
    }

    public PolicyMetaDataBuilder(PolicyDeployer customDeployer) {
        this.customDeployer = customDeployer;
    }

    public static PolicyMetaDataBuilder getServerSidePolicyMetaDataBuilder(boolean toolMode) {
        PolicyMetaDataBuilder builder = new PolicyMetaDataBuilder();
        builder.setServerSide(true);
        builder.setToolMode(toolMode);
        return builder;
    }

    public static PolicyMetaDataBuilder getClientSidePolicyMetaDataBuilder() {
        PolicyMetaDataBuilder builder = new PolicyMetaDataBuilder();
        builder.setServerSide(false);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPolicyAnnotations(EndpointMetaData epMetaData, Class<?> sepClass) throws IOException {
        UnifiedVirtualFile vfRoot = epMetaData.getServiceMetaData().getUnifiedMetaData().getRootFile();
        for (Policy anPolicy : sepClass.getAnnotation(PolicyAttachment.class).value()) {
            Exception e2;
            Object var16_15;
            InputStream is = null;
            try {
                String policyFileLocation = anPolicy.policyFileLocation();
                if (policyFileLocation.length() == 0) {
                    throw new IllegalStateException("Cannot obtain @Policy.policyFileLocation");
                }
                UnifiedVirtualFile vfPolicyFile = vfRoot.findChild(policyFileLocation);
                is = vfPolicyFile.toURL().openStream();
                DOMPolicyReader reader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
                org.apache.ws.policy.Policy unnormalizedPolicy = reader.readPolicy(is);
                org.apache.ws.policy.Policy normPolicy = (org.apache.ws.policy.Policy)unnormalizedPolicy.normalize();
                log.info((Object)("Deploying Annotated Policy = " + policyFileLocation));
                PolicyScopeLevel scope = anPolicy.scope();
                if (!(PolicyScopeLevel.WSDL_PORT.equals((Object)scope) || PolicyScopeLevel.WSDL_PORT_TYPE.equals((Object)scope) || PolicyScopeLevel.WSDL_BINDING.equals((Object)scope))) {
                    throw new WSException("Policy scope " + (Object)((Object)scope) + " not supported yet!");
                }
                this.deployPolicy(normPolicy, scope, epMetaData);
                var16_15 = null;
            }
            catch (Throwable throwable) {
                var16_15 = null;
                try {
                    is.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (Exception e2) {}
        }
    }

    public void processPolicyExtensions(EndpointMetaData epMetaData, WSDLDefinitions wsdlDefinitions) {
        DOMPolicyReader reader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
        PolicyRegistry localPolicyRegistry = new PolicyRegistry();
        for (WSDLExtensibilityElement policyElement : wsdlDefinitions.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policy")) {
            org.apache.ws.policy.Policy policy = reader.readPolicy(policyElement.getElement());
            localPolicyRegistry.register(policy.getPolicyURI(), policy);
        }
        WSDLService wsdlService = wsdlDefinitions.getService(epMetaData.getServiceMetaData().getServiceName());
        if (wsdlService != null) {
            WSDLEndpoint wsdlEndpoint = wsdlService.getEndpoint(epMetaData.getPortName());
            if (wsdlEndpoint != null) {
                List<WSDLExtensibilityElement> portPolicyRefList = wsdlEndpoint.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policyReference");
                this.processPolicies(portPolicyRefList, PolicyScopeLevel.WSDL_PORT, localPolicyRegistry, (ExtensibleMetaData)epMetaData);
            } else {
                log.warn((Object)("Cannot get port '" + epMetaData.getPortName() + "' from the given wsdl definitions! Eventual policies attached to this port won't be considered."));
            }
        } else {
            log.warn((Object)("Cannot get service '" + epMetaData.getServiceMetaData().getServiceName() + "' from the given wsdl definitions!  Eventual policies attached to this service won't be considered."));
        }
        WSDLBinding wsdlBinding = wsdlDefinitions.getBindingByInterfaceName(epMetaData.getPortTypeName());
        if (wsdlBinding != null) {
            List<WSDLExtensibilityElement> bindingPolicyRefList = wsdlBinding.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policyReference");
            this.processPolicies(bindingPolicyRefList, PolicyScopeLevel.WSDL_BINDING, localPolicyRegistry, (ExtensibleMetaData)epMetaData);
        } else {
            log.warn((Object)("Cannot get binding for portType '" + epMetaData.getPortTypeName() + "' from the given wsdl definitions!  Eventual policies attached to this binding won't be considered."));
        }
        WSDLInterface wsdlInterface = wsdlDefinitions.getInterface(epMetaData.getPortTypeName());
        if (wsdlInterface != null) {
            WSDLProperty portTypePolicyProp = wsdlInterface.getProperty("http://www.jboss.org/jbossws/wsp/policyURIs");
            this.processPolicies(portTypePolicyProp, PolicyScopeLevel.WSDL_PORT_TYPE, localPolicyRegistry, (ExtensibleMetaData)epMetaData);
        } else {
            log.warn((Object)("Cannot get portType '" + epMetaData.getPortTypeName() + "' from the given wsdl definitions! Eventual policies attached to this portType won't be considered."));
        }
    }

    private void processPolicies(WSDLProperty policyProp, PolicyScopeLevel scope, PolicyRegistry localPolicies, ExtensibleMetaData extMetaData) {
        if (policyProp != null && policyProp.getValue() != null) {
            StringTokenizer st = new StringTokenizer(policyProp.getValue(), ", ", false);
            while (st.hasMoreTokens()) {
                PolicyReference policyRef = new PolicyReference(st.nextToken());
                this.deployPolicy(this.resolvePolicyReference(policyRef, localPolicies), scope, extMetaData);
            }
        }
    }

    private void processPolicies(List<WSDLExtensibilityElement> policyReferences, PolicyScopeLevel scope, PolicyRegistry localPolicies, ExtensibleMetaData extMetaData) {
        if (policyReferences != null && policyReferences.size() != 0) {
            DOMPolicyReader reader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
            for (WSDLExtensibilityElement element : policyReferences) {
                PolicyReference policyRef = reader.readPolicyReference(element.getElement());
                this.deployPolicy(this.resolvePolicyReference(policyRef, localPolicies), scope, extMetaData);
            }
        }
    }

    private org.apache.ws.policy.Policy resolvePolicyReference(PolicyReference policyRef, PolicyRegistry localPolicies) {
        org.apache.ws.policy.Policy normPolicy;
        try {
            normPolicy = (org.apache.ws.policy.Policy)policyRef.normalize(localPolicies);
        }
        catch (RuntimeException e) {
            normPolicy = null;
        }
        return normPolicy;
    }

    private void deployPolicy(org.apache.ws.policy.Policy policy, PolicyScopeLevel scope, ExtensibleMetaData extMetaData) {
        PolicyDeployer deployer = this.customDeployer != null ? this.customDeployer : (this.toolMode ? PolicyDeployer.newInstanceForTools() : PolicyDeployer.getInstance());
        if (this.serverSide) {
            this.deployPolicyServerSide(policy, scope, extMetaData, deployer);
        } else {
            this.deployPolicyClientSide(policy, scope, extMetaData, deployer);
        }
    }

    private void deployPolicyServerSide(org.apache.ws.policy.Policy policy, PolicyScopeLevel scope, ExtensibleMetaData extMetaData, PolicyDeployer deployer) {
        PolicyMetaExtension ext = (PolicyMetaExtension)extMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (ext == null) {
            ext = new PolicyMetaExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
            extMetaData.addExtension(ext);
        }
        try {
            org.apache.ws.policy.Policy deployedPolicy = deployer.deployServerside(policy, extMetaData);
            ext.addPolicy(scope, deployedPolicy);
        }
        catch (UnsupportedPolicy e) {
            log.warn((Object)("Policy Not supported:" + policy.getPolicyURI()));
        }
    }

    private void deployPolicyClientSide(org.apache.ws.policy.Policy policy, PolicyScopeLevel scope, ExtensibleMetaData extMetaData, PolicyDeployer deployer) {
        PolicyMetaExtension ext = (PolicyMetaExtension)extMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (ext == null) {
            ext = new PolicyMetaExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
            extMetaData.addExtension(ext);
        }
        try {
            deployer.deployClientSide(policy, extMetaData);
            ext.addPolicy(scope, policy);
        }
        catch (UnsupportedPolicy e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Policy Not supported:" + policy.getPolicyURI()));
            }
            WSException.rethrow("Policy not supported! " + policy.getPolicyURI(), e);
        }
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public boolean isToolMode() {
        return this.toolMode;
    }

    public void setToolMode(boolean toolMode) {
        this.toolMode = toolMode;
    }
}

