/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.FailedIoFuture;
import org.jboss.xnio.FinishedIoFuture;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.BoundServer;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.management.TcpServerMBean;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioTcpChannel;
import org.jboss.xnio.nio.NioTcpServerConfig;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioTcpServer
implements BoundServer<SocketAddress, BoundChannel<SocketAddress>> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.tcp.server");
    private static final Logger chanLog = Logger.getLogger((String)"org.jboss.xnio.nio.tcp.server.channel");
    private final Executor executor;
    private final IoHandlerFactory<? super TcpChannel> handlerFactory;
    private final NioXnio xnio;
    private final Object lock = new Object();
    private final Set<NioTcpServerChannel> boundChannels = new LinkedHashSet<NioTcpServerChannel>();
    private final AtomicLong globalAcceptedConnections = new AtomicLong();
    private boolean closed;
    private Boolean reuseAddress;
    private Integer receiveBufferSize;
    private Integer backlog;
    private Boolean keepAlive;
    private Boolean oobInline;
    private Boolean tcpNoDelay;
    private boolean manageConnections;
    private static final Set<ChannelOption<?>> options;
    private final Closeable mbeanHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NioTcpServer create(NioTcpServerConfig config) throws IOException {
        NioTcpServer tcpServer = new NioTcpServer(config);
        boolean ok = false;
        try {
            SocketAddress[] addresses = config.getInitialAddresses();
            if (addresses != null) {
                for (SocketAddress address : addresses) {
                    tcpServer.bind(address).get();
                }
            }
            ok = true;
            log.trace("Successfully started TCP server");
            NioTcpServer nioTcpServer = tcpServer;
            return nioTcpServer;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)((Object)tcpServer));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NioTcpServer(NioTcpServerConfig config) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.xnio = config.getXnio();
            try {
                this.mbeanHandle = this.xnio.registerMBean(new MBean());
            }
            catch (NotCompliantMBeanException e) {
                throw new IOException("Cannot construct server mbean: " + e);
            }
            this.executor = config.getExecutor();
            this.handlerFactory = config.getHandlerFactory();
            this.reuseAddress = config.getReuseAddresses();
            this.receiveBufferSize = config.getReceiveBuffer();
            this.backlog = config.getBacklog();
            this.keepAlive = config.getKeepAlive();
            this.oobInline = config.getOobInline();
            this.tcpNoDelay = config.getNoDelay();
            this.manageConnections = config.isManageConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BoundChannel<SocketAddress>> getChannels() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<BoundChannel<SocketAddress>>(this.boundChannels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoFuture<BoundChannel<SocketAddress>> bind(SocketAddress address) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Integer backlog;
                Integer receiveBufferSize;
                if (this.closed) {
                    throw new ClosedChannelException();
                }
                ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.configureBlocking(false);
                ServerSocket serverSocket = serverSocketChannel.socket();
                Boolean reuseAddress = this.reuseAddress;
                if (reuseAddress != null) {
                    serverSocket.setReuseAddress(reuseAddress);
                }
                if ((receiveBufferSize = this.receiveBufferSize) != null) {
                    serverSocket.setReceiveBufferSize(receiveBufferSize);
                }
                if ((backlog = this.backlog) != null) {
                    serverSocket.bind(address, backlog);
                } else {
                    serverSocket.bind(address);
                }
                NioTcpServerChannel channel = new NioTcpServerChannel(serverSocketChannel);
                this.boundChannels.add(channel);
                return new FinishedIoFuture((Object)channel);
            }
            catch (IOException e) {
                return new FailedIoFuture(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                log.trace("Closing %s", (Object)this);
                this.closed = true;
                ArrayList<NioTcpServerChannel> list = new ArrayList<NioTcpServerChannel>(this.boundChannels);
                for (NioTcpServerChannel boundChannel : list) {
                    IoUtils.safeClose((Closeable)((Object)boundChannel));
                }
                IoUtils.safeClose((Closeable)this.mbeanHandle);
            }
        }
    }

    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        Object object = this.lock;
        synchronized (object) {
            if (option == CommonOptions.REUSE_ADDRESSES) {
                return option.getType().cast(this.reuseAddress);
            }
            if (option == CommonOptions.RECEIVE_BUFFER) {
                return option.getType().cast(this.receiveBufferSize);
            }
            if (option == CommonOptions.BACKLOG) {
                return option.getType().cast(this.backlog);
            }
            if (option == CommonOptions.KEEP_ALIVE) {
                return option.getType().cast(this.keepAlive);
            }
            if (option == CommonOptions.TCP_OOB_INLINE) {
                return option.getType().cast(this.oobInline);
            }
            if (option == CommonOptions.TCP_NODELAY) {
                return option.getType().cast(this.tcpNoDelay);
            }
            throw NioTcpServer.badOption(option);
        }
    }

    public Set<ChannelOption<?>> getOptions() {
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> NioTcpServer setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        Object object = this.lock;
        synchronized (object) {
            if (option == CommonOptions.REUSE_ADDRESSES) {
                this.reuseAddress = (Boolean)CommonOptions.REUSE_ADDRESSES.getType().cast(value);
            } else if (option == CommonOptions.RECEIVE_BUFFER) {
                this.receiveBufferSize = (Integer)CommonOptions.RECEIVE_BUFFER.getType().cast(value);
            } else if (option == CommonOptions.BACKLOG) {
                this.backlog = (Integer)CommonOptions.BACKLOG.getType().cast(value);
            } else if (option == CommonOptions.KEEP_ALIVE) {
                this.keepAlive = (Boolean)CommonOptions.KEEP_ALIVE.getType().cast(value);
            } else if (option == CommonOptions.TCP_OOB_INLINE) {
                this.oobInline = (Boolean)CommonOptions.TCP_OOB_INLINE.getType().cast(value);
            } else if (option == CommonOptions.TCP_NODELAY) {
                this.tcpNoDelay = (Boolean)CommonOptions.TCP_NODELAY.getType().cast(value);
            } else {
                throw NioTcpServer.badOption(option);
            }
            return this;
        }
    }

    public String toString() {
        return String.format("TCP server (NIO) <%s>", Integer.toHexString(this.hashCode()));
    }

    private static UnsupportedOptionException badOption(ChannelOption<?> option) {
        return new UnsupportedOptionException("Option " + option + " is unsupported");
    }

    static {
        HashSet<ChannelOption> optionSet = new HashSet<ChannelOption>();
        optionSet.add(CommonOptions.BACKLOG);
        optionSet.add(CommonOptions.REUSE_ADDRESSES);
        optionSet.add(CommonOptions.RECEIVE_BUFFER);
        optionSet.add(CommonOptions.KEEP_ALIVE);
        optionSet.add(CommonOptions.TCP_OOB_INLINE);
        optionSet.add(CommonOptions.TCP_NODELAY);
        options = Collections.unmodifiableSet(optionSet);
    }

    public final class MBean
    extends StandardMBean
    implements TcpServerMBean {
        protected MBean() throws NotCompliantMBeanException {
            super(TcpServerMBean.class);
        }

        public String toString() {
            return "TCPServerMBean";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TcpServerMBean.Listener[] getBoundListeners() {
            Object object = NioTcpServer.this.lock;
            synchronized (object) {
                TcpServerMBean.Listener[] listeners = new TcpServerMBean.Listener[NioTcpServer.this.boundChannels.size()];
                int i = 0;
                for (NioTcpServerChannel channel : NioTcpServer.this.boundChannels) {
                    final SocketAddress bindAddress = channel.address;
                    final long acceptedConnections = channel.acceptedConnections.get();
                    listeners[i++] = new TcpServerMBean.Listener(){

                        public SocketAddress getBindAddress() {
                            return bindAddress;
                        }

                        public long getAcceptedConnections() {
                            return acceptedConnections;
                        }
                    };
                }
                return listeners;
            }
        }

        public long getAcceptedConnections() {
            return NioTcpServer.this.globalAcceptedConnections.get();
        }

        public void bind(SocketAddress address) throws IOException {
            if (address == null) {
                throw new NullPointerException("address is null");
            }
            NioTcpServer.this.bind(address).get();
        }

        public void bind(String hostName, int port) throws IOException {
            this.bind(new InetSocketAddress(hostName, port));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unbind(SocketAddress address) throws IOException {
            if (address == null) {
                throw new NullPointerException("address is null");
            }
            Object object = NioTcpServer.this.lock;
            synchronized (object) {
                for (NioTcpServerChannel channel : NioTcpServer.this.boundChannels) {
                    if (!channel.address.equals(address)) continue;
                    channel.close();
                    return;
                }
            }
            throw new IOException("No channel bound to address " + address);
        }

        public void unbind(String hostName, int port) throws IOException {
            this.unbind(new InetSocketAddress(hostName, port));
        }

        public void close() {
            IoUtils.safeClose((Closeable)((Object)NioTcpServer.this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class NioTcpServerChannel
    implements BoundChannel<SocketAddress> {
        private final NioHandle handle;
        private final ServerSocket serverSocket;
        private final SocketAddress address;
        private final ServerSocketChannel channel;
        private final AtomicLong acceptedConnections = new AtomicLong();
        private final AtomicBoolean open = new AtomicBoolean(true);

        public NioTcpServerChannel(ServerSocketChannel channel) throws IOException {
            this.channel = channel;
            this.serverSocket = channel.socket();
            this.address = this.serverSocket.getLocalSocketAddress();
            this.handle = NioTcpServer.this.xnio.addConnectHandler(channel, new Handler(channel, NioTcpServer.this.executor, NioTcpServer.this.globalAcceptedConnections, this.acceptedConnections), false);
            this.handle.resume(16);
        }

        public SocketAddress getLocalAddress() {
            return this.address;
        }

        public boolean isOpen() {
            return this.open.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.open.getAndSet(false)) {
                Object object = NioTcpServer.this.lock;
                synchronized (object) {
                    chanLog.trace("Closing %s", (Object)this);
                    try {
                        this.channel.close();
                    }
                    finally {
                        NioTcpServer.this.xnio.removeManaged((Closeable)((Object)this));
                    }
                }
            }
        }

        public String toString() {
            return String.format("TCP server channel (NIO) <%s> (local: %s)", Integer.toHexString(this.hashCode()), this.getLocalAddress());
        }
    }

    private final class Handler
    implements Runnable {
        private final ServerSocketChannel socketChannel;
        private final Executor executor;
        private final AtomicLong globalAcceptedConnections;
        private final AtomicLong acceptedConnections;

        public Handler(ServerSocketChannel channel, Executor executor, AtomicLong acceptedConnections, AtomicLong connections) {
            this.socketChannel = channel;
            this.executor = executor;
            this.globalAcceptedConnections = acceptedConnections;
            this.acceptedConnections = connections;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                AtomicLong acceptedConnections = this.acceptedConnections;
                AtomicLong globalAcceptedConnections = this.globalAcceptedConnections;
                try {
                    SocketChannel socketChannel = this.socketChannel.accept();
                    if (socketChannel == null) break block11;
                    boolean ok = false;
                    try {
                        NioTcpChannel channel;
                        IoHandler streamIoHandler;
                        Boolean tcpNoDelay;
                        Boolean oobInline;
                        socketChannel.configureBlocking(false);
                        Socket socket = socketChannel.socket();
                        Boolean keepAlive = NioTcpServer.this.keepAlive;
                        if (keepAlive != null) {
                            socket.setKeepAlive(keepAlive);
                        }
                        if ((oobInline = NioTcpServer.this.oobInline) != null) {
                            socket.setOOBInline(oobInline);
                        }
                        if ((tcpNoDelay = NioTcpServer.this.tcpNoDelay) != null) {
                            socket.setTcpNoDelay(tcpNoDelay);
                        }
                        if (ok = HandlerUtils.handleOpened(streamIoHandler = NioTcpServer.this.handlerFactory.createHandler(), channel = new NioTcpChannel(NioTcpServer.this.xnio, socketChannel, (IoHandler<? super TcpChannel>)streamIoHandler, this.executor, NioTcpServer.this.manageConnections))) {
                            acceptedConnections.incrementAndGet();
                            globalAcceptedConnections.incrementAndGet();
                            NioTcpServer.this.xnio.addManaged(channel);
                            log.trace("TCP server accepted connection");
                        }
                    }
                    finally {
                        if (!ok) {
                            log.trace("TCP server failed to accept connection");
                            IoUtils.safeClose((Closeable)socketChannel);
                        }
                    }
                }
                catch (ClosedChannelException e) {
                    log.trace("Channel closed: %s", (Object)e.getMessage());
                    return;
                }
                catch (IOException e) {
                    log.trace((Throwable)e, "I/O error on TCP server", new Object[0]);
                }
            }
        }
    }
}

