/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.content.version;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.content.version.PackageVersionData;

public class PackageVersions {
    public static final String FILENAME = "package-versions.dat";
    public static final String LEGACY_FILENAME = "application-versions.dat";
    private static PackageVersionData data;
    private static ReentrantReadWriteLock dataLock;
    private String pluginName;
    private String dataDirectory;
    private final Log log = LogFactory.getLog(this.getClass());

    public PackageVersions(String pluginName, String dataDirectory) {
        this.pluginName = pluginName;
        this.dataDirectory = dataDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromDisk() {
        dataLock.readLock().lock();
        try {
            ObjectInputStream ois = null;
            try {
                File legacyFile;
                if (data != null) {
                    return;
                }
                this.log.debug((Object)("Loading package versions from storage for plugin [" + this.pluginName + "]"));
                File file = new File(this.dataDirectory, FILENAME);
                if (!file.exists() && (legacyFile = new File(this.dataDirectory, LEGACY_FILENAME)).exists()) {
                    this.log.info((Object)("Found legacy package versions data file [" + legacyFile + "] - renaming to [" + file + "]..."));
                    legacyFile.renameTo(file);
                }
                if (!file.exists()) {
                    this.log.debug((Object)("No package versions found for plugin [" + this.pluginName + "]. This will be the case if the Agent was cleaned or on the first run."));
                    data = new PackageVersionData();
                } else {
                    FileInputStream fis = new FileInputStream(file);
                    ois = new ObjectInputStream(fis);
                    data = (PackageVersionData)ois.readObject();
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Could not load persistent version data from disk for plugin [" + this.pluginName + "]. Package version values will be reset."), (Throwable)e);
                data = new PackageVersionData();
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        this.log.error((Object)("Error closing input stream for persistent version data for plugin [" + this.pluginName + "]"), (Throwable)e);
                    }
                }
            }
        }
        finally {
            dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToDisk() {
        dataLock.writeLock().lock();
        try {
            if (data == null) {
                throw new IllegalStateException("Data has not been loaded prior to saving for plugin [" + this.pluginName + "]");
            }
            ObjectOutputStream oos = null;
            try {
                File file = new File(this.dataDirectory, FILENAME);
                FileOutputStream fos = new FileOutputStream(file);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(data);
            }
            catch (Exception e) {
                this.log.error((Object)("Error saving persistent version data for plugin [" + this.pluginName + "]. Package versions may not be maintained between agent restarts."), (Throwable)e);
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException e) {
                        this.log.error((Object)("Error closing output stream for plugin [" + this.pluginName + "]."), (Throwable)e);
                    }
                }
            }
        }
        finally {
            dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion(String packageKey) {
        String version;
        if (packageKey == null) {
            throw new IllegalArgumentException("packageKey cannot be null");
        }
        this.checkLoaded();
        PackageVersionData packageVersionData = data;
        synchronized (packageVersionData) {
            version = data.getVersion(packageKey);
        }
        return version;
    }

    public void unload() {
        data = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putVersion(String packageKey, String version) {
        if (packageKey == null) {
            throw new IllegalArgumentException("packageKey cannot be null");
        }
        this.checkLoaded();
        PackageVersionData packageVersionData = data;
        synchronized (packageVersionData) {
            data.setVersion(packageKey, version);
        }
    }

    private void checkLoaded() {
        if (data == null) {
            throw new IllegalStateException("Attempt to access package versions without loading the data. Call loadFromDisk() before attempting these operations.");
        }
    }

    static {
        dataLock = new ReentrantReadWriteLock(true);
    }
}

