/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import javassist.CtClass;
import javassist.CtField;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedInfo;
import org.jboss.reflect.plugins.javassist.JavassistField;
import org.jboss.reflect.plugins.javassist.JavassistReflectionFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class JavassistFieldInfo
extends JavassistAnnotatedInfo
implements FieldInfo {
    private static final long serialVersionUID = -104555531831318930L;
    private static final JavassistReflectionFactory reflectionFactory = new JavassistReflectionFactory(true);
    private CtField ctField;
    private transient JavassistField field;
    private transient TypeInfo fieldType;
    protected JavassistTypeInfo typeInfo;

    public JavassistFieldInfo(AnnotationHelper annotationHelper, JavassistTypeInfo typeInfo, CtField ctField) {
        super(annotationHelper);
        this.typeInfo = typeInfo;
        this.ctField = ctField;
    }

    public String getName() {
        return this.ctField.getName();
    }

    public int getModifiers() {
        return this.ctField.getModifiers();
    }

    public boolean isPublic() {
        return Modifier.isPublic((int)this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic((int)this.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile((int)this.getModifiers());
    }

    public ClassInfo getDeclaringClass() {
        return this.typeInfo;
    }

    public TypeInfo getType() {
        if (this.fieldType != null) {
            return this.fieldType;
        }
        try {
            CtClass clazz = this.ctField.getType();
            this.fieldType = this.typeInfo.getFactory().getTypeInfo(clazz);
            return this.fieldType;
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseFieldNotFound(this.getName(), e);
        }
    }

    public Object get(Object target) throws Throwable {
        if (this.field == null) {
            this.field = reflectionFactory.createField(this.ctField);
        }
        return this.field.get(target);
    }

    public Object set(Object target, Object value) throws Throwable {
        if (this.field == null) {
            this.field = reflectionFactory.createField(this.ctField);
        }
        this.field.set(target, value);
        return null;
    }

    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FieldInfo)) {
            return false;
        }
        FieldInfo other = (FieldInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return this.getDeclaringClass().equals(other.getDeclaringClass());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }

    public AnnotationValue[] getAnnotations() {
        return this.getAnnotations(this.ctField);
    }
}

