/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.jboss.remoting.samples.chat.client.ChatInfo;
import org.jboss.remoting.samples.chat.client.ChatMember;
import org.jboss.remoting.samples.chat.exceptions.NameInUseException;
import org.jboss.remoting.samples.chat.server.CallbackThread;
import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;

public class ExtendedChatInfo
implements Serializable {
    private static final long serialVersionUID = 3L;
    private ChatInfo chatInfo;
    private ReadWriteArrayList messages;
    private Collection members;
    private transient Hashtable threadMap;
    private transient Collection chatReceivers;

    public ExtendedChatInfo(ChatInfo chatInfo) {
        this.chatInfo = chatInfo;
        this.messages = new ReadWriteArrayList();
        this.members = Collections.synchronizedCollection(new HashSet());
        this.threadMap = new Hashtable();
        this.chatReceivers = Collections.synchronizedCollection(new HashSet());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.threadMap = new Hashtable();
        this.chatReceivers = Collections.synchronizedCollection(new HashSet());
    }

    public ChatInfo getChatInfo() {
        return this.chatInfo;
    }

    public Collection getMembers() {
        return this.members;
    }

    public ReadWriteArrayList getMessages() {
        return this.messages;
    }

    public Collection getChatReceivers() {
        return this.chatReceivers;
    }

    public CallbackThread getChatReceiverThread(ChatMember member) {
        return (CallbackThread)this.threadMap.get(member.get_name());
    }

    public void addMember(ChatMember member) throws NameInUseException {
        String name = member.get_name();
        if (this.members.contains(name)) {
            throw new NameInUseException();
        }
        this.members.add(name);
    }

    public void removeMember(ChatMember member) {
        String name = member.get_name();
        this.threadMap.remove(name);
        this.members.remove(name);
    }

    public void addMessages(ArrayList messages) {
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            this.messages.add(it.next());
        }
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }
}

