/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer;

import javax.management.ObjectName;
import org.jboss.system.Service;
import org.jboss.system.ServiceController;
import org.jboss.system.microcontainer.ServiceControllerContext;
import org.jboss.system.microcontainer.ServiceControllerContextAction;

public class CreateDestroyLifecycleAction
extends ServiceControllerContextAction {
    public void installAction(ServiceControllerContext context) throws Throwable {
        Service service = context.getServiceProxy();
        service.create();
        context.getServiceContext().state = 2;
        ObjectName objectName = context.getObjectName();
        ServiceController serviceController = context.getServiceController();
        serviceController.sendControllerNotification("org.jboss.system.ServiceMBean.create", objectName);
    }

    public void uninstallAction(ServiceControllerContext context) {
        try {
            Service service = context.getServiceProxy();
            service.destroy();
            context.getServiceContext().state = 6;
            ObjectName objectName = context.getObjectName();
            ServiceController serviceController = context.getServiceController();
            serviceController.sendControllerNotification("org.jboss.system.ServiceMBean.destroy", objectName);
        }
        catch (Throwable t) {
            this.log.debug((Object)("Error during destroy for " + context.getObjectName()), t);
        }
    }
}

