/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common.logging;

import java.util.concurrent.ConcurrentHashMap;
import org.chromattic.common.collection.Collections;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger {
    private static final ConcurrentHashMap<String, Logger> loggers = new ConcurrentHashMap();
    private final org.slf4j.Logger logger;

    public static Logger getLogger(Class<?> name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException();
        }
        return Logger.getLogger(name.getName());
    }

    public static Logger getLogger(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException();
        }
        Logger logger = loggers.get(name);
        if (logger == null) {
            logger = Collections.putIfAbsent(loggers, name, new Logger(name));
        }
        return logger;
    }

    public Logger(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String s) {
        this.logger.trace(s);
    }

    public void trace(String s, Object o) {
        this.logger.trace(s, o);
    }

    public void trace(String s, Object o, Object o1) {
        this.logger.trace(s, o, o1);
    }

    public void trace(String s, Object ... objects) {
        this.logger.trace(s, objects);
    }

    public void trace(String s, Throwable throwable) {
        this.logger.trace(s, throwable);
    }

    public void debug(String s) {
        this.logger.debug(s);
    }

    public void debug(String s, Object o) {
        this.logger.debug(s, o);
    }

    public void debug(String s, Object o, Object o1) {
        this.logger.debug(s, o, o1);
    }

    public void debug(String s, Object ... objects) {
        this.logger.debug(s, objects);
    }

    public void debug(String s, Throwable throwable) {
        this.logger.debug(s, throwable);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String s) {
        this.logger.info(s);
    }

    public void info(String s, Object o) {
        this.logger.info(s, o);
    }

    public void info(String s, Object o, Object o1) {
        this.logger.info(s, o, o1);
    }

    public void info(String s, Object ... objects) {
        this.logger.info(s, objects);
    }

    public void info(String s, Throwable throwable) {
        this.logger.info(s, throwable);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void warn(String s) {
        this.logger.warn(s);
    }

    public void warn(String s, Object o) {
        this.logger.warn(s, o);
    }

    public void warn(String s, Object ... objects) {
        this.logger.warn(s, objects);
    }

    public void warn(String s, Object o, Object o1) {
        this.logger.warn(s, o, o1);
    }

    public void warn(String s, Throwable throwable) {
        this.logger.warn(s, throwable);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String s) {
        this.logger.error(s);
    }

    public void error(String s, Object o) {
        this.logger.error(s, o);
    }

    public void error(String s, Object o, Object o1) {
        this.logger.error(s, o, o1);
    }

    public void error(String s, Object ... objects) {
        this.logger.error(s, objects);
    }

    public void error(String s, Throwable throwable) {
        this.logger.error(s, throwable);
    }
}

