/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.sidebar.TreeNode;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeNodePageIterator;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/sidebar/UITreeExplorer.gtmpl", events={@EventConfig(listeners={ExpandActionListener.class}), @EventConfig(listeners={CollapseActionListener.class}), @EventConfig(listeners={ExpandTreeActionListener.class}), @EventConfig(listeners={ShowDrivesAreaActionListener.class})})
public class UITreeExplorer
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)"dms.UIJCRExplorer");
    private static final String EXO_RESTORE_LOCATION = "exo:restoreLocation";
    private TreeNode treeRoot_;

    public UIRightClickPopupMenu getContextMenu() {
        return (UIRightClickPopupMenu)((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getChild(UIRightClickPopupMenu.class);
    }

    UIWorkingArea getWorkingArea() {
        return (UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class);
    }

    UIComponent getCustomAction() throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getCustomAction();
    }

    public TreeNode getRootTreeNode() {
        return this.treeRoot_;
    }

    public String getRootActionList() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (uiExplorer.getAllClipBoard().size() > 0) {
            return ((Object)this.getContextMenu().getJSOnclickShowPopup(uiExplorer.getCurrentDriveWorkspace() + ":" + uiExplorer.getRootPath(), "Paste")).toString();
        }
        return "";
    }

    public boolean isDirectlyDrive() {
        PortletPreferences portletPref = ((UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class)).getPortletPreferences();
        String usecase = portletPref.getValue("usecase", "").trim();
        return !"selection".equals(usecase);
    }

    public String getDriveName() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getDriveData().getName();
    }

    public String getLabel() {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String id = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getDriveData().getName();
        try {
            return res.getString("Drives.label." + id.replace(".", "").replace(" ", ""));
        }
        catch (MissingResourceException ex) {
            return id.replace(".", " / ");
        }
    }

    public boolean isAllowNodeTypesOnTree(Node node) throws RepositoryException {
        String[] arrayAllowNodeTypesOnTree;
        DriveData currentDrive = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getDriveData();
        String allowNodeTypesOnTree = currentDrive.getAllowNodeTypesOnTree();
        if (allowNodeTypesOnTree == null || allowNodeTypesOnTree.equals("*")) {
            return true;
        }
        for (String itemAllowNodeTypes : arrayAllowNodeTypesOnTree = allowNodeTypesOnTree.split(",")) {
            if (itemAllowNodeTypes.trim().length() <= 0 || !node.isNodeType(itemAllowNodeTypes.trim())) continue;
            return true;
        }
        return false;
    }

    public String getActionsList(Node node) throws Exception {
        if (node == null) {
            return "";
        }
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        try {
            NodeFinder nodeFinder = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
            nodeFinder.getItem(uiExplorer.getSession(), node.getPath());
            return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getActionsExtensionList(node);
        }
        catch (PathNotFoundException pne) {
            uiExplorer.refreshExplorerWithoutClosingPopup();
            return "";
        }
    }

    public List<Node> getCustomActions(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getCustomActions(node);
    }

    public boolean isPreferenceNode(Node node) {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).isPreferenceNode(node);
    }

    public List<TreeNode> getRenderedChildren(TreeNode treeNode) throws Exception {
        if (this.isPaginated(treeNode)) {
            UITreeNodePageIterator pageIterator = (UITreeNodePageIterator)this.findComponentById(treeNode.getPath());
            return pageIterator.getCurrentPageData();
        }
        return treeNode.getChildren();
    }

    public boolean isSystemWorkspace() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isSystemWorkspace();
    }

    public UITreeNodePageIterator getUIPageIterator(String id) throws Exception {
        return (UITreeNodePageIterator)this.findComponentById(id);
    }

    public boolean isSymLink(Node node) throws RepositoryException {
        LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
        return linkManager.isLink((Item)node);
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName, this.getRepository());
    }

    public boolean isPaginated(TreeNode treeNode) {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        int nodePerPages = jcrExplorer.getPreference().getNodesPerPage();
        return treeNode.getChildrenSize() > nodePerPages;
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getServerPath() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public String getRepository() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    public String getEncodeCurrentPath() {
        return UITreeExplorer.encodeBase64(((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentPath());
    }

    public static String encodeBase64(String value) {
        value = value == null ? "" : value;
        return Base64.encode((byte[])value.getBytes()).replaceAll("\n", "");
    }

    private void addTreeNodePageIteratorAsChild(String id, ObjectPageList pageList, String selectedPath, String currentPath) throws Exception {
        if (this.findComponentById(id) == null) {
            UITreeNodePageIterator nodePageIterator = (UITreeNodePageIterator)this.addChild(UITreeNodePageIterator.class, null, id);
            nodePageIterator.setPageList((PageList)pageList);
            nodePageIterator.setSelectedPath(selectedPath);
        } else {
            UITreeNodePageIterator existedComponent = (UITreeNodePageIterator)this.findComponentById(id);
            int currentPage = existedComponent.getCurrentPage();
            existedComponent.setPageList((PageList)pageList);
            if (!selectedPath.equalsIgnoreCase(currentPath) && currentPage <= existedComponent.getAvailablePage()) {
                existedComponent.setCurrentPage(currentPage);
            }
        }
    }

    private Node getRootNode() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getRootNode();
    }

    private List<Node> getTreeWithNoDocuments(List<Node> childrenList) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List nodeTypes = templateService.getAllDocumentNodeTypes(this.getRepository());
        ArrayList<Node> treeList = new ArrayList<Node>();
        for (Node node : childrenList) {
            if (nodeTypes.contains(node.getPrimaryNodeType().getName())) continue;
            treeList.add(node);
        }
        return treeList;
    }

    private boolean isTimelineView() {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIAddressBar uiAddressBar = (UIAddressBar)jcrExplorer.findFirstComponentOfType(UIAddressBar.class);
        return uiAddressBar.getSelectedViewName() != null && uiAddressBar.getSelectedViewName().equals("timeline-view");
    }

    private void buildTree(String path) throws Exception {
        String rootPath;
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        int nodePerPages = jcrExplorer.getPreference().getNodesPerPage();
        TreeNode treeRoot = new TreeNode(this.getRootNode());
        if (path == null) {
            path = jcrExplorer.getCurrentPath();
        }
        String[] arr = path.replaceFirst(treeRoot.getPath(), "").split("/");
        TreeNode temp = treeRoot;
        String subPath = null;
        String prefix = rootPath = treeRoot.getPath();
        if (!rootPath.equals("/")) {
            prefix = prefix + "/";
        }
        if (this.isTimelineView()) {
            temp.setChildren(this.getTreeWithNoDocuments(jcrExplorer.getChildrenList(rootPath, false)));
        } else {
            temp.setChildren(jcrExplorer.getChildrenList(rootPath, false));
        }
        if (temp.getChildrenSize() > nodePerPages) {
            ObjectPageList list = new ObjectPageList(temp.getChildren(), nodePerPages);
            this.addTreeNodePageIteratorAsChild(temp.getPath(), list, rootPath, path);
        }
        for (String nodeName : arr) {
            if (nodeName.length() == 0) continue;
            if ((temp = temp.getChildByName(nodeName)) == null) {
                LOG.error((Object)("The node '" + nodeName + "' has not child node"));
                this.treeRoot_ = treeRoot;
                return;
            }
            subPath = subPath == null ? prefix + nodeName : subPath + "/" + nodeName;
            if (this.isTimelineView()) {
                temp.setChildren(this.getTreeWithNoDocuments(jcrExplorer.getChildrenList(subPath, false)));
            } else {
                temp.setChildren(jcrExplorer.getChildrenList(subPath, false));
            }
            if (temp.getChildrenSize() <= nodePerPages) continue;
            ObjectPageList list = new ObjectPageList(temp.getChildren(), nodePerPages);
            this.addTreeNodePageIteratorAsChild(temp.getPath(), list, subPath, path);
        }
        this.treeRoot_ = treeRoot;
    }

    public void buildTree() throws Exception {
        this.buildTree(null);
    }

    public boolean isDocumentNodeType(Node node) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.isManagedNodeType(node.getPrimaryNodeType().getName(), this.getRepository());
    }

    public String getSelectedPath() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return UITreeExplorer.encodeBase64(uiExplorer.getCurrentPath());
    }

    private static boolean isInTrash(Item item) throws RepositoryException {
        return item instanceof Node && ((Node)item).isNodeType(EXO_RESTORE_LOCATION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowDrivesAreaActionListener
    extends EventListener<UITreeExplorer> {
        public void execute(Event<UITreeExplorer> event) throws Exception {
            UITreeExplorer uiTreeExplorer = (UITreeExplorer)((Object)event.getSource());
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiTreeExplorer.getAncestorOfType(UIWorkingArea.class);
            ((UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class)).setRendered(true);
            ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingArea);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollapseActionListener
    extends EventListener<UITreeExplorer> {
        public void execute(Event<UITreeExplorer> event) throws Exception {
            UITreeExplorer treeExplorer = (UITreeExplorer)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)treeExplorer.getAncestorOfType(UIApplication.class);
            try {
                String path = event.getRequestContext().getRequestParameter("objectId");
                UIJCRExplorer uiExplorer = (UIJCRExplorer)treeExplorer.getAncestorOfType(UIJCRExplorer.class);
                path = LinkUtils.getParentPath((String)path);
                uiExplorer.setSelectNode(path);
                uiExplorer.updateAjax(event);
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.repository-error", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpandTreeActionListener
    extends EventListener<UITreeExplorer> {
        public void execute(Event<UITreeExplorer> event) throws Exception {
            UITreeExplorer uiTreeExplorer = (UITreeExplorer)((Object)event.getSource());
            String path = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTreeExplorer.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiTreeExplorer.getAncestorOfType(UIApplication.class);
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            Item item = null;
            try {
                Session session = uiExplorer.getSessionByWorkspace(workspaceName);
                NodeFinder nodeFinder = (NodeFinder)uiTreeExplorer.getApplicationComponent(NodeFinder.class);
                item = nodeFinder.getItem(session, path);
            }
            catch (PathNotFoundException pa) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (ItemNotFoundException inf) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.repository-error", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            if (UITreeExplorer.isInTrash(item)) {
                return;
            }
            if (uiExplorer.getPreference().isShowSideBar() && ((UIJCRExplorerPortlet)uiExplorer.getAncestorOfType(UIJCRExplorerPortlet.class)).isShowSideBar()) {
                uiTreeExplorer.buildTree(path);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpandActionListener
    extends EventListener<UITreeExplorer> {
        public void execute(Event<UITreeExplorer> event) throws Exception {
            UITreeExplorer uiTreeExplorer = (UITreeExplorer)((Object)event.getSource());
            String path = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTreeExplorer.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiTreeExplorer.getAncestorOfType(UIApplication.class);
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            Item item = null;
            try {
                Session session = uiExplorer.getSessionByWorkspace(workspaceName);
                NodeFinder nodeFinder = (NodeFinder)uiTreeExplorer.getApplicationComponent(NodeFinder.class);
                item = nodeFinder.getItem(session, path);
            }
            catch (PathNotFoundException pa) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (ItemNotFoundException inf) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.repository-error", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            if (UITreeExplorer.isInTrash(item)) {
                return;
            }
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            if (!uiDocumentWorkspace.isRendered()) {
                ((UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class)).setRendered(false);
                uiDocumentWorkspace.setRendered(true);
            } else {
                uiDocumentWorkspace.setRenderedChild(UIDocumentContainer.class);
            }
            uiExplorer.setSelectNode(workspaceName, path);
            uiExplorer.updateAjax(event);
        }
    }
}

