/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.io.ByteArrayInputStream;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.jboss.ws.core.HTTPMessageImpl;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPElementWriter;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class MessageTrace {
    private static final Logger msgLog = Logger.getLogger(MessageTrace.class);

    private MessageTrace() {
    }

    public static void traceMessage(String messagePrefix, Object message) {
        if (!msgLog.isTraceEnabled()) {
            return;
        }
        if (message instanceof SOAPMessage) {
            try {
                SOAPEnvelope soapEnv = ((SOAPMessage)message).getSOAPPart().getEnvelope();
                if (soapEnv != null) {
                    String envStr = SOAPElementWriter.writeElement((SOAPElementImpl)soapEnv, true);
                    msgLog.trace((Object)(messagePrefix + "\n" + envStr));
                }
            }
            catch (SOAPException ex) {
                msgLog.error((Object)"Cannot trace SOAPMessage", (Throwable)ex);
            }
        } else if (message instanceof HTTPMessageImpl) {
            HTTPMessageImpl httpMessage = (HTTPMessageImpl)message;
            Element root = httpMessage.getXmlFragment().toElement();
            String xmlString = DOMWriter.printNode((Node)root, (boolean)true);
            msgLog.trace((Object)(messagePrefix + "\n" + xmlString));
        } else if (message instanceof byte[]) {
            Element root = new XMLFragment(new StreamSource(new ByteArrayInputStream((byte[])message))).toElement();
            String xmlString = DOMWriter.printNode((Node)root, (boolean)true);
            msgLog.trace((Object)(messagePrefix + "\n" + xmlString));
        } else if (message instanceof String) {
            Element root = new XMLFragment(new StreamSource(new ByteArrayInputStream(((String)message).getBytes()))).toElement();
            String xmlString = DOMWriter.printNode((Node)root, (boolean)true);
            msgLog.trace((Object)(messagePrefix + "\n" + xmlString));
        } else {
            msgLog.warn((Object)("Unsupported message type: " + message));
        }
    }
}

