/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import java.net.URLClassLoader;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.classpool.DefaultClassLoaderIsLocalResourcePluginFactory;
import org.jboss.aop.classpool.IsLocalResourcePluginFactory;
import org.jboss.aop.classpool.TranslatableClassLoaderIsLocalResourcePluginFactory;
import org.jboss.aop.classpool.URLClassLoaderIsLocalResourcePluginFactory;
import org.jboss.util.loading.Translatable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsLocalResourcePluginFactoryRegistry {
    private static Map<Class<?>, IsLocalResourcePluginFactory> plugins = new WeakHashMap();

    public static synchronized void addPluginFactory(Class<?> classLoaderClass, IsLocalResourcePluginFactory plugin) {
        plugins.put(classLoaderClass, plugin);
    }

    public static synchronized void removePluginFactory(Class<?> classLoaderClass, IsLocalResourcePluginFactory plugin) {
        plugins.remove(classLoaderClass);
    }

    public static synchronized IsLocalResourcePluginFactory getPluginFactory(ClassLoader classLoader) {
        if (classLoader != null) {
            return IsLocalResourcePluginFactoryRegistry.getPluginFactory(classLoader.getClass());
        }
        return IsLocalResourcePluginFactoryRegistry.getPluginFactory(ClassLoader.class);
    }

    public static synchronized IsLocalResourcePluginFactory getPluginFactory(Class<?> classLoaderClass) {
        IsLocalResourcePluginFactory plugin = plugins.get(classLoaderClass);
        if (plugin == null) {
            Class<?> superClass;
            Class<?>[] interfaces = classLoaderClass.getInterfaces();
            if (interfaces.length > 0) {
                for (Class<?> iface : interfaces) {
                    plugin = IsLocalResourcePluginFactoryRegistry.getPluginFactory(iface);
                    if (plugin == null) continue;
                    return plugin;
                }
            }
            if ((superClass = classLoaderClass.getSuperclass()) != null && superClass != Object.class) {
                return IsLocalResourcePluginFactoryRegistry.getPluginFactory(superClass);
            }
        }
        return plugin;
    }

    static {
        IsLocalResourcePluginFactoryRegistry.addPluginFactory(ClassLoader.class, new DefaultClassLoaderIsLocalResourcePluginFactory());
        IsLocalResourcePluginFactoryRegistry.addPluginFactory(URLClassLoader.class, new URLClassLoaderIsLocalResourcePluginFactory());
        IsLocalResourcePluginFactoryRegistry.addPluginFactory(Translatable.class, new TranslatableClassLoaderIsLocalResourcePluginFactory());
    }
}

