/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.core.UIPopupWindow;
import org.exoplatform.wcm.webui.selector.content.UIContentSearchForm;
import org.exoplatform.wcm.webui.selector.content.UIContentSelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ChangeMetadataTypeActionListener.class})})
public class UIContentPropertySelector
extends UIForm {
    public static final String WEB_CONTENT_METADATA_POPUP = "WebContentMetadataPopup";
    public static final String METADATA_TYPE = "metadataType";
    public static final String PROPERTY_SELECT = "property_select";
    private String fieldName = null;
    private List<SelectItemOption<String>> properties = new ArrayList<SelectItemOption<String>>();

    public UIContentPropertySelector() throws Exception {
        this.setActions(new String[]{"Add", "Cancel"});
    }

    public void init() throws Exception {
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        UIFormSelectBox uiSelect = new UIFormSelectBox(METADATA_TYPE, METADATA_TYPE, options);
        uiSelect.setOnChange("ChangeMetadataType");
        this.addUIFormInput((UIFormInput)uiSelect);
        SessionProvider sessionProvider = Utils.getSystemSessionProvider();
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manRepository = repoService.getCurrentRepository();
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspaceName = dmsConfiguration.getConfig(manRepository.getConfiguration().getName()).getSystemWorkspace();
        Session session = sessionProvider.getSession(workspaceName, manRepository);
        String metadataPath = nodeHierarchyCreator.getJcrPath("metadataPath");
        Node homeNode = (Node)session.getItem(metadataPath);
        NodeIterator nodeIter = homeNode.getNodes();
        Node meta = nodeIter.nextNode();
        this.renderProperties(meta.getName());
        options.add(new SelectItemOption(meta.getName(), (Object)meta.getName()));
        while (nodeIter.hasNext()) {
            meta = nodeIter.nextNode();
            options.add(new SelectItemOption(meta.getName(), (Object)meta.getName()));
        }
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(PROPERTY_SELECT, null, this.properties).setAlign(UIFormRadioBoxInput.VERTICAL_ALIGN));
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void renderProperties(String metadata) throws Exception {
        PropertyDefinition[] propertieDefs;
        this.properties.clear();
        SessionProvider sessionProvider = Utils.getSystemSessionProvider();
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manRepository = repoService.getCurrentRepository();
        String workspaceName = manRepository.getConfiguration().getSystemWorkspaceName();
        Session session = sessionProvider.getSession(workspaceName, manRepository);
        NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
        NodeType nt = ntManager.getNodeType(metadata);
        for (PropertyDefinition property : propertieDefs = nt.getPropertyDefinitions()) {
            String name = property.getName();
            if (name.equals("exo:internalUse")) continue;
            this.properties.add((SelectItemOption<String>)new SelectItemOption(name, (Object)name));
        }
        session.logout();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeMetadataTypeActionListener
    extends EventListener<UIContentPropertySelector> {
        public void execute(Event<UIContentPropertySelector> event) throws Exception {
            UIContentPropertySelector contentPropertySelector = (UIContentPropertySelector)((Object)event.getSource());
            contentPropertySelector.renderProperties((String)contentPropertySelector.getUIFormSelectBox(UIContentPropertySelector.METADATA_TYPE).getValue());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentPropertySelector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIContentPropertySelector> {
        public void execute(Event<UIContentPropertySelector> event) throws Exception {
            UIContentPropertySelector contentPropertySelector = (UIContentPropertySelector)((Object)event.getSource());
            String property = (String)((UIFormRadioBoxInput)contentPropertySelector.getUIInput(UIContentPropertySelector.PROPERTY_SELECT)).getValue();
            UIPopupWindow popupWindow = (UIPopupWindow)Utils.getPopupContainer((UIContainer)contentPropertySelector).getChildById("CorrectContentSelectorPopupWindow");
            UIContentSelector contentSelector = (UIContentSelector)popupWindow.getUIComponent();
            UIContentSearchForm contentSearchForm = (UIContentSearchForm)contentSelector.findFirstComponentOfType(UIContentSearchForm.class);
            contentSearchForm.getUIStringInput(contentPropertySelector.getFieldName()).setValue((Object)property);
            Utils.closePopupWindow((UIContainer)contentPropertySelector, UIContentPropertySelector.WEB_CONTENT_METADATA_POPUP);
            contentSelector.setSelectedTab(contentSearchForm.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIContentPropertySelector> {
        public void execute(Event<UIContentPropertySelector> event) throws Exception {
            UIContentPropertySelector contentPropertySelector = (UIContentPropertySelector)((Object)event.getSource());
            Utils.closePopupWindow((UIContainer)contentPropertySelector, UIContentPropertySelector.WEB_CONTENT_METADATA_POPUP);
        }
    }
}

