/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynchronous.concurrent;

import java.util.concurrent.Callable;
import org.jboss.aspects.asynchronous.AsynchronousConstants;
import org.jboss.aspects.asynchronous.AsynchronousParameters;
import org.jboss.aspects.asynchronous.AsynchronousResponse;
import org.jboss.aspects.asynchronous.AsynchronousUserTask;
import org.jboss.aspects.asynchronous.ProcessingTime;
import org.jboss.aspects.asynchronous.common.ThreadManagerResponseImpl;

final class AdapterTask
implements Callable,
AsynchronousConstants,
ProcessingTime {
    private AsynchronousParameters _inputParametersImpl = null;
    private AsynchronousUserTask _taskImpl = null;
    private String id = null;
    private long startingTime = -1L;
    private long endingTime = -1L;

    AdapterTask(String id, AsynchronousParameters inputParametersImpl, AsynchronousUserTask taskImpl) {
        this._inputParametersImpl = inputParametersImpl;
        this._taskImpl = taskImpl;
        this.id = id;
    }

    public void cleanup() {
        this._taskImpl.cleanup(this._inputParametersImpl);
    }

    public Object call() {
        try {
            this.startingTime = System.currentTimeMillis();
            AsynchronousResponse taskResult = this._taskImpl.process(this._inputParametersImpl);
            this.endingTime = System.currentTimeMillis();
            ThreadManagerResponseImpl myResult = new ThreadManagerResponseImpl(this.getId(), 0, null, taskResult, this.startingTime, this.endingTime);
            return myResult;
        }
        catch (Exception e) {
            try {
                this.endingTime = System.currentTimeMillis();
                return new ThreadManagerResponseImpl(this.getId(), 999, e.getMessage(), e);
            }
            catch (Exception ee) {
                this.endingTime = System.currentTimeMillis();
                return new ThreadManagerResponseImpl(this.getId(), 999, e.getMessage(), ee);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public long getStartingTime() {
        return this.startingTime;
    }

    public long getEndingTime() {
        return this.endingTime;
    }
}

