/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.concurrent;

import java.util.concurrent.locks.ReentrantLock;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.concurrent.LockAcquisitionFailureException;
import org.jboss.aspects.concurrent.MutexedMethod;

public class MutexedMethodAspect {
    protected ReentrantLock lock;
    protected MutexedMethod props;

    public MutexedMethodAspect(MutexedMethod m) {
        this.props = m;
        this.lock = new ReentrantLock(m.isFair());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquire(Invocation invocation) throws Throwable {
        if (this.props.timeout() == -1L) {
            this.blockIndefinately();
        } else if (this.props.timeout() == 0L) {
            this.tryLock();
        } else {
            this.tryLockWithTimeout();
        }
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void blockIndefinately() {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new LockAcquisitionFailureException("Failed to lock @MutexedMethod", e);
        }
    }

    protected void tryLock() {
        if (!this.lock.tryLock()) {
            throw new LockAcquisitionFailureException("Failed to lock @MutexedMethod");
        }
    }

    protected void tryLockWithTimeout() {
        try {
            if (!this.lock.tryLock(this.props.timeout(), this.props.unit())) {
                throw new LockAcquisitionFailureException("Failed to lock @MutexedMethod.  Timeout reached.");
            }
        }
        catch (InterruptedException e) {
            throw new LockAcquisitionFailureException("Failed to lock @MutexedMethod", e);
        }
    }
}

