/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.IllegalACLException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CQJDBCStorageConnection
extends JDBCStorageConnection {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.CQJDBCStorageConnection");
    protected String FIND_NODES_BY_PARENTID_CQ;
    protected String FIND_PROPERTIES_BY_PARENTID_CQ;
    protected String FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ;
    protected String FIND_ITEM_QPATH_BY_ID_CQ;
    protected PreparedStatement findNodesByParentIdCQ;
    protected PreparedStatement findPropertiesByParentIdCQ;
    protected PreparedStatement findNodeMainPropertiesByParentIdentifierCQ;
    protected PreparedStatement findItemQPathByIdentifierCQ;
    private static Comparator<ValueData> COMPARATOR_VALUE_DATA = new Comparator<ValueData>(){

        @Override
        public int compare(ValueData vd1, ValueData vd2) {
            return vd1.getOrderNumber() - vd2.getOrderNumber();
        }
    };

    protected CQJDBCStorageConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        ArrayList<NodeData> arrayList;
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            try {
                PersistedNodeData nodeData;
                resultSet = this.findChildNodesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()));
                TempNodeData data = null;
                ArrayList<NodeData> childNodes = new ArrayList<NodeData>();
                while (resultSet.next()) {
                    if (data == null) {
                        data = new TempNodeData(resultSet);
                    } else if (!resultSet.getString("ID").equals(data.cid)) {
                        nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                        childNodes.add(nodeData);
                        data = new TempNodeData(resultSet);
                    }
                    Map<String, SortedSet<TempPropertyData>> properties = data.properties;
                    String key = resultSet.getString("PROP_NAME");
                    SortedSet<TempPropertyData> values = properties.get(key);
                    if (values == null) {
                        values = new TreeSet<TempPropertyData>();
                        properties.put(key, values);
                    }
                    values.add(new TempPropertyData(resultSet));
                }
                if (data != null) {
                    nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                    childNodes.add(nodeData);
                }
                arrayList = childNodes;
                Object var9_10 = null;
                if (resultSet == null) return arrayList;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
                throw throwable;
            }
        }
        try {}
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
            return arrayList;
        }
        resultSet.close();
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        ArrayList<PropertyData> arrayList;
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            try {
                resultSet = this.findChildPropertiesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()));
                ArrayList<PropertyData> children = new ArrayList<PropertyData>();
                QPath parentPath = parent.getQPath();
                if (resultSet.next()) {
                    boolean isNotLast = true;
                    do {
                        QPath qpath;
                        String cid = resultSet.getString("ID");
                        String identifier = this.getIdentifier(cid);
                        String cname = resultSet.getString("NAME");
                        int cversion = resultSet.getInt("VERSION");
                        String cpid = resultSet.getString("PARENT_ID");
                        int cptype = resultSet.getInt("P_TYPE");
                        boolean cpmultivalued = resultSet.getBoolean("P_MULTIVALUED");
                        try {
                            qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, InternalQName.parse(cname));
                        }
                        catch (IllegalNameException e) {
                            throw new RepositoryException(e.getMessage(), (Throwable)e);
                        }
                        ArrayList<ValueData> data = new ArrayList<ValueData>();
                        do {
                            int orderNum = resultSet.getInt("ORDER_NUM");
                            if (resultSet.wasNull()) continue;
                            String storageId = resultSet.getString("STORAGE_DESC");
                            ValueData vdata = resultSet.wasNull() ? this.readValueData(cid, orderNum, cversion, resultSet.getBinaryStream("DATA")) : this.readValueData(identifier, orderNum, storageId);
                            data.add(vdata);
                        } while ((isNotLast = resultSet.next()) && resultSet.getString("ID").equals(cid));
                        Collections.sort(data, COMPARATOR_VALUE_DATA);
                        PersistedPropertyData pdata = new PersistedPropertyData(identifier, qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued, data);
                        children.add(pdata);
                    } while (isNotLast);
                }
                arrayList = children;
                Object var19_23 = null;
                if (resultSet == null) return arrayList;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
                throw throwable;
            }
        }
        try {}
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
            return arrayList;
        }
        resultSet.close();
        return arrayList;
    }

    protected List<AccessControlEntry> readACLPermisions(String cid, Map<String, SortedSet<TempPropertyData>> properties) throws SQLException, IllegalACLException {
        ArrayList<AccessControlEntry> naPermissions = new ArrayList<AccessControlEntry>();
        Set permValues = properties.get(Constants.EXO_PERMISSIONS.getAsString());
        if (permValues != null) {
            for (TempPropertyData value : permValues) {
                StringTokenizer parser = new StringTokenizer(new String(value.data), " ");
                naPermissions.add(new AccessControlEntry(parser.nextToken(), parser.nextToken()));
            }
            return naPermissions;
        }
        throw new IllegalACLException("Property exo:permissions is not found for node with id: " + this.getIdentifier(cid));
    }

    protected String readACLOwner(String cid, Map<String, SortedSet<TempPropertyData>> properties) throws IllegalACLException {
        SortedSet<TempPropertyData> ownerValues = properties.get(Constants.EXO_OWNER.getAsString());
        if (ownerValues != null) {
            return new String(ownerValues.first().data);
        }
        throw new IllegalACLException("Property exo:owner is not found for node with id: " + this.getIdentifier(cid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PersistedNodeData loadNodeRecord(QPath parentPath, String cname, String cid, String cpid, int cindex, int cversion, int cnordernumb, AccessControlList parentACL) throws RepositoryException, SQLException {
        PersistedNodeData persistedNodeData;
        ResultSet ptProp = this.findNodeMainPropertiesByParentIdentifierCQ(cid);
        try {
            HashMap<String, SortedSet<TempPropertyData>> properties = new HashMap<String, SortedSet<TempPropertyData>>();
            while (ptProp.next()) {
                String key = ptProp.getString("NAME");
                TreeSet<TempPropertyData> values = (TreeSet<TempPropertyData>)properties.get(key);
                if (values == null) {
                    values = new TreeSet<TempPropertyData>();
                    properties.put(key, values);
                }
                values.add(new TempPropertyData(ptProp));
            }
            persistedNodeData = this.loadNodeRecord(parentPath, cname, cid, cpid, cindex, cversion, cnordernumb, properties, parentACL);
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            try {
                ptProp.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            throw throwable;
        }
        try {
            ptProp.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
        }
        return persistedNodeData;
    }

    protected PersistedNodeData loadNodeFromTemporaryNodeData(TempNodeData tempData, QPath parentPath, AccessControlList parentACL) throws RepositoryException, SQLException, IOException {
        return this.loadNodeRecord(parentPath, tempData.cname, tempData.cid, tempData.cpid, tempData.cindex, tempData.cversion, tempData.cnordernumb, tempData.properties, parentACL);
    }

    private PersistedNodeData loadNodeRecord(QPath parentPath, String cname, String cid, String cpid, int cindex, int cversion, int cnordernumb, Map<String, SortedSet<TempPropertyData>> properties, AccessControlList parentACL) throws RepositoryException, SQLException {
        try {
            InternalQName[] mts;
            String parentCid;
            QPath qpath;
            InternalQName qname = InternalQName.parse(cname);
            if (parentPath != null) {
                qpath = QPath.makeChildPath(parentPath, qname, cindex);
                parentCid = cpid;
            } else if (cpid.equals(Constants.ROOT_PARENT_UUID)) {
                qpath = Constants.ROOT_PATH;
                parentCid = null;
            } else {
                qpath = QPath.makeChildPath(this.traverseQPath(cpid), qname, cindex);
                parentCid = cpid;
            }
            SortedSet<TempPropertyData> primaryType = properties.get(Constants.JCR_PRIMARYTYPE.getAsString());
            if (primaryType == null || primaryType.isEmpty()) {
                throw new PrimaryTypeNotFoundException("FATAL ERROR primary type record not found. Node " + qpath.getAsString() + ", id " + cid + ", container " + this.containerName, null);
            }
            byte[] data = primaryType.first().data;
            InternalQName ptName = InternalQName.parse(new String(data != null ? data : new byte[]{}));
            boolean owneable = false;
            boolean privilegeable = false;
            Set mixTypes = properties.get(Constants.JCR_MIXINTYPES.getAsString());
            if (mixTypes != null) {
                ArrayList<InternalQName> mNames = new ArrayList<InternalQName>();
                for (TempPropertyData mxnb : mixTypes) {
                    InternalQName mxn = InternalQName.parse(new String(mxnb.data));
                    mNames.add(mxn);
                    if (!privilegeable && Constants.EXO_PRIVILEGEABLE.equals((Object)mxn)) {
                        privilegeable = true;
                        continue;
                    }
                    if (owneable || !Constants.EXO_OWNEABLE.equals((Object)mxn)) continue;
                    owneable = true;
                }
                mts = new InternalQName[mNames.size()];
                mNames.toArray(mts);
            } else {
                mts = new InternalQName[]{};
            }
            try {
                AccessControlList acl = owneable ? (privilegeable ? new AccessControlList(this.readACLOwner(cid, properties), this.readACLPermisions(cid, properties)) : (parentACL != null ? new AccessControlList(this.readACLOwner(cid, properties), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : new AccessControlList(this.readACLOwner(cid, properties), null))) : (privilegeable ? (owneable ? new AccessControlList(this.readACLOwner(cid, properties), this.readACLPermisions(cid, properties)) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), this.readACLPermisions(cid, properties)) : new AccessControlList(null, this.readACLPermisions(cid, properties)))) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : null));
                return new PersistedNodeData(this.getIdentifier(cid), qpath, this.getIdentifier(parentCid), cversion, cnordernumb, ptName, mts, acl);
            }
            catch (IllegalACLException e) {
                throw new RepositoryException("FATAL ERROR Node " + this.getIdentifier(cid) + " " + qpath.getAsString() + " has wrong formed ACL. ", (Throwable)e);
            }
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected QPath traverseQPath(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        id = this.getIdentifier(cpid);
        if (id.equals("00exo0jcr0root0uuid0000000000000")) {
            return Constants.ROOT_PATH;
        }
        qrpath = new ArrayList<QPathEntry>();
        caid = cpid;
        isRoot = false;
        do {
            result = null;
            try {
                result = this.findItemQPathByIdentifierCQ(caid);
                if (!result.next()) {
                    throw new InvalidItemStateException("Parent not found, uuid: " + this.getIdentifier(caid));
                }
                qpe1 = new QPathEntry(InternalQName.parse(result.getString("NAME")), result.getInt("I_INDEX"));
                isChild = caid.equals(result.getString("ID"));
                caid = result.getString("PARENT_ID");
                if (result.next()) {
                    qpe2 = new QPathEntry(InternalQName.parse(result.getString("NAME")), result.getInt("I_INDEX"));
                    if (isChild) {
                        qrpath.add(qpe1);
                        qrpath.add(qpe2);
                        caid = result.getString("PARENT_ID");
                    } else {
                        qrpath.add(qpe2);
                        qrpath.add(qpe1);
                    }
                } else {
                    qrpath.add(qpe1);
                }
                var11_11 = null;
                ** if (result == null) goto lbl-1000
            }
            catch (Throwable var10_13) {
                var11_11 = null;
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException e) {
                        CQJDBCStorageConnection.LOG.error((Object)("Can't close the ResultSet: " + e));
                    }
                }
                throw var10_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    result.close();
                }
                catch (SQLException e) {
                    CQJDBCStorageConnection.LOG.error((Object)("Can't close the ResultSet: " + e));
                }
            }
lbl-1000:
            // 2 sources

            {
            }
            if (!caid.equals(Constants.ROOT_PARENT_UUID) && !(id = this.getIdentifier(caid)).equals("00exo0jcr0root0uuid0000000000000")) continue;
            if (id.equals("00exo0jcr0root0uuid0000000000000")) {
                qrpath.add(Constants.ROOT_PATH.getEntries()[0]);
            }
            isRoot = true;
        } while (!isRoot);
        qentries = new QPathEntry[qrpath.size()];
        qi = 0;
        for (i = qrpath.size() - 1; i >= 0; --i) {
            qentries[qi++] = (QPathEntry)qrpath.get(i);
        }
        return new QPath(qentries);
    }

    @Override
    protected void closeStatements() {
        super.closeStatements();
        try {
            if (this.findNodesByParentIdCQ != null) {
                this.findNodesByParentIdCQ.close();
            }
            if (this.findPropertiesByParentIdCQ != null) {
                this.findPropertiesByParentIdCQ.close();
            }
            if (this.findNodeMainPropertiesByParentIdentifierCQ != null) {
                this.findNodeMainPropertiesByParentIdentifierCQ.close();
            }
            if (this.findItemQPathByIdentifierCQ != null) {
                this.findItemQPathByIdentifierCQ.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the Statement: " + e));
        }
    }

    protected abstract ResultSet findItemQPathByIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findChildNodesByParentIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findChildPropertiesByParentIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findNodeMainPropertiesByParentIdentifierCQ(String var1) throws SQLException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TempPropertyData
    implements Comparable<TempPropertyData> {
        int orderNum;
        byte[] data;

        public TempPropertyData(ResultSet item) throws SQLException {
            this.orderNum = item.getInt("ORDER_NUM");
            this.data = item.getBytes("DATA");
        }

        @Override
        public int compareTo(TempPropertyData o) {
            return this.orderNum - o.orderNum;
        }
    }

    private static class TempNodeData {
        String cid;
        String cname;
        int cversion;
        String cpid;
        int cindex;
        int cnordernumb;
        Map<String, SortedSet<TempPropertyData>> properties = new HashMap<String, SortedSet<TempPropertyData>>();

        public TempNodeData(ResultSet item) throws SQLException {
            this.cid = item.getString("ID");
            this.cname = item.getString("NAME");
            this.cversion = item.getInt("VERSION");
            this.cpid = item.getString("PARENT_ID");
            this.cindex = item.getInt("I_INDEX");
            this.cnordernumb = item.getInt("N_ORDER_NUM");
        }
    }
}

