/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.xml.exporting.StreamExporter;

public class SystemViewStreamExporter
extends StreamExporter {
    private static final int BUFFER_SIZE = 9216;

    public SystemViewStreamExporter(XMLStreamWriter writer, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        super(writer, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        try {
            this.writer.writeStartElement("sv", "node", this.getSvNamespaceUri());
            if (level == 0) {
                this.startPrefixMapping();
            }
            this.writer.writeAttribute("sv", this.getSvNamespaceUri(), "name", this.getExportName(node, false));
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        try {
            this.writer.writeStartElement("sv", "property", this.getSvNamespaceUri());
            this.writer.writeAttribute("sv", this.getSvNamespaceUri(), "name", this.getExportName(property, false));
            this.writer.writeAttribute("sv", this.getSvNamespaceUri(), "type", ExtendedPropertyType.nameFromValue(property.getType()));
            List<ValueData> values = property.getValues();
            for (ValueData valueData : values) {
                this.writer.writeStartElement("sv", "value", this.getSvNamespaceUri());
                this.writeValueData(valueData, property.getType());
                this.writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void writeValueData(ValueData data, int type) throws RepositoryException, IllegalStateException, XMLStreamException, IOException {
        if (2 == type) {
            if (!this.isSkipBinary()) {
                if (data.getLength() < 9216L) {
                    String charValue = this.getValueAsStringForExport(data, type);
                    this.writer.writeCharacters(charValue.toCharArray(), 0, charValue.length());
                } else {
                    int len;
                    InputStream is = data.getAsStream();
                    byte[] buffer = new byte[9216];
                    while ((len = is.read(buffer)) > 0) {
                        char[] charbuf1 = Base64.encode((byte[])buffer, (int)0, (int)len, (int)0, (String)"").toCharArray();
                        this.writer.writeCharacters(charbuf1, 0, charbuf1.length);
                    }
                }
            }
        } else {
            String charValue = this.getValueAsStringForExport(data, type);
            this.writer.writeCharacters(charValue.toCharArray(), 0, charValue.length());
        }
    }
}

