/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.xml.checker.beanchildren.ext;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.DefinitionException;
import org.dom4j.Element;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.xml.ParseXmlHelper;
import org.jboss.webbeans.xml.XmlEnvironment;
import org.jboss.webbeans.xml.checker.beanchildren.ext.NotSimpleBeanChildrenChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBeanChildrenChecker
extends NotSimpleBeanChildrenChecker {
    public ResourceBeanChildrenChecker(XmlEnvironment environment, Map<String, Set<String>> packagesMap) {
        super(environment, packagesMap);
    }

    @Override
    protected void checkRIBean(Element beanElement, AnnotatedClass<?> beanClass) {
        List<Element> resourceElements = ParseXmlHelper.findElementsInEeNamespace(beanElement, "Resource");
        if (resourceElements.size() > 0) {
            this.checkResourceElements(resourceElements);
            return;
        }
        List<Element> persContextElements = ParseXmlHelper.findElementsInEeNamespace(beanElement, "PersistenceContext");
        if (persContextElements.size() > 0) {
            this.checkPersContextElements(persContextElements);
            return;
        }
        List<Element> persUnitElements = ParseXmlHelper.findElementsInEeNamespace(beanElement, "PersistenceUnit");
        if (persUnitElements.size() > 0) {
            this.checkPersUnitElements(persUnitElements);
            return;
        }
        List<Element> ejbElements = ParseXmlHelper.findElementsInEeNamespace(beanElement, "EJB");
        if (ejbElements.size() > 0) {
            this.checkEjbElements(ejbElements);
            return;
        }
        List<Element> webServiceRefElements = ParseXmlHelper.findElementsInEeNamespace(beanElement, "WebServiceRef");
        if (webServiceRefElements.size() > 0) {
            this.checkWebServiceRefElements(webServiceRefElements);
            return;
        }
    }

    private void checkResourceElements(List<Element> resourceElements) {
        Element resourceElement = resourceElements.get(0);
        if (resourceElements.size() > 1) {
            throw new DefinitionException("There is more than one <Resource> elements in '" + resourceElement.getParent().getName() + "'");
        }
        List<Element> nameElements = ParseXmlHelper.findElementsInEeNamespace(resourceElement, "name");
        List<Element> mappedNameElements = ParseXmlHelper.findElementsInEeNamespace(resourceElement, "mappedName");
        if (nameElements.size() + mappedNameElements.size() != 1) {
            throw new DefinitionException("For a Java EE resource '" + resourceElement.getParent().getName() + "', JNDI name " + "or mapped name must be specified using the <name> or <mappedName> child elements of the <Resource> element");
        }
        if (nameElements.size() == 1) {
            this.checkJndiNameElementValue(nameElements.get(0));
        }
    }

    private void checkPersContextElements(List<Element> persContextElements) {
        Element persContextElement = persContextElements.get(0);
        if (persContextElements.size() > 1) {
            throw new DefinitionException("There is more than one <PersistenceContext> elements in '" + persContextElement.getParent().getName() + "'");
        }
        List<Element> unitNameElements = ParseXmlHelper.findElementsInEeNamespace(persContextElement, "unitName");
        if (unitNameElements.size() != 1) {
            throw new DefinitionException("For a persistence context '" + persContextElement.getParent().getName() + "', " + "a persistence unit name must be specified using the <unitName> child element of the <PersistenceContext> element");
        }
    }

    private void checkPersUnitElements(List<Element> persUnitElements) {
        Element persUnitElement = persUnitElements.get(0);
        if (persUnitElements.size() > 1) {
            throw new DefinitionException("There is more than one <PersistenceUnit> elements in '" + persUnitElement.getParent().getName() + "'");
        }
        List<Element> unitNameElements = ParseXmlHelper.findElementsInEeNamespace(persUnitElement, "unitName");
        if (unitNameElements.size() != 1) {
            throw new DefinitionException("For a persistence unit '" + persUnitElement.getParent().getName() + "', " + "a persistence unit name must be specified using the <unitName> child element of the <PersistenceUnit> element");
        }
    }

    private void checkEjbElements(List<Element> ejbElements) {
        Element ejbElement = ejbElements.get(0);
        if (ejbElements.size() > 1) {
            throw new DefinitionException("There is more than one <EJB> elements in '" + ejbElement.getParent().getName() + "'");
        }
        List<Element> nameElements = ParseXmlHelper.findElementsInEeNamespace(ejbElement, "name");
        List<Element> mappedNameElements = ParseXmlHelper.findElementsInEeNamespace(ejbElement, "mappedName");
        List<Element> ejbLinkElements = ParseXmlHelper.findElementsInEeNamespace(ejbElement, "ejbLink");
        if (nameElements.size() + mappedNameElements.size() + ejbLinkElements.size() != 1) {
            throw new DefinitionException("For a remote EJB '" + ejbElement.getParent().getName() + "', JNDI name, mapped name or EJB link " + "must be specified using the <name>, <mappedName> or <ejbLink> child elements of the <EJB> element");
        }
        if (nameElements.size() == 1) {
            this.checkJndiNameElementValue(nameElements.get(0));
        }
    }

    private void checkWebServiceRefElements(List<Element> webServiceRefElements) {
        Element webServiceRefElement = webServiceRefElements.get(0);
        if (webServiceRefElements.size() > 1) {
            throw new DefinitionException("There is more than one <WebServiceRef> elements in '" + webServiceRefElement.getParent().getName() + "'");
        }
        List<Element> nameElements = ParseXmlHelper.findElementsInEeNamespace(webServiceRefElement, "name");
        List<Element> mappedNameElements = ParseXmlHelper.findElementsInEeNamespace(webServiceRefElement, "mappedName");
        if (nameElements.size() == 0 && mappedNameElements.size() == 0) {
            throw new DefinitionException("For a web service '" + webServiceRefElement.getParent().getName() + "', JNDI name " + "or mapped name must be specified using the <name> or <mappedName> child elements of the <WebServiceRef> element");
        }
        if (nameElements.size() == 1) {
            this.checkJndiNameElementValue(nameElements.get(0));
        }
    }

    private void checkJndiNameElementValue(Element nameElement) {
        String nameValue = nameElement.getData().toString();
        if (!nameValue.startsWith("java:global/") && !nameValue.startsWith("java:app/")) {
            throw new DefinitionException("The JNDI name specified by the <name> element in <" + nameElement.getParent().getName() + "> for '" + nameElement.getParent().getParent().getName() + "' must be a name in the global java:global or application java:app naming context");
        }
    }
}

