/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.metadata;

import java.lang.annotation.Annotation;
import javax.inject.DefinitionException;
import org.jboss.webbeans.introspector.AnnotatedAnnotation;
import org.jboss.webbeans.resources.ClassTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationModel<T extends Annotation> {
    private AnnotatedAnnotation<T> annotatedAnnotation;
    private boolean valid;

    public AnnotationModel(Class<T> type, ClassTransformer transformer) {
        this.annotatedAnnotation = transformer.classForName(type);
        this.init();
    }

    protected void init() {
        this.initType();
        this.initValid();
    }

    protected void initType() {
        if (!Annotation.class.isAssignableFrom(this.getRawType())) {
            throw new DefinitionException(this.getMetaAnnotation().toString() + " can only be applied to an annotation, it was applied to " + this.getRawType());
        }
    }

    protected void initValid() {
        this.valid = this.annotatedAnnotation.isAnnotationPresent(this.getMetaAnnotation());
    }

    public Class<T> getRawType() {
        return this.annotatedAnnotation.getRawType();
    }

    protected abstract Class<? extends Annotation> getMetaAnnotation();

    public boolean isValid() {
        return this.valid;
    }

    protected AnnotatedAnnotation<T> getAnnotatedAnnotation() {
        return this.annotatedAnnotation;
    }

    public String toString() {
        return (this.isValid() ? "Valid" : "Invalid") + " annotation model for " + this.getRawType();
    }
}

