/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jms.client.remoting.CallbackManager;
import org.jboss.jms.client.remoting.ConsolidatedRemotingConnectionListener;
import org.jboss.jms.wireformat.JMSWireFormat;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.GUIDGenerator;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.util.id.GUID;

public class JMSRemotingConnection {
    private static final Logger log = Logger.getLogger(JMSRemotingConnection.class);
    private Client client;
    private Client onewayClient;
    private boolean clientPing;
    private InvokerLocator serverLocator;
    private CallbackManager callbackManager;
    private boolean strictTck;
    private boolean sendAcksAsync;
    protected boolean failed = false;
    private ConsolidatedRemotingConnectionListener remotingConnectionListener;
    private static final String JBM_MAX_POOL_SIZE_KEY = "JBM_clientMaxPoolSize";

    private static String getPropertySafely(String propName) {
        String prop = null;
        try {
            prop = System.getProperty(propName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prop;
    }

    public static Map createCallbackMetadata(boolean doPushCallbacks, Map metadata, InvokerLocator serverLocator) {
        if (metadata == null) {
            metadata = new HashMap<String, String>();
        }
        metadata.put("onewayThreadPool", "org.jboss.jms.server.remoting.DirectThreadPool");
        if (doPushCallbacks) {
            String propertyPort;
            metadata.put("clientSocketClass", "org.jboss.jms.client.remoting.ClientSocketWrapper");
            metadata.put("serverSocketClass", "org.jboss.jms.server.remoting.ServerSocketWrapper");
            String bindAddress = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.bind.address");
            if (bindAddress != null) {
                metadata.put("callbackServerHost", bindAddress);
            }
            if ((propertyPort = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.bind.port")) != null) {
                metadata.put("callbackServerPort", propertyPort);
            }
            metadata.put("clientMaxPoolSize", "1");
            String protocol = serverLocator.getProtocol();
            if ("bisocket".equals(protocol) || "sslbisocket".equals(protocol)) {
                metadata.put("isCallbackServer", "true");
                if (propertyPort == null) {
                    String guid = new GUID().toString();
                    int hash = guid.hashCode();
                    while (hash <= 0) {
                        if (hash == 0) {
                            guid = GUIDGenerator.generateGUID();
                            hash = guid.hashCode();
                        }
                        if (hash >= 0) continue;
                        if (hash == Integer.MIN_VALUE) {
                            hash = Integer.MAX_VALUE;
                            continue;
                        }
                        hash = -hash;
                    }
                    metadata.put("callbackServerPort", Integer.toString(hash));
                    metadata.put("guid", guid);
                }
            }
        } else {
            String blockingMode = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.blockingMode");
            if (blockingMode == null) {
                blockingMode = (String)serverLocator.getParameters().get("blockingMode");
            }
            if (blockingMode == null) {
                blockingMode = "blocking";
            }
            metadata.put("blockingMode", blockingMode);
            if (blockingMode.equals("blocking")) {
                String blockingTimeout = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.blockingTimeout");
                if (blockingTimeout == null) {
                    blockingTimeout = (String)serverLocator.getParameters().get("blockingTimeout");
                }
                if (blockingTimeout != null) {
                    metadata.put("blockingTimeout", blockingTimeout);
                }
            } else {
                String callbackPollPeriod = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.pollPeriod");
                if (callbackPollPeriod == null) {
                    callbackPollPeriod = (String)serverLocator.getParameters().get("callbackPollPeriod");
                }
                if (callbackPollPeriod != null) {
                    metadata.put("callbackPollPeriod", callbackPollPeriod);
                }
            }
            String reportPollingStatistics = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.reportPollingStatistics");
            if (reportPollingStatistics != null) {
                metadata.put("reportStatistics", reportPollingStatistics);
            }
        }
        return metadata;
    }

    public static void addInvokerCallbackHandler(Object configurer, Client client, Map initialMetadata, InvokerLocator serverLocator, InvokerCallbackHandler invokerCallbackHandler) throws Throwable {
        String protocol = serverLocator.getProtocol();
        boolean isBisocket = "bisocket".equals(protocol) || "sslbisocket".equals(protocol);
        boolean isSocket = "socket".equals(protocol) || "sslsocket".equals(protocol);
        boolean doPushCallbacks = isBisocket || isSocket;
        Map metadata = JMSRemotingConnection.createCallbackMetadata(doPushCallbacks, initialMetadata, serverLocator);
        if (doPushCallbacks) {
            log.trace((Object)(configurer + " is doing push callbacks"));
            client.addListener(invokerCallbackHandler, metadata, null, true);
        } else {
            log.trace((Object)(configurer + " is simulating push callbacks"));
            client.addListener(invokerCallbackHandler, metadata);
        }
    }

    public JMSRemotingConnection(String serverLocatorURI, boolean clientPing, boolean strictTck, boolean sendAcksAsync) throws Exception {
        this.serverLocator = new InvokerLocator(serverLocatorURI);
        this.clientPing = clientPing;
        this.strictTck = strictTck;
        this.sendAcksAsync = sendAcksAsync;
        log.trace((Object)(this + " created"));
    }

    public void start() throws Throwable {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("enableLease", String.valueOf(this.clientPing));
        if (this.serverLocator.getParameters().containsKey("clientMaxPoolSize")) {
            throw new IllegalArgumentException("Invalid remoting configuration - do not specify clientMaxPoolSize use JBM_clientMaxPoolSize instead");
        }
        if (!this.serverLocator.getProtocol().equals("http") & !this.serverLocator.getProtocol().equals("https")) {
            String val = (String)this.serverLocator.getParameters().get(JBM_MAX_POOL_SIZE_KEY);
            if (val == null) {
                log.warn((Object)"JBM_clientMaxPoolSize not specified - defaulting to 200");
                val = "200";
            }
            config.put("clientMaxPoolSize", val);
        }
        this.client = new Client(this.serverLocator, config);
        this.client.setSubsystem("JMS");
        HashMap<String, String> config2 = new HashMap<String, String>();
        config2.put("enableLease", "false");
        config2.put("clientMaxPoolSize", "1");
        this.onewayClient = new Client(this.serverLocator, config2);
        this.onewayClient.setSubsystem("JMS");
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " created client"));
        }
        this.callbackManager = new CallbackManager();
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                JMSRemotingConnection.this.client.connect();
                JMSRemotingConnection.this.onewayClient.connect();
                return null;
            }
        });
        this.client.setMarshaller((Marshaller)new JMSWireFormat());
        this.client.setUnMarshaller((UnMarshaller)new JMSWireFormat());
        this.onewayClient.setMarshaller((Marshaller)new JMSWireFormat());
        this.onewayClient.setUnMarshaller((UnMarshaller)new JMSWireFormat());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("datatype", "jms");
        JMSRemotingConnection.addInvokerCallbackHandler(this, this.client, metadata, this.serverLocator, this.callbackManager);
        log.trace((Object)(this + " started"));
    }

    public void stop() {
        log.trace((Object)(this + " stop"));
        try {
            this.client.removeListener((InvokerCallbackHandler)this.callbackManager);
        }
        catch (Throwable ignore) {
            log.trace((Object)(this + " failed to cleanly remove callback manager from the client"), ignore);
        }
        try {
            this.client.disconnect();
        }
        catch (Throwable ignore) {
            log.trace((Object)(this + " failed to disconnect the client"), ignore);
        }
        try {
            this.onewayClient.disconnect();
        }
        catch (Throwable ignore) {
            log.trace((Object)(this + " failed to disconnect the client"), ignore);
        }
        this.client = null;
        this.onewayClient = null;
        log.trace((Object)(this + " closed"));
    }

    public Client getRemotingClient() {
        return this.client;
    }

    public Client getOnewayClient() {
        return this.onewayClient;
    }

    public CallbackManager getCallbackManager() {
        return this.callbackManager;
    }

    public boolean isStrictTck() {
        return this.strictTck;
    }

    public boolean isSendAcksAsync() {
        return this.sendAcksAsync;
    }

    public synchronized boolean isFailed() {
        return this.failed;
    }

    public synchronized void setFailed() {
        this.failed = true;
        try {
            this.client.setDisconnectTimeout(0);
        }
        catch (Throwable ignore) {
            log.trace((Object)(this + " failed to set disconnect timeout"), ignore);
        }
        try {
            this.onewayClient.setDisconnectTimeout(0);
        }
        catch (Throwable ignore) {
            log.trace((Object)(this + " failed to set disconnect timeout"), ignore);
        }
        this.stop();
    }

    public synchronized boolean addConnectionListener(ConsolidatedRemotingConnectionListener listener) {
        if (this.remotingConnectionListener != null) {
            return false;
        }
        this.client.addConnectionListener((ConnectionListener)listener, this.serverLocator.getParameters());
        this.remotingConnectionListener = listener;
        return true;
    }

    public synchronized void addPlainConnectionListener(ConnectionListener listener) {
        this.client.addConnectionListener(listener, this.serverLocator.getParameters());
    }

    public synchronized void removePlainConnectionListener(ConnectionListener listener) {
        this.client.removeConnectionListener(listener);
    }

    public synchronized ConsolidatedRemotingConnectionListener getConnectionListener() {
        return this.remotingConnectionListener;
    }

    public synchronized ConsolidatedRemotingConnectionListener removeConnectionListener() {
        if (this.remotingConnectionListener == null) {
            return null;
        }
        this.client.removeConnectionListener((ConnectionListener)this.remotingConnectionListener);
        log.trace((Object)(this + " removed consolidated connection listener from " + this.client));
        ConsolidatedRemotingConnectionListener toReturn = this.remotingConnectionListener;
        this.remotingConnectionListener = null;
        return toReturn;
    }

    public String toString() {
        return "JMSRemotingConnection[" + this.serverLocator.getLocatorURI() + "]";
    }
}

