/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.messaging.core.impl.postoffice.ClusterRequest;
import org.jboss.messaging.core.impl.postoffice.RequestTarget;

public class AddAllReplicatedDeliveriesMessage
extends ClusterRequest {
    private int nodeID;
    private Map deliveries;

    public AddAllReplicatedDeliveriesMessage() {
    }

    public AddAllReplicatedDeliveriesMessage(int nodeID, Map deliveries) {
        this.nodeID = nodeID;
        this.deliveries = deliveries;
    }

    Object execute(RequestTarget office) throws Throwable {
        office.handleAddAllReplicatedDeliveries(this.nodeID, this.deliveries);
        return null;
    }

    byte getType() {
        return 12;
    }

    public void read(DataInputStream in) throws Exception {
        this.nodeID = in.readInt();
        int size = in.readInt();
        this.deliveries = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            String queueName = in.readUTF();
            int size2 = in.readInt();
            ConcurrentHashMap ids = new ConcurrentHashMap(size2);
            for (int j = 0; j < size2; ++j) {
                long id = in.readLong();
                String sessionID = in.readUTF();
                ids.put(new Long(id), sessionID);
            }
            this.deliveries.put(queueName, ids);
        }
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.nodeID);
        out.writeInt(this.deliveries.size());
        for (Map.Entry entry : this.deliveries.entrySet()) {
            String queueName = (String)entry.getKey();
            out.writeUTF(queueName);
            Map ids = (Map)entry.getValue();
            out.writeInt(ids.size());
            for (Map.Entry entry2 : ids.entrySet()) {
                Long id = (Long)entry2.getKey();
                String sessionID = (String)entry2.getValue();
                out.writeLong(id);
                out.writeUTF(sessionID);
            }
        }
    }
}

