/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.helpers;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.jboss.xnio.CloseableTcpConnector;
import org.jboss.xnio.ConfigurableFactory;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Xnio;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.BoundServer;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XnioController<T extends Closeable> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.deployer");
    private final ConfigurableFactory<? extends T> configurableFactory;
    private T handle;

    private XnioController(ConfigurableFactory<? extends T> factory) {
        this.configurableFactory = factory;
    }

    public void stop() {
        IoUtils.safeClose(this.handle);
        this.handle = null;
    }

    public void start() throws IOException {
        this.handle = (Closeable)this.configurableFactory.create();
    }

    public T getHandle() {
        return this.handle;
    }

    private <E> void doSetOption(ChannelOption<E> option, E value) throws IOException {
        ConfigurableFactory<? extends T> factory = this.configurableFactory;
        if (value != null) {
            if (factory.getOptions().contains(option)) {
                factory.setOption(option, value);
            } else {
                log.debug("XNIO component does not support option \"%s\"", option);
            }
        }
    }

    public void setBacklog(Integer backlog) throws IOException {
        this.doSetOption(CommonOptions.BACKLOG, backlog);
    }

    public void setBroadcast(Boolean broadcast) throws IOException {
        this.doSetOption(CommonOptions.BROADCAST, broadcast);
    }

    public void setCloseAbort(Boolean closeAbort) throws IOException {
        this.doSetOption(CommonOptions.CLOSE_ABORT, closeAbort);
    }

    public void setIpTrafficClass(Integer ipTrafficClass) throws IOException {
        this.doSetOption(CommonOptions.IP_TRAFFIC_CLASS, ipTrafficClass);
    }

    public void setKeepAlive(Boolean keepAlive) throws IOException {
        this.doSetOption(CommonOptions.KEEP_ALIVE, keepAlive);
    }

    public void setManageConnections(Boolean manageConnections) throws IOException {
        this.doSetOption(CommonOptions.MANAGE_CONNECTIONS, manageConnections);
    }

    public void setMulticastTtl(Integer multicastTtl) throws IOException {
        this.doSetOption(CommonOptions.MULTICAST_TTL, multicastTtl);
    }

    public void setOobInline(Boolean oobInline) throws IOException {
        this.doSetOption(CommonOptions.TCP_OOB_INLINE, oobInline);
    }

    public void setReceiveBufferSize(Integer receiveBufferSize) throws IOException {
        this.doSetOption(CommonOptions.RECEIVE_BUFFER, receiveBufferSize);
    }

    public void setReuseAddresses(Boolean reuseAddresses) throws IOException {
        this.doSetOption(CommonOptions.REUSE_ADDRESSES, reuseAddresses);
    }

    public void setSendBufferSize(Integer sendBufferSize) throws IOException {
        this.doSetOption(CommonOptions.SEND_BUFFER, sendBufferSize);
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) throws IOException {
        this.doSetOption(CommonOptions.TCP_NODELAY, tcpNoDelay);
    }

    private static <X extends Closeable> XnioController<X> create(ConfigurableFactory<X> factory) {
        return new XnioController<X>(factory);
    }

    public static XnioController<BoundServer<SocketAddress, BoundChannel<SocketAddress>>> tcpServer(Xnio xnio, IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress[] bindAddresses) {
        return XnioController.create(xnio.createTcpServer(handlerFactory, bindAddresses));
    }

    public static XnioController<BoundServer<SocketAddress, BoundChannel<SocketAddress>>> tcpServer(Xnio xnio, Executor executor, IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress[] bindAddresses) {
        return XnioController.create(xnio.createTcpServer(executor, handlerFactory, bindAddresses));
    }

    public static XnioController<BoundServer<SocketAddress, UdpChannel>> udpServer(Xnio xnio, boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress[] bindAddresses) {
        return XnioController.create(xnio.createUdpServer(multicast, handlerFactory, bindAddresses));
    }

    public static XnioController<BoundServer<SocketAddress, UdpChannel>> udpServer(Xnio xnio, Executor executor, boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress[] bindAddresses) {
        return XnioController.create(xnio.createUdpServer(executor, multicast, handlerFactory, bindAddresses));
    }

    public static XnioController<CloseableTcpConnector> tcpConnector(Xnio xnio) {
        return XnioController.create(xnio.createTcpConnector());
    }

    public static XnioController<CloseableTcpConnector> tcpConnector(Xnio xnio, Executor executor) {
        return XnioController.create(xnio.createTcpConnector(executor));
    }
}

