/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.OverviewURL;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class OverviewDocHandler
extends AbstractHandler {
    public static final String TAG_NAME = "overviewDoc";
    private HandlerMaker maker = null;

    protected OverviewDocHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        OverviewDoc obj = new OverviewDoc();
        Vector nodeList = null;
        AbstractHandler handler = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "description");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("description");
            Description descr = (Description)handler.unmarshal((Element)nodeList.elementAt(i));
            if (descr == null) continue;
            obj.addDescription(descr);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "overviewURL");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("overviewURL");
            obj.setOverviewURL((OverviewURL)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        OverviewURL overURL;
        OverviewDoc overDoc = (OverviewDoc)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        Vector descrVector = overDoc.getDescriptionVector();
        if (descrVector != null && descrVector.size() > 0) {
            handler = this.maker.lookup("description");
            for (int i = 0; i < descrVector.size(); ++i) {
                handler.marshal((Description)descrVector.elementAt(i), element);
            }
        }
        if ((overURL = overDoc.getOverviewURL()) != null) {
            handler = this.maker.lookup("overviewURL");
            handler.marshal(overURL, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

