/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.inventory.TimeoutException;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pluginapi.inventory.ResourceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailabilityExecutor
implements Runnable,
Callable<AvailabilityReport> {
    private static final int GET_AVAILABILITY_TIMEOUT = 5000;
    private final Log log = LogFactory.getLog(AvailabilityExecutor.class);
    private InventoryManager inventoryManager;
    private AtomicBoolean sendChangedOnlyReport;
    private final Object lock = new Object();

    public AvailabilityExecutor(InventoryManager inventoryManager) {
        this.inventoryManager = inventoryManager;
        this.sendChangedOnlyReport = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object = this.lock;
            synchronized (object) {
                AvailabilityReport report = this.call();
                this.inventoryManager.handleReport(report);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Availability report collection failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AvailabilityReport call() throws Exception {
        AvailabilityReport availabilityReport;
        this.log.debug((Object)"Running Availability Scan...");
        Object object = this.lock;
        synchronized (object) {
            availabilityReport = new AvailabilityReport(this.sendChangedOnlyReport.get(), this.inventoryManager.getAgent().getName());
            if (this.inventoryManager.getPlatform().getInventoryStatus() != InventoryStatus.COMMITTED) {
                return null;
            }
            long start = System.currentTimeMillis();
            this.checkInventory(this.inventoryManager.getPlatform(), availabilityReport, availabilityReport.isChangesOnlyReport(), true);
            if (availabilityReport.getResourceAvailability().size() == 0) {
                this.checkInventory(this.inventoryManager.getPlatform(), availabilityReport, false, false);
            }
            if (availabilityReport.getResourceAvailability().size() > 1) {
                this.sendChangedOnlyReportNextTime();
            }
            long end = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(availabilityReport);
                this.log.debug((Object)("Built availability report for [" + availabilityReport.getResourceAvailability().size() + "] resources with a size of [" + baos.size() + "] bytes in [" + (end - start) + "]ms"));
            }
        }
        return availabilityReport;
    }

    private void checkInventory(Resource resource, AvailabilityReport availabilityReport, boolean reportChangesOnly, boolean checkChildren) {
        block20: {
            ResourceComponent resourceComponent;
            ResourceContainer resourceContainer;
            block18: {
                resourceContainer = this.inventoryManager.getResourceContainer(resource);
                resourceComponent = null;
                if (resourceContainer != null) {
                    try {
                        resourceComponent = resourceContainer.createResourceComponentProxy(ResourceComponent.class, FacetLockType.NONE, 5000L, true, false);
                    }
                    catch (PluginContainerException e) {
                        if (!this.log.isDebugEnabled()) break block18;
                        this.log.debug((Object)("Could not create resource component proxy for " + resource + " due to " + (Object)((Object)e)));
                    }
                }
            }
            if (resourceComponent == null) break block20;
            AvailabilityType current = null;
            if (resource.getInventoryStatus() == InventoryStatus.COMMITTED) {
                Availability previous;
                block19: {
                    previous = this.inventoryManager.getAvailabilityIfKnown(resource);
                    try {
                        if (resourceContainer.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED) {
                            current = resourceComponent.getAvailability();
                        } else {
                            this.inventoryManager.activateResource(resource, resourceContainer, false);
                            if (resourceContainer.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED) {
                                current = resourceComponent.getAvailability();
                            }
                        }
                    }
                    catch (Throwable t) {
                        ResourceError resourceError = new ResourceError(resource, ResourceErrorType.AVAILABILITY_CHECK, t, System.currentTimeMillis());
                        this.inventoryManager.sendResourceErrorToServer(resourceError);
                        if (!this.log.isDebugEnabled()) break block19;
                        if (t instanceof TimeoutException) {
                            this.log.debug((Object)("Failed to collect availability on resource " + resource + " (call timed out)"));
                        }
                        this.log.debug((Object)("Failed to collect availability on resource " + resource), t);
                    }
                }
                if (current == null) {
                    current = AvailabilityType.DOWN;
                }
                if (resourceContainer.getSynchronizationState() == ResourceContainer.SynchronizationState.SYNCHRONIZED) {
                    Availability availability = this.inventoryManager.updateAvailability(resource, current);
                    if (previous == null || previous.getAvailabilityType() != current || !reportChangesOnly) {
                        availabilityReport.addAvailability(availability);
                    }
                }
            }
            if (checkChildren) {
                HashSet children = new HashSet(resource.getChildResources());
                if (current == AvailabilityType.UP) {
                    for (Resource child : children) {
                        this.checkInventory(child, availabilityReport, reportChangesOnly, true);
                    }
                } else {
                    for (Resource child : children) {
                        this.markDown(child, availabilityReport, reportChangesOnly);
                    }
                }
            }
        }
    }

    private void markDown(Resource resource, AvailabilityReport availabilityReport, boolean changesOnly) {
        Availability previous = this.inventoryManager.getAvailabilityIfKnown(resource);
        if (!changesOnly || previous == null || previous.getAvailabilityType() != AvailabilityType.DOWN) {
            Availability availability = this.inventoryManager.updateAvailability(resource, AvailabilityType.DOWN);
            availabilityReport.addAvailability(availability);
        }
        HashSet children = new HashSet(resource.getChildResources());
        for (Resource child : children) {
            this.markDown(child, availabilityReport, changesOnly);
        }
    }

    void sendFullReportNextTime() {
        this.sendChangedOnlyReport.set(false);
    }

    void sendChangedOnlyReportNextTime() {
        this.sendChangedOnlyReport.set(true);
    }
}

