/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.management;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.EnumMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.plugins.types.MutableCompositeMetaType;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.resource.metadata.mcf.ApplicationManagedSecurityMetaData;
import org.jboss.resource.metadata.mcf.SecurityDeploymentType;
import org.jboss.resource.metadata.mcf.SecurityDomainApplicationManagedMetaData;
import org.jboss.resource.metadata.mcf.SecurityDomainMetaData;
import org.jboss.resource.metadata.mcf.SecurityMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityDomainMetaMapper
extends MetaMapper<SecurityMetaData> {
    private static final String DOMAIN = "domain";
    private static final String DeploymentTypeName = "securityDeploymentType";
    private static final MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    private static final MutableCompositeMetaType metaType;

    public Type mapToType() {
        return SecurityMetaData.class;
    }

    public MetaType getMetaType() {
        return metaType;
    }

    public MetaValue createMetaValue(MetaType metaType, SecurityMetaData object) {
        if (object == null) {
            return null;
        }
        if (metaType instanceof CompositeMetaType) {
            CompositeMetaType composite = (CompositeMetaType)metaType;
            EnumMetaType enumMetaType = (EnumMetaType)composite.getType(DeploymentTypeName);
            CompositeValueSupport securityDomain = new CompositeValueSupport(composite);
            SecurityDeploymentType deploymentType = object.getSecurityDeploymentType();
            if (deploymentType == null) {
                deploymentType = SecurityDeploymentType.NONE;
            }
            securityDomain.set(DOMAIN, (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)object.getDomain())));
            securityDomain.set(DeploymentTypeName, (MetaValue)new EnumValueSupport(enumMetaType, (Enum)deploymentType));
            return securityDomain;
        }
        throw new IllegalArgumentException("Cannot convert securityDomain " + object);
    }

    public SecurityMetaData unwrapMetaValue(MetaValue metaValue) {
        if (metaValue == null) {
            return null;
        }
        if (metaValue instanceof CompositeValue) {
            CompositeValue compositeValue = (CompositeValue)metaValue;
            String domainName = (String)metaValueFactory.unwrap(compositeValue.get(DOMAIN));
            SecurityDeploymentType deploymentType = (SecurityDeploymentType)metaValueFactory.unwrap(compositeValue.get(DeploymentTypeName));
            if (deploymentType == null) {
                deploymentType = SecurityDeploymentType.NONE;
            }
            ApplicationManagedSecurityMetaData securityDomain = null;
            switch (deploymentType) {
                case APPLICATION: {
                    securityDomain = new ApplicationManagedSecurityMetaData();
                    break;
                }
                case DOMAIN: {
                    securityDomain = new SecurityDomainMetaData();
                    break;
                }
                case DOMAIN_AND_APPLICATION: {
                    securityDomain = new SecurityDomainApplicationManagedMetaData();
                    break;
                }
                default: {
                    securityDomain = new SecurityMetaData();
                }
            }
            if (securityDomain.requiresDomain() && domainName == null) {
                throw new IllegalStateException("null security domain not allowed for SecurityDeploymentType " + deploymentType);
            }
            securityDomain.setDomain(domainName);
            return securityDomain;
        }
        throw new IllegalStateException("Unable to unwrap securityDomain " + metaValue);
    }

    static {
        EnumMetaType enumMetaType = new EnumMetaType((Enum[])SecurityDeploymentType.values());
        metaType = new MutableCompositeMetaType(SecurityMetaData.class.getName(), "The security domain meta data");
        metaType.addItem(DOMAIN, "the security domain", (MetaType)SimpleMetaType.STRING);
        metaType.addItem(DeploymentTypeName, "the security deployment type", (MetaType)enumMetaType);
        metaType.freeze();
    }
}

