/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public abstract class FileUtils {
    public static void purge(File fileOrDir, boolean deleteIt) throws IOException {
        if (fileOrDir != null) {
            File[] doomedFiles;
            if (fileOrDir.isDirectory() && (doomedFiles = fileOrDir.listFiles()) != null) {
                for (File doomedFile : doomedFiles) {
                    FileUtils.purge(doomedFile, true);
                }
            }
            if (deleteIt) {
                if (!fileOrDir.delete()) {
                    throw new IOException("Failed to delete file or directory: " + fileOrDir);
                }
            } else if (fileOrDir.isDirectory() && fileOrDir.list().length != 0) {
                throw new IOException("Failed to delete contents of directory: " + fileOrDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findString(String filePath, String stringToFind) throws IOException {
        StringBuilder result = null;
        BufferedReader in = new BufferedReader(new FileReader(filePath));
        try {
            int numread;
            char[] data = new char[8096];
            int toFindIndex = 0;
            char lastchar = 'a';
            while ((numread = in.read(data, 0, 8096)) != -1) {
                for (int i = 0; i < numread; ++i) {
                    if (toFindIndex >= stringToFind.length() || data[i] == stringToFind.charAt(toFindIndex)) {
                        if (result == null) {
                            result = new StringBuilder();
                        }
                        if (Character.isISOControl(data[i])) {
                            String string = result.toString();
                            return string;
                        }
                        result.append(data[i]);
                        ++toFindIndex;
                    } else if (toFindIndex > 0) {
                        if (data[i] != lastchar) {
                            result = null;
                            toFindIndex = 0;
                            continue;
                        }
                        --toFindIndex;
                        --i;
                        result.deleteCharAt(result.length() - 1);
                        continue;
                    }
                    lastchar = data[i];
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public static String getCanonicalPath(String path) {
        File file = new File(path);
        if (FileUtils.isUnix()) {
            file = new File(file.toURI().normalize()).getAbsoluteFile();
        } else {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                file = new File(file.toURI().normalize()).getAbsoluteFile();
            }
        }
        return file.getPath();
    }

    private FileUtils() {
    }

    private static boolean isUnix() {
        return File.separatorChar == '/';
    }
}

