/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security.jaspi.modules;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.security.jaspi.modules.TomcatServerAuthModule;

public class HTTPFormServerAuthModule
extends TomcatServerAuthModule {
    private static Logger log = Logger.getLogger(HTTPFormServerAuthModule.class);
    protected Context context;
    protected boolean cache = false;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.authenticator");
    protected static final int SESSION_ID_BYTES = 16;
    protected String delgatingLoginContextName = null;

    public HTTPFormServerAuthModule() {
    }

    public HTTPFormServerAuthModule(String delgatingLoginContextName) {
        this.delgatingLoginContextName = delgatingLoginContextName;
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        throw new RuntimeException("Not Applicable");
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        boolean loginAction;
        Principal principal;
        Request request = (Request)messageInfo.getRequestMessage();
        Response response = (Response)messageInfo.getResponseMessage();
        this.context = request.getContext();
        LoginConfig config = this.context.getLoginConfig();
        Session session = null;
        this.cache = (Boolean)messageInfo.getMap().get("CACHE");
        if (!this.cache) {
            session = request.getSessionInternal(true);
            log.debug((Object)("Checking for reauthenticate in session " + session));
            String username = (String)session.getNote("org.apache.catalina.session.USERNAME");
            String password = (String)session.getNote("org.apache.catalina.session.PASSWORD");
            if (username != null && password != null) {
                log.debug((Object)("Reauthenticating username '" + username + "'"));
                principal = this.context.getRealm().authenticate(username, password);
                if (principal != null) {
                    session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)principal);
                    if (!this.matchRequest(request)) {
                        this.registerWithCallbackHandler(principal, username, password);
                        return AuthStatus.SUCCESS;
                    }
                }
                log.trace((Object)"Reauthentication failed, proceed normally");
            }
        }
        if (this.matchRequest(request)) {
            session = request.getSessionInternal(true);
            log.trace((Object)("Restore request from session '" + session.getIdInternal() + "'"));
            principal = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
            this.registerWithCallbackHandler(principal, (String)session.getNote("org.apache.catalina.session.USERNAME"), (String)session.getNote("org.apache.catalina.session.PASSWORD"));
            if (this.cache) {
                session.removeNote("org.apache.catalina.session.USERNAME");
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
            if (this.restoreRequest(request, session)) {
                log.trace((Object)"Proceed to restored request");
                return AuthStatus.SUCCESS;
            }
            log.trace((Object)"Restore of original request failed");
            try {
                response.sendError(400);
            }
            catch (IOException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return AuthStatus.FAILURE;
        }
        MessageBytes uriMB = MessageBytes.newInstance();
        CharChunk uriCC = uriMB.getCharChunk();
        uriCC.setLimit(-1);
        String contextPath = request.getContextPath();
        String requestURI = request.getDecodedRequestURI();
        response.setContext(request.getContext());
        boolean bl = loginAction = requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
        if (!loginAction) {
            session = request.getSessionInternal(true);
            log.trace((Object)("Save request in session '" + session.getIdInternal() + "'"));
            try {
                this.saveRequest(request, session);
            }
            catch (IOException ioe) {
                log.trace((Object)"Request body too big to save during authentication");
                try {
                    response.sendError(403, sm.getString("authenticator.requestBodyTooBig"));
                }
                catch (IOException e) {
                    log.error((Object)"Exception in Form authentication:", (Throwable)e);
                    throw new AuthException(e.getLocalizedMessage());
                }
                return AuthStatus.FAILURE;
            }
            this.forwardToLoginPage(request, response, config);
            return AuthStatus.SEND_CONTINUE;
        }
        Realm realm = this.context.getRealm();
        String characterEncoding = request.getCharacterEncoding();
        if (characterEncoding != null) {
            try {
                request.setCharacterEncoding(characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        log.trace((Object)("Authenticating username '" + username + "'"));
        principal = realm.authenticate(username, password);
        if (principal == null) {
            this.forwardToErrorPage(request, response, config);
            return AuthStatus.FAILURE;
        }
        log.trace((Object)("Authentication of '" + username + "' was successful"));
        if (session == null) {
            session = request.getSessionInternal(false);
        }
        if (session == null) {
            log.trace((Object)"User took so long to log on the session expired");
            try {
                response.sendError(408, sm.getString("authenticator.sessionExpired"));
            }
            catch (IOException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return AuthStatus.FAILURE;
        }
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)principal);
        session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
        session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
        requestURI = this.savedRequestURL(session);
        log.trace((Object)("Redirecting to original '" + requestURI + "'"));
        try {
            if (requestURI == null) {
                response.sendError(400, sm.getString("authenticator.formlogin"));
            } else {
                response.sendRedirect(response.encodeRedirectURL(requestURI));
            }
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getLocalizedMessage(), (Throwable)ioe);
        }
        return AuthStatus.FAILURE;
    }

    protected boolean matchRequest(Request request) {
        Session session = request.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        SavedRequest sreq = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (sreq == null) {
            return false;
        }
        if (session.getNote("org.apache.catalina.authenticator.PRINCIPAL") == null) {
            return false;
        }
        String requestURI = request.getRequestURI();
        if (requestURI == null) {
            return false;
        }
        return requestURI.equals(sreq.getRequestURI());
    }

    protected boolean restoreRequest(Request request, Session session) {
        ByteChunk body;
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.PRINCIPAL");
        if (saved == null) {
            return false;
        }
        request.clearCookies();
        Iterator cookies = saved.getCookies();
        while (cookies.hasNext()) {
            request.addCookie((Cookie)cookies.next());
        }
        MimeHeaders rmh = request.getCoyoteRequest().getMimeHeaders();
        rmh.recycle();
        boolean cachable = "GET".equalsIgnoreCase(saved.getMethod()) || "HEAD".equalsIgnoreCase(saved.getMethod());
        Iterator names = saved.getHeaderNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            if ("If-Modified-Since".equalsIgnoreCase(name) || cachable && "If-None-Match".equalsIgnoreCase(name)) continue;
            Iterator values = saved.getHeaderValues(name);
            while (values.hasNext()) {
                rmh.addValue(name).setString((String)values.next());
            }
        }
        request.clearLocales();
        Iterator locales = saved.getLocales();
        while (locales.hasNext()) {
            request.addLocale((Locale)locales.next());
        }
        request.getCoyoteRequest().getParameters().recycle();
        if ("POST".equalsIgnoreCase(saved.getMethod()) && (body = saved.getBody()) != null) {
            request.getCoyoteRequest().action(ActionCode.ACTION_REQ_SET_BODY_REPLAY, (Object)body);
            MessageBytes contentType = MessageBytes.newInstance();
            String savedContentType = saved.getContentType();
            if (savedContentType == null) {
                savedContentType = "application/x-www-form-urlencoded";
            }
            contentType.setString(savedContentType);
            request.getCoyoteRequest().setContentType(contentType);
        }
        request.getCoyoteRequest().method().setString(saved.getMethod());
        request.getCoyoteRequest().queryString().setString(saved.getQueryString());
        request.getCoyoteRequest().requestURI().setString(saved.getRequestURI());
        return true;
    }

    protected void saveRequest(Request request, Session session) throws IOException {
        SavedRequest saved = new SavedRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                saved.addCookie(cookies[i]);
            }
        }
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                saved.addHeader(name, value);
            }
        }
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            saved.addLocale(locale);
        }
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            int bytesRead;
            ByteChunk body = new ByteChunk();
            body.setLimit(request.getConnector().getMaxSavePostSize());
            byte[] buffer = new byte[4096];
            ServletInputStream is = request.getInputStream();
            while ((bytesRead = is.read(buffer)) >= 0) {
                body.append(buffer, 0, bytesRead);
            }
            saved.setBody(body);
            saved.setContentType(request.getContentType());
        }
        saved.setMethod(request.getMethod());
        saved.setQueryString(request.getQueryString());
        saved.setRequestURI(request.getRequestURI());
        session.setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
    }

    protected String savedRequestURL(Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (saved == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(saved.getRequestURI());
        if (saved.getQueryString() != null) {
            sb.append('?');
            sb.append(saved.getQueryString());
        }
        return sb.toString();
    }

    protected void forwardToLoginPage(Request request, Response response, LoginConfig config) {
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(config.getLoginPage());
        try {
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
            response.finishResponse();
        }
        catch (Throwable t) {
            log.warn((Object)"Unexpected error forwarding to login page", t);
        }
    }

    protected void forwardToErrorPage(Request request, Response response, LoginConfig config) {
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(config.getErrorPage());
        try {
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
        }
        catch (Throwable t) {
            log.warn((Object)"Unexpected error forwarding to error page", t);
        }
    }
}

