/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import org.jboss.xnio.AbstractConvertingIoFuture;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.channels.AllocatedMessageChannel;
import org.jboss.xnio.channels.AllocatedMessageChannelStreamChannelHandler;
import org.jboss.xnio.channels.ReadableMessageChannel;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.StreamChannelAllocatedMessageChannelHandler;
import org.jboss.xnio.channels.SuspendableChannel;
import org.jboss.xnio.channels.SuspendableReadChannel;
import org.jboss.xnio.channels.SuspendableWriteChannel;
import org.jboss.xnio.channels.WritableMessageChannel;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Channels {
    private static final Logger mergedLog = Logger.getLogger("org.jboss.xnio.channels.merged");

    private Channels() {
    }

    public static ChannelSource<AllocatedMessageChannel> convertStreamToAllocatedMessage(final ChannelSource<? extends StreamChannel> streamChannelSource, final int maxInboundMessageSize, final int maxOutboundMessageSize) {
        return new ChannelSource<AllocatedMessageChannel>(){

            @Override
            public IoFuture<AllocatedMessageChannel> open(IoHandler<? super AllocatedMessageChannel> handler) {
                final AllocatedMessageChannelStreamChannelHandler innerHandler = new AllocatedMessageChannelStreamChannelHandler(handler, maxInboundMessageSize, maxOutboundMessageSize);
                return new AbstractConvertingIoFuture<AllocatedMessageChannel, StreamChannel>(streamChannelSource.open(innerHandler)){

                    @Override
                    protected AllocatedMessageChannel convert(StreamChannel arg) {
                        return innerHandler.getChannel(arg);
                    }
                };
            }
        };
    }

    public static IoHandlerFactory<StreamChannel> convertStreamToAllocatedMessage(final IoHandlerFactory<? super AllocatedMessageChannel> handlerFactory, final int maxInboundMessageSize, final int maxOutboundMessageSize) {
        return new IoHandlerFactory<StreamChannel>(){

            @Override
            public IoHandler<? super StreamChannel> createHandler() {
                return new AllocatedMessageChannelStreamChannelHandler(handlerFactory.createHandler(), maxInboundMessageSize, maxOutboundMessageSize);
            }
        };
    }

    public static ChannelSource<StreamChannel> convertAllocatedMessageToStream(final ChannelSource<? extends AllocatedMessageChannel> messageChannelSource) {
        return new ChannelSource<StreamChannel>(){

            @Override
            public IoFuture<StreamChannel> open(IoHandler<? super StreamChannel> handler) {
                final StreamChannelAllocatedMessageChannelHandler innerHandler = new StreamChannelAllocatedMessageChannelHandler(handler);
                return new AbstractConvertingIoFuture<StreamChannel, AllocatedMessageChannel>(messageChannelSource.open(innerHandler)){

                    @Override
                    protected StreamChannel convert(AllocatedMessageChannel arg) throws IOException {
                        return innerHandler.getChannel(arg);
                    }
                };
            }
        };
    }

    public static IoHandlerFactory<AllocatedMessageChannel> convertAllocatedMessageToStream(final IoHandlerFactory<? super StreamChannel> handlerFactory) {
        return new IoHandlerFactory<AllocatedMessageChannel>(){

            @Override
            public IoHandler<? super AllocatedMessageChannel> createHandler() {
                return new StreamChannelAllocatedMessageChannelHandler(handlerFactory.createHandler());
            }
        };
    }

    public static <T extends SuspendableChannel> IoHandler<T> createMergedHandler(final IoHandler<? super T> readSide, final IoHandler<? super T> writeSide) {
        return new IoHandler<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleOpened(T channel) {
                readSide.handleOpened(channel);
                boolean ok = false;
                try {
                    writeSide.handleOpened(channel);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        try {
                            readSide.handleClosed(channel);
                        }
                        catch (Throwable t) {
                            mergedLog.error(t, "Error in close handler", new Object[0]);
                        }
                    }
                }
            }

            @Override
            public void handleReadable(T channel) {
                readSide.handleReadable(channel);
            }

            @Override
            public void handleWritable(T channel) {
                writeSide.handleReadable(channel);
            }

            @Override
            public void handleClosed(T channel) {
                try {
                    readSide.handleClosed(channel);
                }
                catch (Throwable t) {
                    mergedLog.error(t, "Error in close handler", new Object[0]);
                }
                try {
                    writeSide.handleClosed(channel);
                }
                catch (Throwable t) {
                    mergedLog.error(t, "Error in close handler", new Object[0]);
                }
            }
        };
    }

    public static <T extends SuspendableChannel> IoHandlerFactory<T> createMergedHandlerFactory(final IoHandlerFactory<? super T> readFactory, final IoHandlerFactory<? super T> writeFactory) {
        return new IoHandlerFactory<T>(){

            @Override
            public IoHandler<T> createHandler() {
                return Channels.createMergedHandler(readFactory.createHandler(), writeFactory.createHandler());
            }
        };
    }

    public static <C extends WritableByteChannel & SuspendableWriteChannel> int writeBlocking(C channel, ByteBuffer buffer) throws IOException {
        int res;
        while ((res = channel.write(buffer)) == 0) {
            ((SuspendableWriteChannel)channel).awaitWritable();
        }
        return res;
    }

    public static <C extends WritableByteChannel & SuspendableWriteChannel> int writeBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        int res = channel.write(buffer);
        if (res == 0) {
            ((SuspendableWriteChannel)channel).awaitWritable(time, unit);
            return channel.write(buffer);
        }
        return res;
    }

    public static <C extends GatheringByteChannel & SuspendableWriteChannel> long writeBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long res;
        while ((res = channel.write(buffers, offs, len)) == 0L) {
            ((SuspendableWriteChannel)channel).awaitWritable();
        }
        return res;
    }

    public static <C extends GatheringByteChannel & SuspendableWriteChannel> long writeBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long res = channel.write(buffers, offs, len);
        if (res == 0L) {
            ((SuspendableWriteChannel)channel).awaitWritable(time, unit);
            return channel.write(buffers, offs, len);
        }
        return res;
    }

    public static <C extends WritableMessageChannel & SuspendableWriteChannel> void sendBlocking(C channel, ByteBuffer buffer) throws IOException {
        while (!channel.send(buffer)) {
            channel.awaitWritable();
        }
    }

    public static <C extends WritableMessageChannel & SuspendableWriteChannel> boolean sendBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        if (!channel.send(buffer)) {
            channel.awaitWritable(time, unit);
            return channel.send(buffer);
        }
        return true;
    }

    public static <C extends WritableMessageChannel & SuspendableWriteChannel> void sendBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        while (!channel.send(buffers, offs, len)) {
            channel.awaitWritable();
        }
    }

    public static <C extends WritableMessageChannel & SuspendableWriteChannel> boolean sendBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        if (!channel.send(buffers, offs, len)) {
            channel.awaitWritable(time, unit);
            return channel.send(buffers, offs, len);
        }
        return true;
    }

    public static <C extends ReadableByteChannel & SuspendableReadChannel> int readBlocking(C channel, ByteBuffer buffer) throws IOException {
        int res;
        while ((res = channel.read(buffer)) == 0) {
            ((SuspendableReadChannel)channel).awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableByteChannel & SuspendableReadChannel> int readBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        int res = channel.read(buffer);
        if (res == 0) {
            ((SuspendableReadChannel)channel).awaitReadable(time, unit);
            return channel.read(buffer);
        }
        return res;
    }

    public static <C extends ScatteringByteChannel & SuspendableReadChannel> long readBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long res;
        while ((res = channel.read(buffers, offs, len)) == 0L) {
            ((SuspendableReadChannel)channel).awaitReadable();
        }
        return res;
    }

    public static <C extends ScatteringByteChannel & SuspendableReadChannel> long readBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long res = channel.read(buffers, offs, len);
        if (res == 0L) {
            ((SuspendableReadChannel)channel).awaitReadable(time, unit);
            return channel.read(buffers, offs, len);
        }
        return res;
    }

    public static <C extends ReadableMessageChannel & SuspendableReadChannel> int receiveBlocking(C channel, ByteBuffer buffer) throws IOException {
        int res;
        while ((res = channel.receive(buffer)) == 0) {
            channel.awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableMessageChannel & SuspendableReadChannel> int receiveBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        int res = channel.receive(buffer);
        if (res == 0) {
            channel.awaitReadable(time, unit);
            return channel.receive(buffer);
        }
        return res;
    }

    public static <C extends ReadableMessageChannel & SuspendableReadChannel> long receiveBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long res;
        while ((res = channel.receive(buffers, offs, len)) == 0L) {
            channel.awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableMessageChannel & SuspendableReadChannel> long receiveBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long res = channel.receive(buffers, offs, len);
        if (res == 0L) {
            channel.awaitReadable(time, unit);
            return channel.receive(buffers, offs, len);
        }
        return res;
    }
}

