/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.util.xml.JBossEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RootElementBuilder {
    private static final JBossEntityResolver resolver = new JBossEntityResolver();
    public static final String JBOSSCACHE_CORE_NS_31 = "urn:jboss:jbosscache-core:config:3.1";
    public static final String JBOSSCACHE_REPO_NS_31 = "urn:jboss:jbosscache-core:cache-repo:3.1";
    public static final String JBOSSCACHE_CORE_NS_30 = "urn:jboss:jbosscache-core:config:3.0";
    public static final String JBOSSCACHE_REPO_NS_30 = "urn:jboss:jbosscache-core:cache-repo:3.0";
    private static final Log log;
    private ErrorHandler errorHandler;
    private boolean isValidating;
    public static final String VALIDATING_SYSTEM_PROPERTY = "jbosscache.config.validate";

    public RootElementBuilder(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.isValidating = System.getProperty(VALIDATING_SYSTEM_PROPERTY) == null || Boolean.getBoolean(VALIDATING_SYSTEM_PROPERTY);
    }

    public RootElementBuilder(ErrorHandler errorHandler, boolean validating) {
        this.errorHandler = errorHandler;
        this.isValidating = validating;
    }

    public RootElementBuilder() {
        this(new FailureErrorHandler());
    }

    public RootElementBuilder(boolean validating) {
        this(new FailureErrorHandler(), validating);
    }

    public Element readRoot(InputStream config) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            if (this.isValidating) {
                docBuilderFactory.setValidating(true);
                docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", new String[]{JBOSSCACHE_CORE_NS_30, JBOSSCACHE_CORE_NS_31, JBOSSCACHE_REPO_NS_30, JBOSSCACHE_REPO_NS_31});
            }
            DocumentBuilder parser = docBuilderFactory.newDocumentBuilder();
            parser.setEntityResolver((EntityResolver)resolver);
            parser.setErrorHandler(this.errorHandler);
            Document doc = parser.parse(config);
            Element root = doc.getDocumentElement();
            root.normalize();
            return root;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not parse the config file", e);
        }
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    static {
        JBossEntityResolver.registerEntity((String)JBOSSCACHE_CORE_NS_31, (String)"jbosscache-config-3.1.xsd");
        JBossEntityResolver.registerEntity((String)JBOSSCACHE_REPO_NS_31, (String)"jbosscache-registry-3.1.xsd");
        JBossEntityResolver.registerEntity((String)JBOSSCACHE_CORE_NS_30, (String)"jbosscache-config-3.0.xsd");
        JBossEntityResolver.registerEntity((String)JBOSSCACHE_REPO_NS_30, (String)"jbosscache-registry-3.0.xsd");
        log = LogFactory.getLog(RootElementBuilder.class);
    }

    private static class FailureErrorHandler
    implements ErrorHandler {
        private FailureErrorHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.logAndThrowException(exception);
        }

        public void error(SAXParseException exception) throws SAXException {
            this.logAndThrowException(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.logAndThrowException(exception);
        }

        private void logAndThrowException(SAXParseException exception) {
            log.error((Object)("Configuration warning: " + exception.getMessage()));
            throw new ConfigurationException("Incorrect configuration file. Use '-Djbosscache.config.validate=false' to disable validation.", exception);
        }
    }
}

