/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.TimeUnit;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.EvictionPolicyConfigBase;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.eviction.ModernizableConfig;

@Deprecated
public class LRUConfiguration
extends EvictionPolicyConfigBase
implements ModernizableConfig {
    private static final long serialVersionUID = -3426716488271559729L;
    @Dynamic
    private int timeToLiveSeconds;
    @Dynamic
    private int maxAgeSeconds;

    public LRUConfiguration() {
        this.setTimeToLiveSeconds(-1);
    }

    public EvictionAlgorithmConfig modernizeConfig() {
        LRUAlgorithmConfig modernCfg = new LRUAlgorithmConfig();
        modernCfg.setMaxNodes(this.getMaxNodes());
        modernCfg.setMinTimeToLive(this.getMinTimeToLiveSeconds(), TimeUnit.SECONDS);
        modernCfg.setTimeToLive(this.getTimeToLiveSeconds(), TimeUnit.SECONDS);
        modernCfg.setMaxAge(this.getMaxAgeSeconds(), TimeUnit.SECONDS);
        return modernCfg;
    }

    protected void setEvictionPolicyClassName() {
        this.setEvictionPolicyClass(LRUPolicy.class.getName());
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public void setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.testImmutability("timeToLiveSeconds");
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public int getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public void setMaxAgeSeconds(int maxAgeSeconds) {
        this.testImmutability("maxAgeSeconds");
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public void validate() throws ConfigurationException {
        if (this.timeToLiveSeconds < 0) {
            throw new ConfigurationException("timeToLive must be configured to a value greater than or equal to 0 for " + this.getEvictionPolicyClass());
        }
    }

    public String toString() {
        return "LRUConfiguration{timeToLiveSeconds=" + this.timeToLiveSeconds + ", timeToLiveSeconds=" + this.timeToLiveSeconds + ", maxAgeSeconds=" + this.maxAgeSeconds + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LRUConfiguration)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LRUConfiguration that = (LRUConfiguration)o;
        if (this.maxAgeSeconds != that.maxAgeSeconds) {
            return false;
        }
        if (this.maxAgeSeconds != that.maxAgeSeconds) {
            return false;
        }
        if (this.timeToLiveSeconds != that.timeToLiveSeconds) {
            return false;
        }
        return this.timeToLiveSeconds == that.timeToLiveSeconds;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.timeToLiveSeconds;
        result = 31 * result + this.maxAgeSeconds;
        result = 31 * result + (this.timeToLiveSeconds ^ this.timeToLiveSeconds >>> 7);
        result = 31 * result + (this.maxAgeSeconds ^ this.maxAgeSeconds >>> 7);
        return result;
    }

    public void reset() {
        super.reset();
        this.setTimeToLiveSeconds(-1);
    }

    public LRUConfiguration clone() throws CloneNotSupportedException {
        return (LRUConfiguration)super.clone();
    }
}

