/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.deployers.plugins.sort.Domino;
import org.jboss.deployers.plugins.sort.Dots;
import org.jboss.deployers.spi.Ordered;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DominoOrdering<T extends Domino<?>> {
    protected String message;
    protected List<T> dominoes;
    protected int size;
    protected int[][] connections;

    public DominoOrdering(String message) {
        this.message = message;
    }

    protected void init(List<T> dominoes, Object cause) {
        this.dominoes = dominoes;
        this.size = dominoes.size();
        this.connections = new int[this.size][this.size];
        for (int i = 0; i < this.size - 1; ++i) {
            for (int j = i + 1; j < this.size; ++j) {
                Domino one = (Domino)dominoes.get(i);
                Domino two = (Domino)dominoes.get(j);
                Dots oneHead = one.getHead();
                Dots oneTail = one.getTail();
                Dots twoHead = two.getHead();
                Dots twoTail = two.getTail();
                boolean fstXsnd = oneTail.match(twoHead);
                boolean sndXfst = twoTail.match(oneHead);
                int relation = 0;
                if (fstXsnd && sndXfst) {
                    if (one.getHead().match(twoHead) && oneTail.match(twoTail)) {
                        relation = Ordered.COMPARATOR.compare(one, two);
                    } else {
                        this.throwCycleException(cause);
                    }
                } else {
                    int n = fstXsnd ? -1 : (relation = sndXfst ? 1 : 0);
                }
                if (relation == 0 && one.getRelativeOrder() != 0 && two.getRelativeOrder() != 0) {
                    relation = one.getRelativeOrder() - two.getRelativeOrder();
                }
                this.connections[i][j] = relation;
                this.connections[j][i] = -this.connections[i][j];
            }
        }
    }

    public List<T> orderDominoes(List<T> dominoes, Object cause) {
        this.init(dominoes, cause);
        int cycle = this.fillTransitions(true);
        if (cycle >= 0) {
            this.throwCycleException(cause);
        }
        this.fillCompareNames();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.size; ++i) {
            indexes.add(i);
        }
        Collections.sort(indexes, new IndexComparator());
        ArrayList<T> list = new ArrayList<T>(this.size);
        for (Integer index : indexes) {
            list.add(dominoes.get(index));
        }
        return list;
    }

    protected int fillTransitions(boolean fillTransitions) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    int current = this.connections[i][j];
                    if (j == i || current == 0) continue;
                    for (int k = 0; k < this.size; ++k) {
                        int lookup;
                        if (k == i || k == j || current * (lookup = this.connections[j][k]) <= 0) continue;
                        int next = this.connections[i][k];
                        if (next * current < 0) {
                            return i;
                        }
                        if (!fillTransitions || next != 0) continue;
                        this.connections[i][k] = current;
                        changed = true;
                    }
                }
            }
        }
        return -1;
    }

    protected void fillCompareNames() {
        for (int i = 0; i < this.size - 1; ++i) {
            for (int j = i + 1; j < this.size; ++j) {
                if (this.connections[i][j] != 0) continue;
                Domino one = (Domino)this.dominoes.get(i);
                Domino two = (Domino)this.dominoes.get(j);
                this.connections[i][j] = Ordered.COMPARATOR.compare(one, two);
                this.connections[j][i] = -this.connections[i][j];
                int cycle = this.fillTransitions(false);
                if (cycle < 0) continue;
                this.connections[i][j] = -this.connections[i][j];
                this.connections[j][i] = -this.connections[i][j];
            }
        }
    }

    protected void throwCycleException(Object cause) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(this.message, cause));
        for (Domino d : this.dominoes) {
            builder.append(d.getInfo());
        }
        throw new IllegalStateException(builder.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IndexComparator
    implements Comparator<Integer> {
        protected IndexComparator() {
        }

        @Override
        public int compare(Integer i1, Integer i2) {
            return DominoOrdering.this.connections[i1][i2];
        }
    }
}

