/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.dbc.condition;

import bsh.EvalError;
import bsh.Interpreter;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.dbc.DesignByContractAspect;
import org.jboss.aspects.dbc.condition.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvariantCondition
extends Condition {
    public InvariantCondition(Class<?> clazz, String condExpr, boolean isStatic) {
        super(condExpr, clazz, isStatic);
    }

    public void evaluateCondition(Invocation inv, boolean staticCall, boolean constructor, Object ret) {
        try {
            if (DesignByContractAspect.verbose) {
                System.out.println("[dbc] Evaluate condition : '" + this.originalExpr + "' for class: " + this.clazz);
            }
            if (!this.isStatic && staticCall) {
                System.out.println("[dbc] Ignoring non-static invariant for static call");
                return;
            }
            Interpreter interpreter = new Interpreter();
            Object target = constructor ? ret : this.getTarget(inv, staticCall);
            for (String bsname : this.parameterLookup.keySet()) {
                String originalname = (String)this.parameterLookup.get(bsname);
                if (originalname.equals("tgt")) {
                    interpreter.set(bsname, target);
                    if (!DesignByContractAspect.verbose) continue;
                    System.out.println("[dbc] Setting $" + originalname + " to " + target + " (type: " + target.getClass().getName() + ")");
                    continue;
                }
                System.out.println("INVARIANT CONDITION BROKEN: " + this.originalExpr + " - " + this.clazz);
                throw new RuntimeException("Invalid marker '" + originalname + "' in expression: " + this.originalExpr);
            }
            Boolean eval = (Boolean)interpreter.eval(this.condExpr);
            if (!eval.booleanValue()) {
                throw new RuntimeException("Invariant condition " + this.originalExpr + " was broken " + "for class: " + this.clazz);
            }
        }
        catch (EvalError e) {
            throw new RuntimeException("There was an error in the expression: " + this.originalExpr, e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof InvariantCondition) {
            return super.equals(o);
        }
        return false;
    }
}

