/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SysPropertyActions {
    SysPropertyActions() {
    }

    public static String getProperty(String name, String defaultValue) {
        String prop = System.getSecurityManager() == null ? SysProps.NON_PRIVILEGED.getProperty(name, defaultValue) : SysProps.PRIVILEGED.getProperty(name, defaultValue);
        return prop;
    }

    public static String setProperty(String name, String value) {
        String prop = System.getSecurityManager() == null ? SysProps.NON_PRIVILEGED.setProperty(name, value) : SysProps.PRIVILEGED.setProperty(name, value);
        return prop;
    }

    static interface SysProps {
        public static final SysProps NON_PRIVILEGED = new SysProps(){

            public String getProperty(String name, String defaultValue) {
                return System.getProperty(name, defaultValue);
            }

            public String setProperty(String name, String value) {
                return System.setProperty(name, value);
            }
        };
        public static final SysProps PRIVILEGED = new SysProps(){

            public String getProperty(final String name, final String defaultValue) {
                PrivilegedAction<String> action = new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(name, defaultValue);
                    }
                };
                return AccessController.doPrivileged(action);
            }

            public String setProperty(final String name, final String value) {
                PrivilegedAction<String> action = new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.setProperty(name, value);
                    }
                };
                return AccessController.doPrivileged(action);
            }
        };

        public String getProperty(String var1, String var2);

        public String setProperty(String var1, String var2);
    }
}

