/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.jsf.integration.injection;

import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.jboss.logging.Logger;

public class JBossInjectionProvider
implements InjectionProvider {
    private static final Logger LOG = Logger.getLogger(JBossInjectionProvider.class);
    private static final String NAMING_DISABLED = "Injection of naming resources into JSF managed beans disabled.";
    private Context namingContext;

    public JBossInjectionProvider() {
        try {
            this.namingContext = new InitialContext();
        }
        catch (Exception e) {
            LOG.warn((Object)NAMING_DISABLED, (Throwable)e);
        }
    }

    protected JBossInjectionProvider(Context namingContext) {
        if (namingContext == null) {
            LOG.warn((Object)NAMING_DISABLED);
        }
        this.namingContext = namingContext;
    }

    public void invokePreDestroy(Object managedBean) throws InjectionProviderException {
        try {
            Method[] methods = managedBean.getClass().getDeclaredMethods();
            AccessibleObject preDestroy = null;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].isAnnotationPresent(PreDestroy.class)) continue;
                if (preDestroy != null || methods[i].getParameterTypes().length != 0 || Modifier.isStatic(methods[i].getModifiers()) || methods[i].getExceptionTypes().length > 0 || !methods[i].getReturnType().getName().equals("void")) {
                    throw new IllegalArgumentException("Invalid PreDestroy annotation");
                }
                preDestroy = methods[i];
            }
            if (preDestroy != null) {
                boolean accessibility = preDestroy.isAccessible();
                ((Method)preDestroy).setAccessible(true);
                ((Method)preDestroy).invoke(managedBean, new Object[0]);
                ((Method)preDestroy).setAccessible(accessibility);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"PreDestroy failed on managed bean.", (Throwable)e);
        }
    }

    public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        try {
            Method[] methods = managedBean.getClass().getDeclaredMethods();
            AccessibleObject postConstruct = null;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].isAnnotationPresent(PostConstruct.class)) continue;
                if (postConstruct != null || methods[i].getParameterTypes().length != 0 || Modifier.isStatic(methods[i].getModifiers()) || methods[i].getExceptionTypes().length > 0 || !methods[i].getReturnType().getName().equals("void")) {
                    throw new IllegalArgumentException("Invalid PostConstruct annotation");
                }
                postConstruct = methods[i];
            }
            if (postConstruct != null) {
                boolean accessibility = postConstruct.isAccessible();
                ((Method)postConstruct).setAccessible(true);
                ((Method)postConstruct).invoke(managedBean, new Object[0]);
                ((Method)postConstruct).setAccessible(accessibility);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"PostConstruct failed on managed bean.", (Throwable)e);
        }
    }

    public void inject(Object managedBean) throws InjectionProviderException {
        if (this.namingContext != null) {
            try {
                Field[] fields = managedBean.getClass().getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Resource annotation;
                    if (fields[i].isAnnotationPresent(Resource.class)) {
                        annotation = fields[i].getAnnotation(Resource.class);
                        JBossInjectionProvider.lookupFieldResource(this.namingContext, managedBean, fields[i], annotation.name());
                    }
                    if (fields[i].isAnnotationPresent(EJB.class)) {
                        annotation = fields[i].getAnnotation(EJB.class);
                        JBossInjectionProvider.lookupFieldResource(this.namingContext, managedBean, fields[i], annotation.name());
                    }
                    if (fields[i].isAnnotationPresent(WebServiceRef.class)) {
                        annotation = fields[i].getAnnotation(WebServiceRef.class);
                        JBossInjectionProvider.lookupFieldResource(this.namingContext, managedBean, fields[i], annotation.name());
                    }
                    if (fields[i].isAnnotationPresent(PersistenceContext.class)) {
                        annotation = fields[i].getAnnotation(PersistenceContext.class);
                        JBossInjectionProvider.lookupFieldResource(this.namingContext, managedBean, fields[i], annotation.name());
                    }
                    if (!fields[i].isAnnotationPresent(PersistenceUnit.class)) continue;
                    annotation = fields[i].getAnnotation(PersistenceUnit.class);
                    JBossInjectionProvider.lookupFieldResource(this.namingContext, managedBean, fields[i], annotation.name());
                }
                Method[] methods = managedBean.getClass().getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Resource annotation;
                    if (methods[i].isAnnotationPresent(Resource.class)) {
                        annotation = methods[i].getAnnotation(Resource.class);
                        JBossInjectionProvider.lookupMethodResource(this.namingContext, managedBean, methods[i], annotation.name());
                    }
                    if (methods[i].isAnnotationPresent(EJB.class)) {
                        annotation = methods[i].getAnnotation(EJB.class);
                        JBossInjectionProvider.lookupMethodResource(this.namingContext, managedBean, methods[i], annotation.name());
                    }
                    if (methods[i].isAnnotationPresent(WebServiceRef.class)) {
                        annotation = methods[i].getAnnotation(WebServiceRef.class);
                        JBossInjectionProvider.lookupMethodResource(this.namingContext, managedBean, methods[i], annotation.name());
                    }
                    if (methods[i].isAnnotationPresent(PersistenceContext.class)) {
                        annotation = methods[i].getAnnotation(PersistenceContext.class);
                        JBossInjectionProvider.lookupMethodResource(this.namingContext, managedBean, methods[i], annotation.name());
                    }
                    if (!methods[i].isAnnotationPresent(PersistenceUnit.class)) continue;
                    annotation = methods[i].getAnnotation(PersistenceUnit.class);
                    JBossInjectionProvider.lookupMethodResource(this.namingContext, managedBean, methods[i], annotation.name());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Injection failed on managed bean.", (Throwable)e);
            }
        }
    }

    protected static void lookupFieldResource(Context context, Object instance, Field field, String name) throws NamingException, IllegalAccessException {
        Object lookedupResource = null;
        boolean accessibility = false;
        lookedupResource = name != null && name.length() > 0 ? context.lookup(name) : context.lookup(instance.getClass().getName() + "/" + field.getName());
        accessibility = field.isAccessible();
        field.setAccessible(true);
        field.set(instance, lookedupResource);
        field.setAccessible(accessibility);
    }

    protected static void lookupMethodResource(Context context, Object instance, Method method, String name) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
            throw new IllegalArgumentException("Invalid method resource injection annotation");
        }
        Object lookedupResource = null;
        boolean accessibility = false;
        lookedupResource = name != null && name.length() > 0 ? context.lookup(name) : context.lookup(instance.getClass().getName() + "/" + method.getName().substring(3));
        accessibility = method.isAccessible();
        method.setAccessible(true);
        method.invoke(instance, lookedupResource);
        method.setAccessible(accessibility);
    }
}

