/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.UnsupportedFeatureException;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.render.RpcServiceLookup;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingGadgetRewriter
implements GadgetRewriter {
    private static final Logger LOG = Logger.getLogger(RenderingGadgetRewriter.class.getName());
    static final String DEFAULT_CSS = "body,td,div,span,p{font-family:arial,sans-serif;}a {color:#0000cc;}a:visited {color:#551a8b;}a:active {color:#ff0000;}body{margin: 0px;padding: 0px;background-color:white;}";
    static final String INSERT_BASE_ELEMENT_KEY = "gadgets.insertBaseElement";
    static final String FEATURES_KEY = "gadgets.features";
    private final MessageBundleFactory messageBundleFactory;
    private final ContainerConfig containerConfig;
    private final GadgetFeatureRegistry featureRegistry;
    private final UrlGenerator urlGenerator;
    private final RpcServiceLookup rpcServiceLookup;
    private Set<String> defaultForcedLibs = ImmutableSet.of();

    @Inject
    public RenderingGadgetRewriter(MessageBundleFactory messageBundleFactory, ContainerConfig containerConfig, GadgetFeatureRegistry featureRegistry, UrlGenerator urlGenerator, RpcServiceLookup rpcServiceLookup) {
        this.messageBundleFactory = messageBundleFactory;
        this.containerConfig = containerConfig;
        this.featureRegistry = featureRegistry;
        this.urlGenerator = urlGenerator;
        this.rpcServiceLookup = rpcServiceLookup;
    }

    @Inject
    public void setDefaultForcedLibs(@Named(value="shindig.gadget-rewrite.default-forced-libs") String forcedLibs) {
        if (forcedLibs != null && forcedLibs.length() > 0) {
            this.defaultForcedLibs = ImmutableSortedSet.copyOf(Arrays.asList(forcedLibs.split(":")));
        }
    }

    @Override
    public void rewrite(Gadget gadget, MutableContent mutableContent) {
        if (gadget.sanitizeOutput()) {
            return;
        }
        try {
            Document document = mutableContent.getDocument();
            Element head = (Element)DomUtil.getFirstNamedChildNode((Node)document.getDocumentElement(), (String)"head");
            NodeList children = head.getChildNodes();
            ArrayList existingHeadContent = Lists.newArrayListWithCapacity((int)children.getLength());
            for (int i = 0; i < children.getLength(); ++i) {
                existingHeadContent.add(children.item(i));
            }
            for (Node n : existingHeadContent) {
                head.removeChild(n);
            }
            if (document.getDoctype() == null) {
                Element defaultStyle = document.createElement("style");
                defaultStyle.setAttribute("type", "text/css");
                head.appendChild(defaultStyle);
                defaultStyle.appendChild(defaultStyle.getOwnerDocument().createTextNode(DEFAULT_CSS));
            }
            this.injectBaseTag(gadget, head);
            this.injectFeatureLibraries(gadget, head);
            Element mainScriptTag = document.createElement("script");
            this.injectMessageBundles(gadget, mainScriptTag);
            this.injectDefaultPrefs(gadget, mainScriptTag);
            this.injectPreloads(gadget, mainScriptTag);
            head.appendChild(mainScriptTag);
            Element body = (Element)DomUtil.getFirstNamedChildNode((Node)document.getDocumentElement(), (String)"body");
            LocaleSpec localeSpec = gadget.getLocale();
            if (localeSpec != null) {
                body.setAttribute("dir", localeSpec.getLanguageDirection());
            }
            for (Node node : existingHeadContent) {
                head.appendChild(node);
            }
            this.injectOnLoadHandlers(body);
            mutableContent.documentChanged();
        }
        catch (GadgetException e) {
            throw new RuntimeException(e);
        }
    }

    private void injectBaseTag(Gadget gadget, Node headTag) {
        GadgetContext context = gadget.getContext();
        if (this.containerConfig.getBool(context.getContainer(), INSERT_BASE_ELEMENT_KEY)) {
            Uri base = gadget.getSpec().getUrl();
            View view = gadget.getCurrentView();
            if (view != null && view.getHref() != null) {
                base = view.getHref();
            }
            Element baseTag = headTag.getOwnerDocument().createElement("base");
            baseTag.setAttribute("href", base.toString());
            headTag.insertBefore(baseTag, headTag.getFirstChild());
        }
    }

    private void injectOnLoadHandlers(Node bodyTag) {
        Element onloadScript = bodyTag.getOwnerDocument().createElement("script");
        bodyTag.appendChild(onloadScript);
        onloadScript.appendChild(bodyTag.getOwnerDocument().createTextNode("gadgets.util.runOnLoadHandlers();"));
    }

    private void injectFeatureLibraries(Gadget gadget, Node headTag) throws GadgetException {
        GadgetContext context = gadget.getContext();
        String forcedLibs = context.getParameter("libs");
        TreeSet forced = forcedLibs == null || forcedLibs.length() == 0 ? (this.defaultForcedLibs.isEmpty() ? this.defaultForcedLibs : Sets.newTreeSet(this.defaultForcedLibs)) : Sets.newTreeSet(Arrays.asList(forcedLibs.split(":")));
        if (!forced.isEmpty()) {
            String jsUrl = this.urlGenerator.getBundledJsUrl(forced, context);
            Element libsTag = headTag.getOwnerDocument().createElement("script");
            libsTag.setAttribute("src", jsUrl);
            headTag.appendChild(libsTag);
            for (GadgetFeature dep : this.featureRegistry.getFeatures(forced)) {
                forced.add(dep.getName());
            }
        }
        forced = ImmutableSet.copyOf((Iterable)forced);
        String container = context.getContainer();
        Collection<GadgetFeature> features = this.getFeatures(gadget, forced);
        int size = 0;
        for (GadgetFeature feature : features) {
            for (JsLibrary library : feature.getJsLibraries(RenderingContext.GADGET, container)) {
                if (!library.getType().equals((Object)JsLibrary.Type.URL)) continue;
                size += library.getContent().length();
            }
        }
        StringBuilder inlineJs = new StringBuilder(size);
        for (GadgetFeature feature : features) {
            for (JsLibrary library : feature.getJsLibraries(RenderingContext.GADGET, container)) {
                if (library.getType().equals((Object)JsLibrary.Type.URL)) {
                    if (inlineJs.length() > 0) {
                        Element inlineTag = headTag.getOwnerDocument().createElement("script");
                        headTag.appendChild(inlineTag);
                        inlineTag.appendChild(headTag.getOwnerDocument().createTextNode(inlineJs.toString()));
                        inlineJs.setLength(0);
                    }
                    Element referenceTag = headTag.getOwnerDocument().createElement("script");
                    referenceTag.setAttribute("src", library.getContent());
                    headTag.appendChild(referenceTag);
                    continue;
                }
                if (forced.contains(feature.getName())) continue;
                if (context.getDebug()) {
                    inlineJs.append(library.getDebugContent());
                } else {
                    inlineJs.append(library.getContent());
                }
                inlineJs.append(";\n");
            }
        }
        inlineJs.append(this.getLibraryConfig(gadget, features));
        if (inlineJs.length() > 0) {
            Element inlineTag = headTag.getOwnerDocument().createElement("script");
            headTag.appendChild(inlineTag);
            inlineTag.appendChild(headTag.getOwnerDocument().createTextNode(inlineJs.toString()));
        }
    }

    private Collection<GadgetFeature> getFeatures(Gadget gadget, Collection<String> forced) throws GadgetException {
        Map<String, Feature> features = gadget.getSpec().getModulePrefs().getFeatures();
        HashSet libs = Sets.newHashSet(features.keySet());
        if (!forced.isEmpty()) {
            libs.addAll(forced);
        }
        libs.removeAll(gadget.getRemovedFeatures());
        libs.addAll(gadget.getAddedFeatures());
        HashSet unsupported = Sets.newHashSet();
        Collection<GadgetFeature> feats = this.featureRegistry.getFeatures(libs, unsupported);
        unsupported.removeAll(forced);
        if (!unsupported.isEmpty()) {
            Iterator missingIter = unsupported.iterator();
            while (missingIter.hasNext()) {
                String missing = (String)missingIter.next();
                if (features.get(missing).getRequired()) continue;
                missingIter.remove();
            }
            if (!unsupported.isEmpty()) {
                throw new UnsupportedFeatureException(((Object)unsupported).toString());
            }
        }
        return feats;
    }

    private String getLibraryConfig(Gadget gadget, Collection<GadgetFeature> reqs) throws GadgetException {
        GadgetContext context = gadget.getContext();
        Map features = this.containerConfig.getMap(context.getContainer(), FEATURES_KEY);
        HashMap config = Maps.newHashMapWithExpectedSize((int)(features == null ? 2 : features.size() + 2));
        if (features != null) {
            for (GadgetFeature feature : reqs) {
                String name = feature.getName();
                Object conf = features.get(name);
                if (conf == null) continue;
                config.put(name, conf);
            }
        }
        this.addHasFeatureConfig(gadget, config);
        this.addOsapiSystemListMethodsConfig(gadget.getContext().getContainer(), config, gadget.getContext().getHost());
        this.addSecurityTokenConfig(context, config);
        return "gadgets.config.init(" + JsonSerializer.serialize((Map)config) + ");\n";
    }

    private void addSecurityTokenConfig(GadgetContext context, Map<String, Object> config) {
        SecurityToken authToken = context.getToken();
        if (authToken != null) {
            String trustedJson;
            HashMap authConfig = Maps.newHashMapWithExpectedSize((int)2);
            String updatedToken = authToken.getUpdatedToken();
            if (updatedToken != null) {
                authConfig.put("authToken", updatedToken);
            }
            if ((trustedJson = authToken.getTrustedJson()) != null) {
                authConfig.put("trustedJson", trustedJson);
            }
            config.put("shindig.auth", authConfig);
        }
    }

    private void addHasFeatureConfig(Gadget gadget, Map<String, Object> config) {
        ModulePrefs prefs = gadget.getSpec().getModulePrefs();
        Collection<Feature> features = prefs.getFeatures().values();
        HashMap featureMap = Maps.newHashMapWithExpectedSize((int)features.size());
        for (Feature feature : features) {
            HashMap paramFeaturesInConfig = Maps.newHashMap();
            for (String paramName : feature.getParams().keySet()) {
                Collection paramValues = feature.getParams().get((Object)paramName);
                if (paramValues.size() == 1) {
                    paramFeaturesInConfig.put(paramName, paramValues.iterator().next());
                    continue;
                }
                paramFeaturesInConfig.put(paramName, paramValues);
            }
            featureMap.put(feature.getName(), paramFeaturesInConfig);
        }
        config.put("core.util", featureMap);
    }

    private void addOsapiSystemListMethodsConfig(String container, Map<String, Object> config, String host) {
        if (this.rpcServiceLookup != null) {
            Multimap<String, String> endpoints = this.rpcServiceLookup.getServicesFor(container, host);
            config.put("osapi.services", endpoints);
        }
    }

    private void injectMessageBundles(Gadget gadget, Node scriptTag) throws GadgetException {
        GadgetContext context = gadget.getContext();
        MessageBundle bundle = this.messageBundleFactory.getBundle(gadget.getSpec(), context.getLocale(), context.getIgnoreCache());
        String msgs = bundle.toJSONString();
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.Prefs.setMessages_(");
        text.appendData(msgs);
        text.appendData(");");
        scriptTag.appendChild(text);
    }

    private void injectDefaultPrefs(Gadget gadget, Node scriptTag) {
        List<UserPref> prefs = gadget.getSpec().getUserPrefs();
        HashMap defaultPrefs = Maps.newHashMapWithExpectedSize((int)prefs.size());
        for (UserPref up : prefs) {
            defaultPrefs.put(up.getName(), up.getDefaultValue());
        }
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.Prefs.setDefaultPrefs_(");
        text.appendData(JsonSerializer.serialize((Map)defaultPrefs));
        text.appendData(");");
        scriptTag.appendChild(text);
    }

    private void injectPreloads(Gadget gadget, Node scriptTag) {
        ArrayList preload = Lists.newArrayList();
        for (PreloadedData preloaded : gadget.getPreloads()) {
            try {
                preload.addAll(preloaded.toJson());
            }
            catch (PreloadException pe) {
                LOG.log(Level.WARNING, "Unexpected error when preloading", pe);
            }
        }
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.io.preloaded_=");
        text.appendData(JsonSerializer.serialize((Collection)preload));
        text.appendData(";");
        scriptTag.appendChild(text);
    }
}

