/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import java.io.IOException;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.templates.TagHandler;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTagHandler
implements TagHandler {
    private final String tagName;
    private final String namespaceUri;

    public AbstractTagHandler(String namespaceUri, String tagName) {
        this.tagName = tagName;
        this.namespaceUri = namespaceUri;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    protected final <T> T getValueFromTag(Element tag, String name, TemplateProcessor processor, Class<T> type) {
        return processor.evaluate(tag.getAttribute(name), type, null);
    }

    protected final DocumentFragment processChildren(Element tag, TemplateProcessor processor) {
        DocumentFragment fragment = tag.getOwnerDocument().createDocumentFragment();
        processor.processChildNodes(fragment, tag);
        return fragment;
    }

    protected final void appendTextNode(Node parent, String text) {
        if (text == null || "".equals(text)) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder(text.length());
            HtmlSerialization.printEscapedText(text, sb);
            parent.appendChild(parent.getOwnerDocument().createTextNode(sb.toString()));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

