/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Color;
import org.apache.poi.ddf.EscherChildAnchorRecord;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.util.LittleEndian;

public class SimpleShape
extends Shape {
    protected SimpleShape(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherChildAnchorRecord anchor;
        EscherContainerRecord spContainer = new EscherContainerRecord();
        spContainer.setRecordId((short)-4092);
        spContainer.setOptions((short)15);
        EscherSpRecord sp = new EscherSpRecord();
        int flags = 2560;
        if (isChild) {
            flags |= 2;
        }
        sp.setFlags(flags);
        spContainer.addChildRecord((EscherRecord)sp);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-4085);
        spContainer.addChildRecord((EscherRecord)opt);
        if (isChild) {
            anchor = new EscherChildAnchorRecord();
        } else {
            anchor = new EscherClientAnchorRecord();
            byte[] header = new byte[16];
            LittleEndian.putUShort((byte[])header, (int)0, (int)0);
            LittleEndian.putUShort((byte[])header, (int)2, (int)0);
            LittleEndian.putInt((byte[])header, (int)4, (int)8);
            anchor.fillFields(header, 0, null);
        }
        spContainer.addChildRecord((EscherRecord)anchor);
        return spContainer;
    }

    public double getLineWidth() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 459);
        return prop == null ? 0.0 : (double)prop.getPropertyValue() / 12700.0;
    }

    public void setLineWidth(double width) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)459, (int)(width * 12700.0));
    }

    public void setLineColor(Color color) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
        SimpleShape.setEscherProperty(opt, (short)448, rgb);
        SimpleShape.setEscherProperty(opt, (short)511, color == null ? 0x180010 : 0x180018);
    }

    public Color getLineColor() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty p1 = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 448);
        EscherSimpleProperty p2 = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 511);
        int p2val = p2 == null ? 0 : p2.getPropertyValue();
        Color clr = null;
        if (p1 != null && (p2val & 8) != 0) {
            int rgb = p1.getPropertyValue();
            if (rgb >= 0x8000000) {
                int idx = rgb % 0x8000000;
                if (this.getSheet() != null) {
                    ColorSchemeAtom ca = this.getSheet().getColorScheme();
                    if (idx >= 0 && idx <= 7) {
                        rgb = ca.getColor(idx);
                    }
                }
            }
            Color tmp = new Color(rgb, true);
            clr = new Color(tmp.getBlue(), tmp.getGreen(), tmp.getRed());
        }
        return clr;
    }

    public int getLineDashing() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 462);
        return prop == null ? 1 : prop.getPropertyValue();
    }

    public void setLineDashing(int pen) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)462, pen == 1 ? -1 : pen);
    }

    public void setLineStyle(int style) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)461, style == 0 ? -1 : style);
    }

    public int getLineStyle() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 461);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public Color getFillColor() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty p1 = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 385);
        EscherSimpleProperty p2 = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 447);
        int p2val = p2 == null ? 0 : p2.getPropertyValue();
        Color clr = null;
        if (p1 != null && (p2val & 0x10) != 0) {
            int rgb = p1.getPropertyValue();
            if (rgb >= 0x8000000) {
                int idx = rgb % 0x8000000;
                if (this.getSheet() != null) {
                    ColorSchemeAtom ca = this.getSheet().getColorScheme();
                    rgb = ca.getColor(idx);
                }
            }
            Color tmp = new Color(rgb, true);
            clr = new Color(tmp.getBlue(), tmp.getGreen(), tmp.getRed());
        }
        return clr;
    }

    public void setFillColor(Color color) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
        SimpleShape.setEscherProperty(opt, (short)385, rgb);
        SimpleShape.setEscherProperty(opt, (short)447, color == null ? 0x150010 : 0x150011);
    }
}

