/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.deltav;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.version.Version;
import javax.ws.rs.core.Response;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UnCheckOutCommand {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.UnCheckOutCommand");

    public Response uncheckout(Session session, String path) {
        try {
            Node node = session.getRootNode().getNode(TextUtil.relativizePath(path));
            Version restoreVersion = node.getBaseVersion();
            node.restore(restoreVersion, true);
            return Response.ok().header("Cache-Control", (Object)"no-cache").build();
        }
        catch (UnsupportedRepositoryOperationException exc) {
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (LockException exc) {
            return Response.status((int)423).entity((Object)exc.getMessage()).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }
}

