/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheConfigPlugin;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.SimpleExoCache;
import org.exoplatform.services.cache.impl.CacheServiceManaged;
import org.exoplatform.services.cache.impl.LoggingCacheListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedBy(value=CacheServiceManaged.class)
public class CacheServiceImpl
implements CacheService {
    private final HashMap<String, ExoCacheConfig> configs_ = new HashMap();
    private final ConcurrentHashMap<String, ExoCache<? extends Serializable, ?>> cacheMap_ = new ConcurrentHashMap();
    private final ExoCacheConfig defaultConfig_;
    private final LoggingCacheListener loggingListener_;
    private final ExoCacheFactory factory_;
    CacheServiceManaged managed;

    public CacheServiceImpl(InitParams params) throws Exception {
        this(params, null);
    }

    public CacheServiceImpl(InitParams params, ExoCacheFactory factory) throws Exception {
        List configs = params.getObjectParamValues(ExoCacheConfig.class);
        for (ExoCacheConfig config : configs) {
            this.configs_.put(config.getName(), config);
        }
        this.defaultConfig_ = this.configs_.get("default");
        this.loggingListener_ = new LoggingCacheListener();
        this.factory_ = factory == null ? new SimpleExoCacheFactory() : factory;
    }

    public void addExoCacheConfig(ComponentPlugin plugin) {
        this.addExoCacheConfig((ExoCacheConfigPlugin)plugin);
    }

    @Override
    public void addExoCacheConfig(ExoCacheConfigPlugin plugin) {
        List<ExoCacheConfig> configs = plugin.getConfigs();
        for (ExoCacheConfig config : configs) {
            this.configs_.put(config.getName(), config);
        }
    }

    @Override
    public <K extends Serializable, V> ExoCache<K, V> getCacheInstance(String region) {
        if (region == null) {
            throw new NullPointerException("region cannot be null");
        }
        if (region.length() == 0) {
            throw new IllegalArgumentException("region cannot be empty");
        }
        ExoCache<? extends Serializable, ?> cache = this.cacheMap_.get(region);
        if (cache == null) {
            try {
                cache = this.createCacheInstance(region);
                ExoCache<Serializable, ?> existing = this.cacheMap_.putIfAbsent(region, cache);
                if (existing != null) {
                    cache = existing;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cache;
    }

    private synchronized ExoCache<? extends Serializable, ?> createCacheInstance(String region) throws Exception {
        ExoCacheConfig config = this.configs_.get(region);
        if (config == null) {
            config = this.defaultConfig_;
        }
        ExoCacheConfig safeConfig = config.clone();
        safeConfig.setName(region);
        ExoCache simple = this.factory_.createCache(safeConfig);
        if (this.managed != null) {
            this.managed.registerCache(simple);
        }
        return simple;
    }

    @Override
    public Collection<ExoCache<? extends Serializable, ?>> getAllCacheInstances() {
        return this.cacheMap_.values();
    }

    private class SimpleExoCacheFactory
    implements ExoCacheFactory {
        private SimpleExoCacheFactory() {
        }

        public ExoCache createCache(ExoCacheConfig config) throws ExoCacheInitException {
            ExoCache simple = this.createCacheInstance(config);
            simple.setName(config.getName());
            simple.setLabel(config.getLabel());
            simple.setMaxSize(config.getMaxSize());
            simple.setLiveTime(config.getLiveTime());
            simple.setLogEnabled(config.isLogEnabled());
            if (simple.isLogEnabled()) {
                simple.addCacheListener(CacheServiceImpl.this.loggingListener_);
            }
            return simple;
        }

        private ExoCache createCacheInstance(ExoCacheConfig config) throws ExoCacheInitException {
            if (config.getImplementation() == null) {
                return new SimpleExoCache();
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = cl.loadClass(config.getImplementation());
                return (ExoCache)clazz.newInstance();
            }
            catch (Exception e) {
                throw new ExoCacheInitException("Cannot create instance of ExoCache of type " + config.getImplementation(), e);
            }
        }
    }
}

