/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.services.cms.compress.CompressData;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/popup/admin/UIFormWithMultiRadioBox.gtmpl", events={@EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={ExportHistoryActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIExportNode
extends UIForm
implements UIPopupComponent {
    public static final String NODE_PATH = "nodePath";
    public static final String FORMAT = "format";
    public static final String ZIP = "zip";
    public static final String DOC_VIEW = "docview";
    public static final String SYS_VIEW = "sysview";
    public static final String VERSION_SQL_QUERY = "select * from mix:versionable where jcr:path like '$0/%' order by exo:dateCreated DESC";
    public static final String ROOT_SQL_QUERY = "select * from mix:versionable order by exo:dateCreated DESC";
    private boolean isVerionNode_ = false;

    public UIExportNode() throws Exception {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle resourceBundle = context.getApplicationResourceBundle();
        ArrayList<SelectItemOption> formatItem = new ArrayList<SelectItemOption>();
        formatItem.add(new SelectItemOption(resourceBundle.getString("Import.label.sysview"), (Object)SYS_VIEW));
        formatItem.add(new SelectItemOption(resourceBundle.getString("Import.label.docview"), (Object)DOC_VIEW));
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(NODE_PATH, NODE_PATH, null));
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(FORMAT, SYS_VIEW, formatItem).setAlign(UIFormRadioBoxInput.VERTICAL_ALIGN));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(ZIP, ZIP, null));
    }

    public void update(Node node) throws Exception {
        this.getUIFormInputInfo(NODE_PATH).setValue((Object)Text.unescapeIllegalJcrChars((String)node.getPath()));
    }

    public void activate() throws Exception {
        this.update(((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode());
    }

    public void deActivate() throws Exception {
    }

    public QueryResult getQueryResult(Node currentNode) throws RepositoryException {
        QueryManager queryManager = currentNode.getSession().getWorkspace().getQueryManager();
        String queryStatement = "";
        queryStatement = currentNode.getPath().equals("/") ? ROOT_SQL_QUERY : StringUtils.replace((String)VERSION_SQL_QUERY, (String)"$0", (String)currentNode.getPath());
        Query query = queryManager.createQuery(queryStatement, "sql");
        return query.execute();
    }

    public String[] getActions() {
        try {
            QueryResult queryResult;
            Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
            if (currentNode.isNodeType("mix:versionable")) {
                this.isVerionNode_ = true;
            }
            if ((queryResult = this.getQueryResult(currentNode)).getNodes().getSize() > 0L || this.isVerionNode_) {
                return new String[]{"Export", "ExportHistory", "Cancel"};
            }
        }
        catch (Exception e) {
            return new String[]{"Export", "Cancel"};
        }
        return new String[]{"Export", "Cancel"};
    }

    private String getHistoryValue(Node node) throws Exception {
        String versionHistory = node.getProperty("jcr:versionHistory").getValue().getString();
        String baseVersion = node.getProperty("jcr:baseVersion").getValue().getString();
        Value[] predecessors = node.getProperty("jcr:predecessors").getValues();
        StringBuilder historyValue = new StringBuilder();
        StringBuilder predecessorsBuilder = new StringBuilder();
        for (Value value : predecessors) {
            if (predecessorsBuilder.length() > 0) {
                predecessorsBuilder.append(",");
            }
            predecessorsBuilder.append(value.getString());
        }
        historyValue.append(node.getUUID()).append("=").append(versionHistory).append(";").append(baseVersion).append(";").append(predecessorsBuilder.toString());
        return historyValue.toString();
    }

    private static File getExportedFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix.concat(UUID.randomUUID().toString()), suffix);
    }

    private static class TempFileInputStream
    extends FileInputStream {
        private final File file;

        public TempFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
            try {
                file.deleteOnExit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void finalize() throws IOException {
            try {
                this.file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.finalize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIExportNode> {
        public void execute(Event<UIExportNode> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIExportNode)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExportHistoryActionListener
    extends EventListener<UIExportNode> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UIExportNode> event) throws Exception {
            UIExportNode uiExport = (UIExportNode)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiExport.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiExport.getAncestorOfType(UIApplication.class);
            CompressData zipService = new CompressData();
            DownloadService dservice = (DownloadService)uiExport.getApplicationComponent(DownloadService.class);
            Node currentNode = uiExplorer.getCurrentNode();
            String sysWsName = uiExplorer.getRepository().getConfiguration().getSystemWorkspaceName();
            Session session = uiExplorer.getSessionByWorkspace(sysWsName);
            QueryResult queryResult = uiExport.getQueryResult(currentNode);
            NodeIterator queryIter = queryResult.getNodes();
            String format = (String)((UIFormRadioBoxInput)uiExport.getUIInput(UIExportNode.FORMAT)).getValue();
            OutputStream out = null;
            BufferedInputStream in = null;
            ArrayList<File> lstExporedFile = new ArrayList<File>();
            File exportedFile = null;
            File zipFile = null;
            File propertiesFile = UIExportNode.getExportedFile("mapping", ".properties");
            BufferedOutputStream propertiesBOS = new BufferedOutputStream(new FileOutputStream(propertiesFile));
            BufferedInputStream propertiesBIS = new BufferedInputStream(new TempFileInputStream(propertiesFile));
            try {
                while (queryIter.hasNext()) {
                    exportedFile = UIExportNode.getExportedFile("data", ".xml");
                    lstExporedFile.add(exportedFile);
                    out = new BufferedOutputStream(new FileOutputStream(exportedFile));
                    in = new BufferedInputStream(new TempFileInputStream(exportedFile));
                    Node node = queryIter.nextNode();
                    String historyValue = uiExport.getHistoryValue(node);
                    ((OutputStream)propertiesBOS).write(historyValue.getBytes());
                    ((OutputStream)propertiesBOS).write(10);
                    if (format.equals(UIExportNode.DOC_VIEW)) {
                        session.exportDocumentView(node.getVersionHistory().getPath(), out, false, false);
                    } else {
                        session.exportSystemView(node.getVersionHistory().getPath(), out, false, false);
                    }
                    out.flush();
                    zipService.addInputStream(node.getUUID() + ".xml", (InputStream)in);
                }
                if (currentNode.isNodeType("mix:versionable")) {
                    exportedFile = UIExportNode.getExportedFile("data", ".xml");
                    lstExporedFile.add(exportedFile);
                    out = new BufferedOutputStream(new FileOutputStream(exportedFile));
                    in = new BufferedInputStream(new TempFileInputStream(exportedFile));
                    String historyValue = uiExport.getHistoryValue(currentNode);
                    ((OutputStream)propertiesBOS).write(historyValue.getBytes());
                    ((OutputStream)propertiesBOS).write(10);
                    if (format.equals(UIExportNode.DOC_VIEW)) {
                        session.exportDocumentView(currentNode.getVersionHistory().getPath(), out, false, false);
                    } else {
                        session.exportSystemView(currentNode.getVersionHistory().getPath(), out, false, false);
                    }
                    out.flush();
                    zipService.addInputStream(currentNode.getUUID() + ".xml", (InputStream)in);
                }
                ((OutputStream)propertiesBOS).flush();
                zipService.addInputStream("mapping.properties", (InputStream)propertiesBIS);
                zipFile = UIExportNode.getExportedFile("data", UIExportNode.ZIP);
                in = new BufferedInputStream(new TempFileInputStream(zipFile));
                out = new BufferedOutputStream(new FileOutputStream(zipFile));
                out.flush();
                zipService.createZip(out);
                InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)in, "application/zip");
                dresource.setDownloadName(format + "_versionHistory.zip");
                String downloadLink = dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
                event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
            }
            catch (OutOfMemoryError error) {
                uiApp.addMessage(new ApplicationMessage("UIExportNode.msg.OutOfMemoryError", null, 0));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            finally {
                ((OutputStream)propertiesBOS).close();
                ((InputStream)propertiesBIS).close();
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExportActionListener
    extends EventListener<UIExportNode> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UIExportNode> event) throws Exception {
            UIExportNode uiExport = (UIExportNode)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiExport.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiExport.getAncestorOfType(UIApplication.class);
            File exportedFile = UIExportNode.getExportedFile("export", ".xml");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(exportedFile));
            BufferedInputStream in = new BufferedInputStream(new TempFileInputStream(exportedFile));
            CompressData zipService = new CompressData();
            DownloadService dservice = (DownloadService)uiExport.getApplicationComponent(DownloadService.class);
            String format = (String)((UIFormRadioBoxInput)uiExport.getUIInput(UIExportNode.FORMAT)).getValue();
            boolean isZip = uiExport.getUIFormCheckBoxInput(UIExportNode.ZIP).isChecked();
            Node currentNode = uiExplorer.getCurrentNode();
            Session session = currentNode.getSession();
            String nodePath = currentNode.getPath();
            File zipFile = null;
            try {
                InputStreamDownloadResource dresource;
                if (isZip) {
                    if (format.equals(UIExportNode.DOC_VIEW)) {
                        session.exportDocumentView(nodePath, (OutputStream)out, false, false);
                    } else {
                        session.exportSystemView(nodePath, (OutputStream)out, false, false);
                    }
                    ((OutputStream)out).flush();
                    ((OutputStream)out).close();
                    zipFile = UIExportNode.getExportedFile("data", ".zip");
                    out = new BufferedOutputStream(new FileOutputStream(zipFile));
                    zipService.addInputStream(format + ".xml", (InputStream)in);
                    zipService.createZip((OutputStream)out);
                    ((InputStream)in).close();
                    exportedFile.delete();
                    in = new BufferedInputStream(new TempFileInputStream(zipFile));
                    dresource = new InputStreamDownloadResource((InputStream)in, "application/zip");
                    dresource.setDownloadName(format + ".zip");
                } else {
                    if (format.equals(UIExportNode.DOC_VIEW)) {
                        session.exportDocumentView(nodePath, (OutputStream)out, false, false);
                    } else {
                        session.exportSystemView(nodePath, (OutputStream)out, false, false);
                    }
                    ((OutputStream)out).flush();
                    dresource = new InputStreamDownloadResource((InputStream)in, "text/xml");
                    dresource.setDownloadName(format + ".xml");
                }
                String downloadLink = dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
                event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
                uiExplorer.cancelAction();
            }
            catch (OutOfMemoryError error) {
                uiApp.addMessage(new ApplicationMessage("UIExportNode.msg.OutOfMemoryError", null, 0));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            finally {
                ((OutputStream)out).close();
            }
        }
    }
}

