/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.util.ClassLoaderUtil;

public class ExceptionHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    protected String exceptionClassName = null;
    protected GraphElement graphElement = null;
    protected List actions = null;

    public boolean matches(Throwable exception) {
        Class clazz;
        boolean matches = true;
        if (this.exceptionClassName != null && !(clazz = ClassLoaderUtil.classForName(this.exceptionClassName)).isAssignableFrom(exception.getClass())) {
            matches = false;
        }
        return matches;
    }

    public void handleException(GraphElement graphElement, ExecutionContext executionContext) throws Exception {
        if (this.actions != null) {
            Iterator iter = this.actions.iterator();
            while (iter.hasNext()) {
                Action action = (Action)iter.next();
                graphElement.executeAction(action, executionContext);
            }
        }
    }

    public List getActions() {
        return this.actions;
    }

    public void addAction(Action action) {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        this.actions.add(action);
    }

    public void removeAction(Action action) {
        if (this.actions != null) {
            this.actions.remove(action);
        }
    }

    public void reorderAction(int oldIndex, int newIndex) {
        if (this.actions != null) {
            this.actions.add(newIndex, this.actions.remove(oldIndex));
        }
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String exceptionClassName) {
        this.exceptionClassName = exceptionClassName;
    }

    public GraphElement getGraphElement() {
        return this.graphElement;
    }
}

