/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2.maven2;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.ModelLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.jvnet.jaxb2.maven2.XJC2MojoClassLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public abstract class AbstractXJC2Mojo
extends AbstractMojo {
    protected List schemaFiles = new ArrayList();
    protected List bindingFiles = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeImp() throws MojoExecutionException {
        try {
            this.setupLogging();
            Options xjcOpts = this.setupOptions();
            if (this.isVerbose()) {
                this.logSettings();
            }
            this.updateMavenPaths();
            if (!this.isForceRegenerate() && this.isUpdToDate()) {
                this.getLog().info((CharSequence)"Skipped XJC execution.  Generated sources were up-to-date.");
                return;
            }
            if (this.isRemoveOldOutput()) {
                if (this.getGenerateDirectory().exists()) {
                    try {
                        FileUtils.deleteDirectory((File)this.getGenerateDirectory());
                        this.getLog().info((CharSequence)("Removed old generateDirectory '" + this.getGenerateDirectory() + "'."));
                    }
                    catch (IOException ex) {
                        this.getLog().warn((CharSequence)("Failed to remove old generateDirectory '" + this.getGenerateDirectory() + "' due to: " + ex));
                    }
                } else if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Skipped removal of old generateDirectory '" + this.getGenerateDirectory() + "' since it didn't exist."));
                }
            }
            if (this.getGenerateDirectory() != null && !this.getGenerateDirectory().exists()) {
                this.getGenerateDirectory().mkdirs();
            }
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getProjectDepsClassLoader(oldCL));
            try {
                this.runXJC(xjcOpts);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            this.getLog().info((CharSequence)("Succesfully generated output to: " + xjcOpts.targetDir));
        }
        catch (RuntimeException ex) {
            this.getLog().info((CharSequence)"Mojo options will be logged due to an unexpected error...");
            this.logSettings();
            throw ex;
        }
        catch (MojoExecutionException ex) {
            throw ex;
        }
    }

    protected Options setupOptions() throws MojoExecutionException {
        Options xjcOpts = new Options();
        xjcOpts.verbose = this.isVerbose();
        xjcOpts.debugMode = this.isDebug();
        if (!AbstractXJC2Mojo.isDefined(this.getSchemaLanguage(), 1)) {
            this.setSchemaLanguage("AUTODETECT");
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)"The <schemaLanguage> setting was not defined, assuming 'AUTODETECT'.");
            }
        } else if (!"AUTODETECT".equalsIgnoreCase(this.getSchemaLanguage())) {
            if ("XMLSCHEMA".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
            } else if ("DTD".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(Language.DTD);
            } else if ("RELAXNG".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(Language.RELAXNG);
            } else if ("RELAXNG_COMPACT".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(Language.RELAXNG_COMPACT);
            } else if ("WSDL".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(Language.WSDL);
            } else {
                this.logSettings();
                throw new MojoExecutionException("Unknown <schemaLanguage> '" + this.getSchemaLanguage() + "'!");
            }
        }
        List files = this.gatherFiles(this.getSchemaDirectory(), this.getSchemaIncludes(), this.getSchemasExcludes());
        Iterator it = files.iterator();
        while (it.hasNext()) {
            xjcOpts.addGrammar(AbstractXJC2Mojo.getInputSource((File)it.next()));
        }
        this.schemaFiles.addAll(files);
        if (this.schemaFiles.size() == 0) {
            this.logSettings();
            throw new MojoExecutionException("No schemas found inside the <schemaDirectory> '" + this.getSchemaDirectory() + "'!");
        }
        if (!AbstractXJC2Mojo.isDefined(this.getBindingDirectory(), 1)) {
            this.setBindingDirectory(this.getSchemaDirectory());
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("The <bindingDirectory> setting was not defined, assuming the same as <schemaDirectory>: " + this.getSchemaDirectory() + ""));
            }
        }
        files = this.gatherFiles(this.getBindingDirectory(), this.getBindingIncludes(), this.getBindingExcludes());
        it = files.iterator();
        while (it.hasNext()) {
            xjcOpts.addBindFile(AbstractXJC2Mojo.getInputSource((File)it.next()));
        }
        this.bindingFiles.addAll(files);
        if (AbstractXJC2Mojo.isDefined(this.getCatalog(), 1)) {
            try {
                xjcOpts.addCatalog(this.getCatalog());
            }
            catch (IOException ex) {
                this.logSettings();
                throw new MojoExecutionException("Error while setting the <catalog> to '" + this.getCatalog() + "'!", (Exception)ex);
            }
        }
        xjcOpts.defaultPackage = this.getGeneratePackage();
        xjcOpts.targetDir = this.getGenerateDirectory();
        xjcOpts.strictCheck = this.isStrict();
        xjcOpts.readOnly = this.isReadOnly();
        if (this.isExtension()) {
            xjcOpts.compatibilityMode = 2;
        }
        this.setupCmdLineArgs(xjcOpts);
        return xjcOpts;
    }

    protected void setupCmdLineArgs(Options xjcOpts) throws MojoExecutionException {
        if (AbstractXJC2Mojo.isDefined(this.getArgs(), 1)) {
            try {
                xjcOpts.parseArguments(this.getArgs().toArray(new String[this.getArgs().size()]));
            }
            catch (BadCommandLineException ex) {
                throw new MojoExecutionException("Error while setting CmdLine <args> options '" + this.getArgs() + "'!", (Exception)((Object)ex));
            }
        }
    }

    protected void setupLogging() {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            this.setDebug(true);
        }
        if (this.isDebug()) {
            this.setVerbose(true);
            System.setProperty("com.sun.tools.xjc.Options.findServices", "true");
        }
    }

    protected void logSettings() {
        StringBuffer sb = new StringBuffer();
        sb.append("Plugin's mojo parameters: ");
        this.logUserSettings(sb);
        sb.append("\nCalculated options: ");
        this.logCalcSettings(sb);
        this.getLog().info((CharSequence)sb);
    }

    protected void logUserSettings(StringBuffer sb) {
        sb.append("\n\tschemaLanguage: " + this.getSchemaLanguage());
        sb.append("\n\tschemaDirectory: " + this.getSchemaDirectory());
        sb.append("\n\tincludeSchemas: " + AbstractXJC2Mojo.recursiveToString(this.getSchemaIncludes()));
        sb.append("\n\texcludeSchemas: " + AbstractXJC2Mojo.recursiveToString(this.getSchemasExcludes()));
        sb.append("\n\tbindingDirectory: " + this.getBindingDirectory());
        sb.append("\n\tincludeBindings: " + AbstractXJC2Mojo.recursiveToString(this.getBindingIncludes()));
        sb.append("\n\texcludeBindings: " + AbstractXJC2Mojo.recursiveToString(this.getBindingExcludes()));
        sb.append("\n\tdisableDefaultExcludes: " + this.isDisableDefaultExcludes());
        sb.append("\n\tcatalog: " + this.getCatalog());
        sb.append("\n\tdefaultPackage: " + this.getGeneratePackage());
        sb.append("\n\tdestinationDirectory: " + this.getGenerateDirectory());
        sb.append("\n\tforceRegenerate: " + this.isForceRegenerate());
        sb.append("\n\totherDepends: " + AbstractXJC2Mojo.recursiveToString(this.getOtherDepends()));
        sb.append("\n\tremoveOldOutput: " + this.isRemoveOldOutput());
        sb.append("\n\twriteCode: " + this.isWriteCode());
        sb.append("\n\treadOnly: " + this.isReadOnly());
        sb.append("\n\textension: " + this.isExtension());
        sb.append("\n\tstrict: " + this.isStrict());
        sb.append("\n\tverbose: " + this.isVerbose());
        sb.append("\n\tdebug: " + this.isDebug());
        sb.append("\n\txjcArgs: " + AbstractXJC2Mojo.recursiveToString(this.getArgs()));
    }

    protected void logCalcSettings(StringBuffer sb) {
        sb.append("\n\tSchema File(s): " + AbstractXJC2Mojo.recursiveToString(this.schemaFiles));
        sb.append("\n\tBinding File(s): " + AbstractXJC2Mojo.recursiveToString(this.bindingFiles));
        sb.append("\n\tClassPath: " + AbstractXJC2Mojo.recursiveToString(this.getClasspathElements()));
    }

    protected boolean isUpdToDate() throws MojoExecutionException {
        ArrayList dependsFiles = new ArrayList();
        ArrayList producesFiles = new ArrayList();
        this.gatherDependsFiles(dependsFiles);
        if (this.isVerbose() && !this.isDebug()) {
            this.getLog().info((CharSequence)("Checking up-to-date depends: " + AbstractXJC2Mojo.recursiveToString(dependsFiles)));
        }
        this.gatherProducesFiles(producesFiles);
        if (this.isVerbose() && !this.isDebug()) {
            this.getLog().info((CharSequence)("Checking up-to-date produces: " + AbstractXJC2Mojo.recursiveToString(producesFiles)));
        }
        long inputTimeStamp = this.findLastModified(dependsFiles, true);
        long destTimeStamp = this.findLastModified(producesFiles, false);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Depends timeStamp: " + inputTimeStamp + ", produces timestamp: " + destTimeStamp));
        }
        return inputTimeStamp < destTimeStamp;
    }

    protected void gatherDependsFiles(List inputFiles) {
        inputFiles.addAll(this.schemaFiles);
        inputFiles.addAll(this.bindingFiles);
        if (this.getCatalog() != null) {
            inputFiles.add(this.getCatalog());
        }
        if (this.getProject() != null) {
            inputFiles.add(this.getProject().getFile());
        }
        if (this.getOtherDepends() != null) {
            inputFiles.addAll(Arrays.asList(this.getOtherDepends()));
        }
    }

    protected void gatherProducesFiles(List destFiles) throws MojoExecutionException {
        if (this.getGenerateDirectory().exists()) {
            if (!this.getGenerateDirectory().isDirectory()) {
                this.getLog().warn((CharSequence)("The <generateDirectory>='" + this.getGenerateDirectory() + "' is not a directory!  Probably XJC will fail..."));
            } else {
                destFiles.addAll(this.gatherFiles(this.getGenerateDirectory(), new String[]{"**/*.java", "**/bgm.ser", "**/jaxb.properties"}, null));
            }
        }
    }

    private ClassLoader getProjectDepsClassLoader(ClassLoader parent) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.getClasspathElements() != null) {
            for (String pathElem : this.getClasspathElements()) {
                try {
                    urls.add(new File(pathElem).toURL());
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("Internal classpath element '" + pathElem + "' is was skiped due to: " + AbstractXJC2Mojo.getAllExMsgs(e, true)));
                }
            }
        }
        XJC2MojoClassLoader cl = new XJC2MojoClassLoader(urls.toArray(new URL[urls.size()]), parent);
        return cl;
    }

    protected void runXJC(Options xjcOpts) throws MojoExecutionException {
        JaxbErrorReceiver4Mvn errorReceiver = new JaxbErrorReceiver4Mvn();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"Parsing input schema(s)...");
        }
        errorReceiver.stage = "parsing";
        Model model = ModelLoader.load((Options)xjcOpts, (JCodeModel)new JCodeModel(), (ErrorReceiver)errorReceiver);
        if (model == null) {
            throw new MojoExecutionException("Unable to parse input schema(s).  Error messages should have been provided.");
        }
        try {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)"Compiling input schema(s)...");
            }
            errorReceiver.stage = "compiling";
            Outline outline = model.generateCode(xjcOpts, (ErrorReceiver)errorReceiver);
            if (outline == null) {
                throw new MojoExecutionException("Failed to compile input schema(s)!  Error messages should have been provided.");
            }
            if (this.isWriteCode()) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Writing output to: " + xjcOpts.targetDir));
                }
                model.codeModel.build((CodeWriter)new JaxbCodeWriter4Mvn(xjcOpts.createCodeWriter()));
            } else if (this.isVerbose()) {
                this.getLog().info((CharSequence)"Code will not be written.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write files: " + e.getMessage(), (Exception)e);
        }
    }

    protected void updateMavenPaths() {
        if (this.getProject() != null) {
            this.getProject().addCompileSourceRoot(this.getGenerateDirectory().getPath());
        }
        Resource jaxbRes = new Resource();
        jaxbRes.setDirectory(this.getGenerateDirectory().getPath());
        jaxbRes.addInclude("**/jaxb.properties");
        jaxbRes.addInclude("**/bgm.ser");
        if (this.getProject() != null) {
            this.getProject().addResource(jaxbRes);
        }
    }

    protected long findLastModified(List files, boolean oldest) {
        long timeStamp = oldest ? Long.MIN_VALUE : Long.MAX_VALUE;
        for (Object no : files) {
            long fileModifTime;
            if (no == null) continue;
            if (no instanceof String) {
                String sdep = (String)no;
                try {
                    URL url = new URL(sdep);
                    URLConnection uCon = url.openConnection();
                    uCon.setUseCaches(false);
                    fileModifTime = uCon.getLastModified();
                }
                catch (MalformedURLException e) {
                    fileModifTime = new File(sdep).lastModified();
                }
                catch (IOException ex) {
                    fileModifTime = oldest ? Long.MIN_VALUE : Long.MAX_VALUE;
                    this.getLog().warn((CharSequence)("Skipping URL '" + no + "' from up-to-date check due to error while opening connection: " + AbstractXJC2Mojo.getAllExMsgs(ex, true)));
                }
            } else {
                fileModifTime = ((File)no).lastModified();
            }
            if (this.isDebug()) {
                this.getLog().info((CharSequence)((oldest ? "Depends " : "Produces ") + no + ": " + new Date(fileModifTime)));
            }
            if (!(fileModifTime > timeStamp ^ !oldest)) continue;
            timeStamp = fileModifTime;
        }
        if (timeStamp == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (timeStamp == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return timeStamp;
    }

    protected static InputSource getInputSource(File f) {
        try {
            return new InputSource(f.toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            return new InputSource(f.getPath());
        }
    }

    protected List gatherFiles(File baseDir, String[] includesPattern, String[] excludesPattern) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir.getAbsoluteFile());
        scanner.setIncludes(includesPattern);
        scanner.setExcludes(this.getExcludes(excludesPattern));
        scanner.scan();
        ArrayList<File> files = new ArrayList<File>();
        String[] incFiles = scanner.getIncludedFiles();
        for (int i = 0; i < incFiles.length; ++i) {
            String name = incFiles[i];
            try {
                File file = new File(baseDir, name);
                files.add(file.getCanonicalFile());
                continue;
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Unable to canonize the file [" + name + "]");
            }
        }
        return files;
    }

    protected String[] getExcludes(String[] origExcludes) {
        if (origExcludes == null) {
            return null;
        }
        List newExc = this.getExcludes(Arrays.asList(origExcludes));
        return newExc.toArray(new String[newExc.size()]);
    }

    protected List getExcludes(List origExcludes) {
        if (origExcludes == null || this.isDisableDefaultExcludes()) {
            return origExcludes;
        }
        origExcludes.addAll(Arrays.asList(FileUtils.getDefaultExcludes()));
        return origExcludes;
    }

    protected static boolean isDefined(Object setting, int minimumLength) {
        boolean defined;
        boolean bl = defined = setting != null;
        defined = setting instanceof Object[] ? defined && ((Object[])setting).length >= minimumLength : (setting instanceof Collection ? defined && ((Collection)setting).size() >= minimumLength : defined && setting.toString().trim().length() >= minimumLength);
        return defined;
    }

    protected static String recursiveToString(Object setting) {
        if (setting == null) {
            return "null";
        }
        if (setting instanceof Collection) {
            Collection collection = (Collection)setting;
            setting = collection.toArray();
        }
        if (setting instanceof Object[]) {
            Object[] settingArray = setting;
            if (settingArray.length == 0) {
                return "[]";
            }
            StringBuffer result = new StringBuffer();
            result.append('[');
            result.append(AbstractXJC2Mojo.recursiveToString(settingArray[0]));
            for (int index = 1; index < settingArray.length; ++index) {
                result.append(", ");
                result.append(AbstractXJC2Mojo.recursiveToString(settingArray[index]));
            }
            result.append(']');
            return result.toString();
        }
        return setting.toString();
    }

    public static String getAllExMsgs(Throwable ex, boolean includeExName) {
        StringBuffer sb = new StringBuffer(includeExName ? ex.toString() : ex.getLocalizedMessage());
        while ((ex = ex.getCause()) != null) {
            sb.append("\nCaused by: " + ex.toString());
        }
        return sb.toString();
    }

    public abstract void setSchemaLanguage(String var1);

    public abstract String getSchemaLanguage();

    public abstract void setSchemaDirectory(File var1);

    public abstract File getSchemaDirectory();

    public abstract void setSchemaIncludes(String[] var1);

    public abstract String[] getSchemaIncludes();

    public abstract void setSchemasExcludes(String[] var1);

    public abstract String[] getSchemasExcludes();

    public abstract void setBindingDirectory(File var1);

    public abstract File getBindingDirectory();

    public abstract void setBindingIncludes(String[] var1);

    public abstract String[] getBindingIncludes();

    public abstract void setBindingExcludes(String[] var1);

    public abstract String[] getBindingExcludes();

    public abstract void setDisableDefaultExcludes(boolean var1);

    public abstract boolean isDisableDefaultExcludes();

    public abstract void setCatalog(File var1);

    public abstract File getCatalog();

    public abstract void setGeneratePackage(String var1);

    public abstract String getGeneratePackage();

    public abstract void setGenerateDirectory(File var1);

    public abstract File getGenerateDirectory();

    public abstract void setReadOnly(boolean var1);

    public abstract boolean isReadOnly();

    public abstract void setExtension(boolean var1);

    public abstract boolean isExtension();

    public abstract void setStrict(boolean var1);

    public abstract boolean isStrict();

    public abstract void setWriteCode(boolean var1);

    public abstract boolean isWriteCode();

    public abstract void setVerbose(boolean var1);

    public abstract boolean isVerbose();

    public abstract void setDebug(boolean var1);

    public abstract boolean isDebug();

    public abstract void setArgs(List var1);

    public abstract List getArgs();

    public abstract void setForceRegenerate(boolean var1);

    public abstract boolean isForceRegenerate();

    public abstract void setRemoveOldOutput(boolean var1);

    public abstract boolean isRemoveOldOutput();

    public abstract void setOtherDepends(String[] var1);

    public abstract String[] getOtherDepends();

    public abstract List getClasspathElements();

    public abstract MavenProject getProject();

    private class JaxbCodeWriter4Mvn
    extends CodeWriter {
        private final CodeWriter output;

        public JaxbCodeWriter4Mvn(CodeWriter output) {
            this.output = output;
        }

        public Writer openSource(JPackage pkg, String fileName) throws IOException {
            if (AbstractXJC2Mojo.this.isVerbose()) {
                if (pkg.isUnnamed()) {
                    AbstractXJC2Mojo.this.getLog().info((CharSequence)("XJC writing: " + fileName));
                } else {
                    AbstractXJC2Mojo.this.getLog().info((CharSequence)("XJC writing: " + pkg.name().replace('.', File.separatorChar) + File.separatorChar + fileName));
                }
            }
            return this.output.openSource(pkg, fileName);
        }

        public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
            if (AbstractXJC2Mojo.this.isVerbose()) {
                if (pkg.isUnnamed()) {
                    AbstractXJC2Mojo.this.getLog().info((CharSequence)("XJC writing: " + fileName));
                } else {
                    AbstractXJC2Mojo.this.getLog().info((CharSequence)("XJC writing: " + pkg.name().replace('.', File.separatorChar) + File.separatorChar + fileName));
                }
            }
            return this.output.openBinary(pkg, fileName);
        }

        public void close() throws IOException {
            this.output.close();
        }
    }

    protected class JaxbErrorReceiver4Mvn
    extends ErrorReceiver {
        public String stage = "processing";

        protected JaxbErrorReceiver4Mvn() {
        }

        public void warning(SAXParseException e) {
            AbstractXJC2Mojo.this.getLog().warn((CharSequence)this.makeMessage(e, true));
        }

        public void error(SAXParseException e) {
            AbstractXJC2Mojo.this.getLog().error((CharSequence)this.makeMessage(e, true));
        }

        public void fatalError(SAXParseException e) {
            AbstractXJC2Mojo.this.getLog().error((CharSequence)this.makeMessage(e, true));
        }

        public void info(SAXParseException e) {
            if (AbstractXJC2Mojo.this.isVerbose()) {
                AbstractXJC2Mojo.this.getLog().info((CharSequence)this.makeMessage(e, false));
            }
        }

        private String makeMessage(SAXParseException ex, boolean printExName) {
            String exString;
            int row = ex.getLineNumber();
            int col = ex.getColumnNumber();
            String sys = ex.getSystemId();
            String pub = ex.getPublicId();
            if (AbstractXJC2Mojo.this.isDebug()) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                exString = sw.toString();
            } else {
                exString = AbstractXJC2Mojo.getAllExMsgs(ex, printExName);
            }
            return "XJC while " + this.stage + " schema(s)" + (sys != null ? " " + sys : "") + (pub != null ? " " + pub : "") + (row > 0 ? "[" + row + (col > 0 ? "," + col : "") + "]" : "") + ": " + exString;
        }
    }
}

