/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter.handler;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterTemplateHandler {
    private static Log log = ExoLogger.getLogger(NewsletterTemplateHandler.class);
    private RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
    private String repository;
    private String workspace;
    private List<Node> templates;

    public NewsletterTemplateHandler(String repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
    }

    public List<Node> getTemplates(SessionProvider sessionProvider, String portalName, NewsletterCategoryConfig categoryConfig) {
        log.info((Object)("Trying to get templates of category " + categoryConfig));
        try {
            ArrayList<Node> templates = new ArrayList<Node>();
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            Node defaultTemplateFolder = (Node)session.getItem(NewsletterConstant.generateDefaultTemplatePath(portalName));
            NodeIterator defaultTemplates = defaultTemplateFolder.getNodes();
            while (defaultTemplates.hasNext()) {
                templates.add(defaultTemplates.nextNode());
            }
            if (categoryConfig != null) {
                Node categoryTemplateFolder = (Node)session.getItem(NewsletterConstant.generateCategoryTemplateBasePath(portalName, categoryConfig.getName()));
                NodeIterator categoryTemplates = categoryTemplateFolder.getNodes();
                while (categoryTemplates.hasNext()) {
                    templates.add(categoryTemplates.nextNode());
                }
            }
            this.templates = templates;
            return templates;
        }
        catch (Exception e) {
            log.error((Object)("Get templates of category " + categoryConfig + " failed because of "), e.fillInStackTrace());
            return null;
        }
    }

    public Node getTemplate(SessionProvider sessionProvider, String portalName, NewsletterCategoryConfig categoryConfig, String templateName) {
        log.info((Object)("Trying to get template " + templateName));
        try {
            if (this.templates == null) {
                this.templates = this.getTemplates(sessionProvider, portalName, categoryConfig);
            }
            if (templateName == null && this.templates.size() > 0) {
                return this.templates.get(0);
            }
            for (Node template : this.templates) {
                if (!templateName.equals(template.getName())) continue;
                return template;
            }
        }
        catch (Exception e) {
            log.error((Object)("Get dialog " + templateName + " failed because of "), e.fillInStackTrace());
        }
        return null;
    }

    public void convertAsTemplate(SessionProvider sessionProvider, String webcontentPath, String portalName, String categoryName) throws Exception {
        log.info((Object)("Trying to convert node " + webcontentPath + " to template at category " + categoryName));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            Node categoryTemplateFolder = (Node)session.getItem(NewsletterConstant.generateCategoryTemplateBasePath(portalName, categoryName));
            String templateName = webcontentPath.substring(webcontentPath.lastIndexOf("/") + 1);
            if (categoryTemplateFolder.hasNode(templateName)) {
                throw new Exception("Same name");
            }
            session.getWorkspace().copy(webcontentPath, categoryTemplateFolder.getPath() + "/" + templateName);
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Convert node " + webcontentPath + " to template at category " + categoryName + " failed because of "), e.fillInStackTrace());
            throw e;
        }
    }
}

